/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGo3DNoteRect;
import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoIdentifiablePart;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoText;
import java.awt.Color;
import java.awt.Insets;

public class Comment
extends JGoArea
implements JGoIdentifiablePart {
    private Insets myInsets = new Insets(2, 4, 8, 8);
    public static final int ChangedPartID = 65836;
    private int myPartID = -1;
    private JGoText myLabel = null;
    private JGo3DNoteRect myRect = null;

    public Comment() {
    }

    public Comment(String string) {
        this.initialize(string);
    }

    public void initialize(String string) {
        this.setResizable(false);
        this.myRect = new JGo3DNoteRect();
        this.myRect.setSelectable(false);
        this.myRect.setPen(JGoPen.lightGray);
        this.myRect.setBrush(JGoBrush.makeStockBrush(new Color(255, 255, 204)));
        this.myLabel = new JGoText(string);
        this.myLabel.setMultiline(true);
        this.myLabel.setSelectable(false);
        this.myLabel.setResizable(false);
        this.myLabel.setDraggable(false);
        this.myLabel.setEditable(false);
        this.myLabel.setEditOnSingleClick(true);
        this.myLabel.setTransparent(true);
        this.addObjectAtHead(this.myRect);
        this.addObjectAtTail(this.myLabel);
    }

    protected void copyChildren(JGoArea jGoArea, JGoCopyEnvironment jGoCopyEnvironment) {
        Comment comment = (Comment)jGoArea;
        comment.myPartID = this.myPartID;
        super.copyChildren(jGoArea, jGoCopyEnvironment);
        comment.myRect = (JGo3DNoteRect)jGoCopyEnvironment.get(this.myRect);
        comment.myLabel = (JGoText)jGoCopyEnvironment.get(this.myLabel);
    }

    public JGoObject removeObjectAtPos(JGoListPosition jGoListPosition) {
        JGoObject jGoObject = super.removeObjectAtPos(jGoListPosition);
        if (jGoObject == this.myRect) {
            this.myRect = null;
        } else if (jGoObject == this.myLabel) {
            this.myLabel = null;
        }
        return jGoObject;
    }

    public void layoutChildren(JGoObject jGoObject) {
        JGo3DNoteRect jGo3DNoteRect;
        JGoText jGoText = this.getLabel();
        if (jGoText != null && (jGo3DNoteRect = this.getRect()) != null) {
            Insets insets = this.getInsets();
            if (this.isResizable()) {
                int n = Math.max(jGo3DNoteRect.getWidth() - (insets.left + insets.right), 0);
                int n2 = Math.max(jGo3DNoteRect.getHeight() - (insets.top + insets.bottom), 0);
                jGoText.setClipping(true);
                jGoText.setWidth(n);
                jGoText.setWrappingWidth(n);
                int n3 = Math.min(jGoText.getHeight(), n2);
                int n4 = jGo3DNoteRect.getLeft() + insets.left;
                int n5 = jGo3DNoteRect.getTop() + insets.top;
                jGoText.setBoundingRect(n4, n5, n, n3);
            } else {
                jGoText.setClipping(false);
                jGo3DNoteRect.setBoundingRect(jGoText.getLeft() - insets.left, jGoText.getTop() - insets.top, jGoText.getWidth() + insets.left + insets.right, jGoText.getHeight() + insets.top + insets.bottom);
            }
        }
    }

    public Insets getInsets() {
        return this.myInsets;
    }

    public void SVGUpdateReference(String string, Object object) {
        super.SVGUpdateReference(string, object);
        if (string.equals("rectobj")) {
            this.myRect = (JGo3DNoteRect)object;
        } else if (string.equals("label")) {
            this.myLabel = (JGoText)object;
        }
    }

    public void SVGWriteObject(DomDoc domDoc, DomElement domElement) {
        if (domDoc.JGoXMLOutputEnabled()) {
            DomElement domElement2 = domDoc.createJGoClassElement("com.nwoods.jgo.examples.Comment", domElement);
            domElement2.setAttribute("partid", Integer.toString(this.myPartID));
            if (this.myRect != null) {
                domDoc.registerReferencingNode(domElement2, "rectobj", this.myRect);
            }
            if (this.myLabel != null) {
                domDoc.registerReferencingNode(domElement2, "label", this.myLabel);
            }
        }
        super.SVGWriteObject(domDoc, domElement);
    }

    public DomNode SVGReadObject(DomDoc domDoc, JGoDocument jGoDocument, DomElement domElement, DomElement domElement2) {
        if (domElement2 != null) {
            String string = domElement2.getAttribute("partid");
            if (string.length() > 0) {
                this.myPartID = Integer.parseInt(string);
            }
            String string2 = domElement2.getAttribute("rectobj");
            domDoc.registerReferencingObject(this, "rectobj", string2);
            String string3 = domElement2.getAttribute("label");
            domDoc.registerReferencingObject(this, "label", string3);
            super.SVGReadObject(domDoc, jGoDocument, domElement, domElement2.getNextSiblingJGoClassElement());
        }
        return domElement.getNextSibling();
    }

    public int getPartID() {
        return this.myPartID;
    }

    public void setPartID(int n) {
        int n2 = this.myPartID;
        if (n2 != n) {
            this.myPartID = n;
            this.update(65836, n2, null);
        }
    }

    public JGoText getLabel() {
        return this.myLabel;
    }

    public JGo3DNoteRect getRect() {
        return this.myRect;
    }

    public String getText() {
        return this.getLabel().getText();
    }

    public void setText(String string) {
        this.getLabel().setText(string);
    }

    public boolean isEditable() {
        return this.getLabel().isEditable();
    }

    public void setEditable(boolean bl) {
        this.getLabel().setEditable(bl);
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit jGoDocumentChangedEdit) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 65836: {
                jGoDocumentChangedEdit.setNewValueInt(this.getPartID());
                return;
            }
        }
        super.copyNewValueForRedo(jGoDocumentChangedEdit);
    }

    public void changeValue(JGoDocumentChangedEdit jGoDocumentChangedEdit, boolean bl) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 65836: {
                this.setPartID(jGoDocumentChangedEdit.getValueInt(bl));
                return;
            }
        }
        super.changeValue(jGoDocumentChangedEdit, bl);
    }
}

