/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.family;

import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDrawable;
import com.nwoods.jgo.JGoLabeledLink;
import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.examples.Comment;
import com.nwoods.jgo.examples.family.GenDB;
import com.nwoods.jgo.examples.family.Person;
import com.nwoods.jgo.examples.family.PersonNode;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class FamilyTreeDoc
extends JGoDocument {
    protected int myVertSeparation = 80;
    protected int myHorizSeparation = 4;
    protected JGoPen myMarriageLinkPen = JGoPen.make(65535, 2, new Color(0, 150, 0));
    protected JGoPen myDaughterLinkPen = JGoPen.make(65535, 1, new Color(200, 100, 100));
    protected JGoPen mySonLinkPen = JGoPen.make(65535, 1, new Color(100, 100, 200));
    protected GenDB myDB = new GenDB();
    protected HashMap myMap = new HashMap();

    public FamilyTreeDoc() {
        this.myDB.load();
    }

    public void initNodes() {
        Serializable serializable;
        this.setSuspendUpdates(true);
        Iterator iterator = this.myDB.getIterator();
        while (iterator.hasNext()) {
            serializable = (Person)iterator.next();
            PersonNode personNode = this.getNode((Person)serializable);
            Person person = this.myDB.findPerson(((Person)serializable).mother);
            PersonNode personNode2 = this.getNode(person);
            Person person2 = this.myDB.findPerson(((Person)serializable).father);
            PersonNode personNode3 = this.getNode(person2);
            this.getChildLink(personNode3, personNode2, personNode);
            Vector vector = ((Person)serializable).spouseslist;
            for (int i = 0; i < vector.size(); ++i) {
                Integer n = (Integer)vector.get(i);
                Person person3 = this.myDB.findPerson(n);
                PersonNode personNode4 = this.getNode(person3);
                this.getMarriageLink(personNode, personNode4);
            }
        }
        this.setSuspendUpdates(false);
        this.layoutNodes();
        this.setSuspendUpdates(true);
        serializable = new Comment("Some of the Tudors of English royalty in the 1500's.\n\nWomen are pink; men are blue; marriage links are green.\n\nTooltips provide more information about each person.\nDELETE to remove selected people from the tree;\nCTRL-L to reposition all the people;\nINSERT to start over with the original tree;\nCTRL-P to print; CTRL-Q to quit.");
        ((JGoObject)serializable).setTopLeft(350, 400);
        this.addObjectAtHead((JGoObject)serializable);
        this.setSuspendUpdates(false);
    }

    public PersonNode findNode(Person person) {
        if (person == null) {
            return null;
        }
        Object v = this.myMap.get(person);
        if (v instanceof PersonNode) {
            return (PersonNode)v;
        }
        return null;
    }

    public PersonNode getNode(Person person) {
        if (person == null) {
            return null;
        }
        PersonNode personNode = this.findNode(person);
        if (personNode == null) {
            personNode = new PersonNode("");
            personNode.setPerson(person);
            this.addObjectAtTail(personNode);
            this.myMap.put(person, personNode);
        }
        return personNode;
    }

    public void removeObject(JGoObject jGoObject) {
        PersonNode personNode;
        Person person;
        if (jGoObject instanceof PersonNode && (person = (personNode = (PersonNode)jGoObject).getPerson()) != null) {
            this.myMap.remove(person);
        }
        super.removeObject(jGoObject);
    }

    public void deleteContents() {
        this.myMap.clear();
        super.deleteContents();
    }

    public JGoLabeledLink findMarriageLink(PersonNode personNode, PersonNode personNode2) {
        if (personNode == null) {
            return null;
        }
        if (personNode2 == null) {
            return null;
        }
        JGoPort jGoPort = personNode.getRightPort();
        JGoPort jGoPort2 = personNode2.getRightPort();
        JGoListPosition jGoListPosition = jGoPort.getFirstLinkPos();
        while (jGoListPosition != null) {
            JGoLink jGoLink = jGoPort.getLinkAtPos(jGoListPosition);
            jGoListPosition = jGoPort.getNextLinkPos(jGoListPosition);
            JGoPort jGoPort3 = jGoLink.getOtherPort(jGoPort);
            if (jGoPort3 != jGoPort2) continue;
            return (JGoLabeledLink)jGoLink;
        }
        return null;
    }

    public JGoLabeledLink getMarriageLink(PersonNode personNode, PersonNode personNode2) {
        if (personNode == null) {
            return null;
        }
        if (personNode2 == null) {
            return null;
        }
        JGoLabeledLink jGoLabeledLink = this.findMarriageLink(personNode, personNode2);
        if (jGoLabeledLink == null) {
            JGoPort jGoPort = personNode.getRightPort();
            JGoPort jGoPort2 = personNode2.getRightPort();
            jGoLabeledLink = new JGoLabeledLink(jGoPort, jGoPort2);
            jGoLabeledLink.setSelectable(false);
            jGoLabeledLink.setPen(this.myMarriageLinkPen);
            JGoPort jGoPort3 = new JGoPort();
            jGoPort3.setStyle(0);
            jGoPort3.setFromSpot(6);
            jGoPort3.setToSpot(6);
            jGoLabeledLink.setMidLabel(jGoPort3);
            this.addObjectAtHead(jGoLabeledLink);
        }
        return jGoLabeledLink;
    }

    public JGoPort getMarriageLinkPortForChild(JGoLabeledLink jGoLabeledLink) {
        JGoPort jGoPort = (JGoPort)jGoLabeledLink.getMidLabel();
        if (jGoPort == null) {
            jGoPort = (JGoPort)jGoLabeledLink.getToLabel();
        }
        if (jGoPort == null) {
            jGoPort = (JGoPort)jGoLabeledLink.getFromLabel();
        }
        return jGoPort;
    }

    public JGoLink findChildLink(PersonNode personNode, PersonNode personNode2, PersonNode personNode3) {
        JGoLink jGoLink;
        JGoPort jGoPort;
        if (personNode == null) {
            return null;
        }
        if (personNode2 == null) {
            return null;
        }
        if (personNode3 == null) {
            return null;
        }
        JGoLabeledLink jGoLabeledLink = this.findMarriageLink(personNode, personNode2);
        if (jGoLabeledLink == null) {
            return null;
        }
        JGoPort jGoPort2 = this.getMarriageLinkPortForChild(jGoLabeledLink);
        JGoPort jGoPort3 = personNode3.getTopPort();
        JGoListPosition jGoListPosition = jGoPort3.getFirstLinkPos();
        if (jGoListPosition != null && (jGoPort = (jGoLink = jGoPort3.getLinkAtPos(jGoListPosition)).getOtherPort(jGoPort3)) == jGoPort2) {
            return jGoLink;
        }
        return null;
    }

    public JGoLink getChildLink(PersonNode personNode, PersonNode personNode2, PersonNode personNode3) {
        if (personNode == null) {
            return null;
        }
        if (personNode2 == null) {
            return null;
        }
        if (personNode3 == null) {
            return null;
        }
        JGoLink jGoLink = this.findChildLink(personNode, personNode2, personNode3);
        if (jGoLink == null) {
            JGoLabeledLink jGoLabeledLink = this.getMarriageLink(personNode, personNode2);
            JGoPort jGoPort = this.getMarriageLinkPortForChild(jGoLabeledLink);
            JGoPort jGoPort2 = personNode3.getTopPort();
            jGoLink = new JGoLink(jGoPort, jGoPort2);
            jGoLink.setSelectable(false);
            if (personNode3.getPerson().isMale()) {
                jGoLink.setPen(this.mySonLinkPen);
            } else if (personNode3.getPerson().isFemale()) {
                jGoLink.setPen(this.myDaughterLinkPen);
            } else {
                jGoLink.setPen(JGoPen.black);
            }
            this.addObjectAtHead(jGoLink);
        }
        return jGoLink;
    }

    public void layoutNodes() {
        Person person;
        PersonNode personNode;
        JGoObject jGoObject;
        Rectangle rectangle = new Rectangle(10, 10, 0, 0);
        this.setSuspendUpdates(true);
        PersonNode personNode2 = null;
        int n = 99999999;
        JGoListPosition jGoListPosition = this.getFirstObjectPos();
        while (jGoListPosition != null) {
            jGoObject = this.getObjectAtPos(jGoListPosition);
            jGoListPosition = this.getNextObjectPosAtTop(jGoListPosition);
            if (!(jGoObject instanceof PersonNode)) continue;
            personNode = (PersonNode)jGoObject;
            personNode.setTopLeft(0, 0);
            person = personNode.getPerson();
            if (person.number >= n || !personNode.getTopPort().hasNoLinks()) continue;
            personNode2 = personNode;
            n = person.number;
        }
        this.layoutTree(personNode2, rectangle);
        rectangle.x += rectangle.width;
        rectangle.width = 0;
        jGoListPosition = this.getFirstObjectPos();
        while (jGoListPosition != null) {
            jGoObject = this.getObjectAtPos(jGoListPosition);
            jGoListPosition = this.getNextObjectPosAtTop(jGoListPosition);
            if (!(jGoObject instanceof PersonNode)) continue;
            personNode = (PersonNode)jGoObject;
            person = personNode.getPerson();
            if (this.isPositioned(personNode) || !personNode.getTopPort().hasNoLinks()) continue;
            this.layoutTree(personNode, rectangle);
            rectangle.x += rectangle.width;
            rectangle.width = 0;
        }
        this.setSuspendUpdates(false);
    }

    private void layoutTree(PersonNode personNode, Rectangle rectangle) {
        JGoObject jGoObject;
        Serializable serializable;
        JGoDrawable jGoDrawable;
        if (this.isPositioned(personNode)) {
            return;
        }
        int n = 0;
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        rectangle2.x = rectangle.x + rectangle.width;
        rectangle2.y = rectangle.y + personNode.getHeight() + this.myVertSeparation;
        rectangle2.width = 0;
        JGoPort jGoPort = personNode.getRightPort();
        JGoListPosition jGoListPosition = jGoPort.getFirstLinkPos();
        while (jGoListPosition != null) {
            JGoLabeledLink jGoLabeledLink = (JGoLabeledLink)jGoPort.getLinkAtPos(jGoListPosition);
            jGoListPosition = jGoPort.getNextLinkPos(jGoListPosition);
            JGoPort jGoPort2 = jGoLabeledLink.getOtherPort(jGoPort);
            PersonNode personNode2 = (PersonNode)jGoPort2.getParent();
            jGoDrawable = this.getMarriageLinkPortForChild(jGoLabeledLink);
            if (jGoLabeledLink.getFromPort() == jGoPort2) {
                jGoLabeledLink.setFromLabel(jGoDrawable);
            } else if (jGoLabeledLink.getToPort() == jGoPort2) {
                jGoLabeledLink.setToLabel(jGoDrawable);
            }
            serializable = ((JGoPort)jGoDrawable).getFirstLinkPos();
            while (serializable != null) {
                jGoObject = ((JGoPort)jGoDrawable).getLinkAtPos((JGoListPosition)serializable);
                serializable = ((JGoPort)jGoDrawable).getNextLinkPos((JGoListPosition)serializable);
                JGoPort jGoPort3 = ((JGoLink)jGoObject).getOtherPort((JGoPort)jGoDrawable);
                PersonNode personNode3 = (PersonNode)jGoPort3.getParent();
                this.layoutTree(personNode3, rectangle2);
            }
            if (this.isPositioned(personNode2)) continue;
            personNode2.setTopLeft(rectangle.x + rectangle.width + n, rectangle.y + personNode.getHeight());
            n += personNode2.getWidth();
        }
        int n2 = Math.max(personNode.getWidth(), n);
        int n3 = Math.max(n2, rectangle2.width);
        personNode.setSpotLocation(2, rectangle.x + rectangle.width + n3 / 2, rectangle.y);
        if (n < n3) {
            int n4 = (n3 - n) / 2;
            jGoListPosition = jGoPort.getFirstLinkPos();
            while (jGoListPosition != null) {
                jGoDrawable = (JGoLabeledLink)jGoPort.getLinkAtPos(jGoListPosition);
                jGoListPosition = jGoPort.getNextLinkPos(jGoListPosition);
                serializable = ((JGoLink)jGoDrawable).getOtherPort(jGoPort);
                jGoObject = (PersonNode)((JGoObject)serializable).getParent();
                if (jGoObject.getLeft() < rectangle.x + rectangle.width || jGoObject.getLeft() > rectangle.x + rectangle.width + n3) continue;
                jGoObject.setLeft(jGoObject.getLeft() + n4);
            }
        }
        rectangle.width += n3;
    }

    public GenDB getDB() {
        return this.myDB;
    }

    private boolean isPositioned(PersonNode personNode) {
        return personNode.getLeft() >= 10 || personNode.getTop() >= 10;
    }
}

