/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.family;

import com.nwoods.jgo.examples.family.Person;
import java.io.Serializable;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.TreeMap;

public class GenDB
implements Serializable {
    protected TreeMap myIdMap = new TreeMap();

    public void load() {
        this.makePerson((int)1, (String)"Henry VII", (int)2, (int)-1, (int)-1, (int)1457, (int)1509).alias = "King of England 1485-1509";
        this.makePerson(2, "Elizabeth", 1, -1, -1, 1465, 1503);
        this.makeMarriage(1, 2);
        this.makePerson(3, "Arthur", 2, 1, 2, 1486, 1502);
        this.makePerson(4, "Catherine of Aragon", 1, -1, -1, 1485, 1536);
        this.makeMarriage(3, 4);
        this.makePerson(5, "Margaret", 1, 1, 2, 1489, 1541);
        this.makePerson((int)6, (String)"James IV", (int)2, (int)-1, (int)-1, (int)1473, (int)1513).alias = "of Scotland";
        this.makeMarriage(5, 6);
        this.makePerson((int)7, (String)"Archibald Douglas", (int)2, (int)-1, (int)-1, (int)1489, (int)1557).alias = "Earl of Angus";
        this.makeMarriage(5, 7);
        this.makePerson((int)8, (String)"Henry VIII", (int)2, (int)1, (int)2, (int)1491, (int)1547).alias = "King of England 1509-1547";
        this.makeMarriage(8, 4);
        this.makePerson(9, "Anne Boleyn", 1, -1, -1, 1507, 1536);
        this.makeMarriage(8, 9);
        this.makePerson(10, "Jane Seymour", 1, -1, -1, 1509, 1537);
        this.makeMarriage(8, 10);
        this.makePerson(11, "Anne of Cleves", 1, -1, -1, 1515, 1557);
        this.makeMarriage(8, 11);
        this.makePerson(12, "Catherine Howard", 1, -1, -1, -1, 1542);
        this.makeMarriage(8, 12);
        this.makePerson(13, "Catherine Parr", 1, -1, -1, 1512, 1548);
        this.makeMarriage(8, 13);
        this.makePerson(14, "Elizabeth", 1, 1, 2, 1492, 1495);
        this.makePerson(15, "Mary", 1, 1, 2, 1496, 1533);
        this.makePerson((int)16, (String)"Louis XII", (int)2, (int)-1, (int)-1, (int)1462, (int)1515).alias = "of France";
        this.makeMarriage(15, 16);
        this.makePerson((int)17, (String)"Charles Brandon", (int)2, (int)-1, (int)-1, (int)-1, (int)1545).alias = "Duke of Suffolk";
        this.makeMarriage(15, 17);
        this.makePerson(18, "Edmund", 2, 1, 2, 1499, 1499);
        this.makePerson(19, "Catherine", 1, 1, 2, 1503, 1503);
        this.makePerson((int)20, (String)"James V", (int)2, (int)5, (int)6, (int)1512, (int)1542).alias = "of Scotland";
        this.makePerson(21, "Mary of Guise", 1, -1, -1, 1515, 1560);
        this.makeMarriage(20, 21);
        this.makePerson(22, "5 died young", 0, 5, 6, -1, -1);
        this.makePerson(23, "Margaret", 1, 5, 7, 1515, 1578);
        this.makePerson((int)24, (String)"Matthew Stewart", (int)2, (int)-1, (int)-1, (int)1516, (int)1571).alias = "Earl of Lennox";
        this.makeMarriage(23, 24);
        this.makePerson((int)25, (String)"Mary I", (int)1, (int)8, (int)4, (int)1516, (int)1558).alias = "Queen of England 1553-1558";
        this.makePerson((int)26, (String)"Philip II", (int)2, (int)-1, (int)-1, (int)1527, (int)1598).alias = "of Spain";
        this.makeMarriage(25, 26);
        this.makePerson(27, "3 died young", 0, 8, 4, -1, -1);
        this.makePerson((int)28, (String)"Elizabeth I", (int)1, (int)8, (int)9, (int)1533, (int)1603).alias = "Queen of England 1558-1603";
        this.makePerson((int)29, (String)"Edward VI", (int)2, (int)8, (int)10, (int)1537, (int)1553).alias = "King of England 1547-1553";
        this.makePerson((int)30, (String)"Henry", (int)2, (int)15, (int)17, (int)1516, (int)1534).alias = "Earl of Lincoln";
        this.makePerson(31, "Frances", 1, 15, 17, 1517, 1559);
        this.makePerson((int)32, (String)"Henry Grey", (int)2, (int)-1, (int)-1, (int)1517, (int)1554).alias = "Duke of Suffolk";
        this.makeMarriage(31, 32);
        this.makePerson(33, "Eleanor", 1, 15, 17, 1519, 1547);
        this.makePerson((int)34, (String)"Henry Clifford", (int)2, (int)-1, (int)-1, (int)1517, (int)1570).alias = "Earl of Cumberland";
        this.makeMarriage(33, 34);
        this.makePerson(35, "2 died young", 0, 20, 21, -1, -1);
        this.makePerson((int)36, (String)"Mary", (int)1, (int)20, (int)21, (int)1542, (int)1587).alias = "Queen of Scots 1542-1567";
        this.makePerson((int)37, (String)"Francis II", (int)2, (int)-1, (int)-1, (int)1544, (int)1560).alias = "of France";
        this.makeMarriage(36, 37);
        this.makePerson((int)38, (String)"Henry Stewart", (int)2, (int)23, (int)24, (int)1545, (int)1567).alias = "Lord Darnley";
        this.makeMarriage(36, 38);
        this.makePerson((int)39, (String)"James Hepburn", (int)2, (int)-1, (int)-1, (int)1536, (int)1578).alias = "Earl of Bothwell";
        this.makeMarriage(36, 39);
        this.makePerson((int)40, (String)"Charles", (int)2, (int)23, (int)24, (int)1556, (int)1576).alias = "Earl of Lennox";
        this.makePerson(41, "Elizabeth Cavendish", 1, -1, -1, -1, 1582);
        this.makeMarriage(40, 41);
        this.makePerson(42, "6 died young", 0, 23, 24, -1, -1);
        this.makePerson((int)50, (String)"James I", (int)2, (int)36, (int)38, (int)1566, (int)1625).alias = "King of England 1603-1625, King of Scotland 1567-1625";
        this.makePerson((int)51, (String)"Anne", (int)1, (int)-1, (int)-1, (int)1574, (int)1619).alias = "daughter of Frederick II of Denmark";
        this.makeMarriage(50, 51);
    }

    protected Person makePerson(int n, String string, int n2, int n3, int n4, int n5, int n6) {
        Person person = this.getPerson(n);
        if (person != null) {
            Person person2;
            Person person3;
            person.name = string;
            person.sex = n2;
            person.father = n3;
            person.mother = n4;
            if (n5 > 1000) {
                person.birthdate = new GregorianCalendar(n5, 0, 1);
            }
            if (n6 > 1000) {
                person.deathdate = new GregorianCalendar(n6, 0, 1);
            }
            if ((person3 = this.getPerson(n3)) != null) {
                person3.childrenlist.add(new Integer(n));
            }
            if ((person2 = this.getPerson(n4)) != null) {
                person2.childrenlist.add(new Integer(n));
            }
        }
        return person;
    }

    protected void makeMarriage(int n, int n2) {
        Person person;
        Person person2 = this.getPerson(n);
        if (person2 != null) {
            person2.spouseslist.add(new Integer(n2));
            person2.weddingdateslist.add(null);
            person2.weddingplaceslist.add(null);
        }
        if ((person = this.getPerson(n2)) != null) {
            person.spouseslist.add(new Integer(n));
            person.weddingdateslist.add(null);
            person.weddingplaceslist.add(null);
        }
    }

    protected Person getPerson(int n) {
        if (n == -1) {
            return null;
        }
        Person person = this.findPerson(n);
        if (person == null) {
            person = new Person();
            person.number = n;
            this.myIdMap.put(new Integer(n), person);
        }
        return person;
    }

    public Person findPerson(int n) {
        return (Person)this.myIdMap.get(new Integer(n));
    }

    public Iterator getIterator() {
        return this.myIdMap.values().iterator();
    }
}

