/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.family;

import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoTextNode;
import com.nwoods.jgo.examples.family.Person;
import java.awt.Color;

public class PersonNode
extends JGoTextNode {
    public static Color myFemaleTextColor = Color.black;
    public static JGoPen myFemaleRectPen = JGoPen.Null;
    public static JGoBrush myFemaleRectBrush = JGoBrush.makeStockBrush(new Color(250, 200, 200));
    public static Color myMaleTextColor = Color.black;
    public static JGoPen myMaleRectPen = JGoPen.Null;
    public static JGoBrush myMaleRectBrush = JGoBrush.makeStockBrush(new Color(200, 200, 250));
    private Person myPerson = null;

    public PersonNode() {
        this.initCommon();
    }

    public PersonNode(String string) {
        super(string);
        this.initCommon();
    }

    private void initCommon() {
        if (this.getRightPort() != null) {
            this.getRightPort().setFromSpot(-1);
            this.getRightPort().setToSpot(-1);
        }
    }

    public void layoutChildren(JGoObject jGoObject) {
        if (this.isInitializing()) {
            return;
        }
        if (jGoObject == null || jGoObject == this.getLabel()) {
            super.layoutChildren(jGoObject);
            if (this.getRightPort() != null) {
                this.getRightPort().setSpotLocation(0, this.getBackground(), 0);
            }
        }
    }

    public void resetColors() {
        if (this.getPerson() == null) {
            return;
        }
        if (this.getPerson().isMale()) {
            this.getLabel().setTextColor(myMaleTextColor);
            this.setPen(myMaleRectPen);
            this.setBrush(myMaleRectBrush);
        } else if (this.getPerson().isFemale()) {
            this.getLabel().setTextColor(myFemaleTextColor);
            this.setPen(myFemaleRectPen);
            this.setBrush(myFemaleRectBrush);
        } else {
            this.getLabel().setTextColor(Color.black);
            this.setPen(JGoPen.black);
            this.setBrush(JGoBrush.white);
        }
    }

    public String getToolTipText() {
        Person person = this.getPerson();
        if (person != null) {
            String string = "";
            string = person.birthdate == null ? string + "?" : string + person.birthdate.get(1);
            string = string + " - ";
            string = person.deathdate == null ? string + "?" : string + person.deathdate.get(1);
            if (person.alias != null) {
                string = string + ", ";
                string = string + person.alias;
            }
            return string;
        }
        return null;
    }

    public Person getPerson() {
        return this.myPerson;
    }

    public void setPerson(Person person) {
        this.myPerson = person;
        if (person.name == null) {
            this.setText("<unknown>");
        } else {
            this.setText(person.name);
        }
        this.resetColors();
    }
}

