/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.instrumentdemo;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.instruments.AbstractGraduatedScale;
import com.nwoods.jgo.instruments.AbstractIndicator;
import com.nwoods.jgo.instruments.GraduatedScaleLinear;
import com.nwoods.jgo.instruments.IndicatorBar;
import com.nwoods.jgo.instruments.Meter;
import java.awt.Point;
import java.awt.Rectangle;

public class BarMeter
extends Meter {
    protected AbstractGraduatedScale createScale() {
        GraduatedScaleLinear graduatedScaleLinear = new GraduatedScaleLinear();
        graduatedScaleLinear.setTickUnit(2.0);
        graduatedScaleLinear.setTickMajorFrequency(10);
        return graduatedScaleLinear;
    }

    protected AbstractIndicator createIndicator() {
        IndicatorBar indicatorBar = new IndicatorBar();
        indicatorBar.setActionEnabled(true);
        indicatorBar.setBrush(JGoBrush.yellow);
        return indicatorBar;
    }

    public void layoutChildren(JGoObject jGoObject) {
        if (this.isInitializing()) {
            return;
        }
        super.layoutChildren(jGoObject);
        GraduatedScaleLinear graduatedScaleLinear = null;
        if (this.getScale() instanceof GraduatedScaleLinear) {
            graduatedScaleLinear = (GraduatedScaleLinear)this.getScale();
        }
        if (graduatedScaleLinear != null) {
            Rectangle rectangle = new Rectangle(graduatedScaleLinear.getBoundingRect());
            if (this.getOrientation() == 0) {
                if (rectangle.width < 40) {
                    graduatedScaleLinear.setStartPoint(new Point(rectangle.x + rectangle.width / 10, rectangle.y + rectangle.height / 2));
                    graduatedScaleLinear.setEndPoint(new Point(rectangle.x + 9 * rectangle.width / 10, rectangle.y + rectangle.height / 2));
                } else {
                    graduatedScaleLinear.setStartPoint(new Point(rectangle.x + 10, rectangle.y + rectangle.height / 2));
                    graduatedScaleLinear.setEndPoint(new Point(rectangle.x + rectangle.width - 10, rectangle.y + rectangle.height / 2));
                }
            } else if (rectangle.height < 40) {
                graduatedScaleLinear.setStartPoint(new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 10));
                graduatedScaleLinear.setEndPoint(new Point(rectangle.x + rectangle.width / 2, rectangle.y + 9 * rectangle.height / 10));
            } else {
                graduatedScaleLinear.setStartPoint(new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height - 10));
                graduatedScaleLinear.setEndPoint(new Point(rectangle.x + rectangle.width / 2, rectangle.y + 10));
            }
        }
    }

    public void SVGWriteObject(DomDoc domDoc, DomElement domElement) {
        if (domDoc.JGoXMLOutputEnabled()) {
            DomElement domElement2 = domDoc.createJGoClassElement("com.nwoods.jgo.examples.instrumentdemo.BarMeter", domElement);
        }
        super.SVGWriteObject(domDoc, domElement);
    }

    public DomNode SVGReadObject(DomDoc domDoc, JGoDocument jGoDocument, DomElement domElement, DomElement domElement2) {
        if (domElement2 != null) {
            super.SVGReadObject(domDoc, jGoDocument, domElement, domElement2.getNextSiblingJGoClassElement());
        }
        return domElement.getNextSibling();
    }

    public float getThickness() {
        return ((IndicatorBar)this.getIndicator()).getThickness();
    }

    public void setThickness(float f) {
        ((IndicatorBar)this.getIndicator()).setThickness(f);
    }
}

