/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.instrumentdemo;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDrawable;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoText;
import com.nwoods.jgo.instruments.AbstractGraduatedScale;
import com.nwoods.jgo.instruments.AbstractIndicator;
import com.nwoods.jgo.instruments.GraduatedScaleElliptical;
import com.nwoods.jgo.instruments.IndicatorBarElliptical;
import com.nwoods.jgo.instruments.Meter;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Rectangle;
import java.text.NumberFormat;
import java.text.ParseException;

public class BarMeterElliptical
extends Meter {
    private NumberFormat myFormatter = NumberFormat.getNumberInstance();

    public void initialize() {
        super.initialize();
        this.setLabelSpot(0);
        this.setLabelRelativeSpot(0);
        this.setInsets(new Insets(30, 30, 30, 30));
    }

    protected JGoObject createBackground() {
        JGoObject jGoObject = super.createBackground();
        JGoDrawable jGoDrawable = null;
        if (jGoObject instanceof JGoDrawable) {
            jGoDrawable = (JGoDrawable)jGoObject;
        }
        if (jGoDrawable != null) {
            jGoDrawable.setPen(JGoPen.white);
            jGoDrawable.setBrush(JGoBrush.gray);
        }
        return jGoObject;
    }

    protected JGoText createLabel() {
        JGoText jGoText = super.createLabel();
        if (jGoText != null) {
            jGoText.setText("0");
            jGoText.setTextColor(Color.white);
            jGoText.setAlignment(0);
            jGoText.setFontSize(20);
            jGoText.setItalic(true);
        }
        return jGoText;
    }

    protected AbstractGraduatedScale createScale() {
        GraduatedScaleElliptical graduatedScaleElliptical = new GraduatedScaleElliptical();
        graduatedScaleElliptical.setStartAngle(110.0);
        graduatedScaleElliptical.setSweepAngle(320.0);
        graduatedScaleElliptical.setTickUnit(2.0);
        graduatedScaleElliptical.setTickMajorFrequency(5);
        graduatedScaleElliptical.setPen(JGoPen.white);
        graduatedScaleElliptical.setTickColor(Color.white);
        graduatedScaleElliptical.getLabelTemplate().setTextColor(Color.white);
        return graduatedScaleElliptical;
    }

    protected AbstractIndicator createIndicator() {
        IndicatorBarElliptical indicatorBarElliptical = new IndicatorBarElliptical();
        indicatorBarElliptical.setActionEnabled(true);
        indicatorBarElliptical.setThickness(6.0f);
        indicatorBarElliptical.setBrush(JGoBrush.yellow);
        indicatorBarElliptical.setUpdatePartner(true);
        return indicatorBarElliptical;
    }

    public void layoutChildren(JGoObject jGoObject) {
        if (this.isInitializing()) {
            return;
        }
        super.layoutChildren(jGoObject);
        if (this.getScale() != null) {
            IndicatorBarElliptical indicatorBarElliptical = null;
            if (this.getIndicator() instanceof IndicatorBarElliptical) {
                indicatorBarElliptical = (IndicatorBarElliptical)this.getIndicator();
            }
            if (indicatorBarElliptical != null) {
                Rectangle rectangle = new Rectangle(this.getScale().getBoundingRect());
                float f = indicatorBarElliptical.getThickness();
                rectangle.grow((int)f / 2, (int)f / 2);
                this.getIndicator().setBoundingRect(rectangle);
            }
        }
    }

    protected void partnerUpdate(JGoObject jGoObject, int n, int n2, Object object) {
        if (n == 13300 && jGoObject == this.getIndicator() && this.getLabel() != null) {
            this.myFormatter.setMaximumFractionDigits(2);
            String string = this.myFormatter.format(this.getValue());
            this.getLabel().setText(string);
        } else if (n == 501 && jGoObject == this.getLabel() && this.getLabel() != null) {
            String string = this.getLabel().getText();
            try {
                this.myFormatter.setMaximumFractionDigits(2);
                double d = this.myFormatter.parse(string).doubleValue();
                this.getIndicator().setValue(d);
            }
            catch (ParseException parseException) {
                this.getLabel().setText((String)object);
            }
        }
    }

    public void SVGWriteObject(DomDoc domDoc, DomElement domElement) {
        if (domDoc.JGoXMLOutputEnabled()) {
            DomElement domElement2 = domDoc.createJGoClassElement("com.nwoods.jgo.examples.instrumentdemo.BarMeterElliptical", domElement);
        }
        super.SVGWriteObject(domDoc, domElement);
    }

    public DomNode SVGReadObject(DomDoc domDoc, JGoDocument jGoDocument, DomElement domElement, DomElement domElement2) {
        if (domElement2 != null) {
            super.SVGReadObject(domDoc, jGoDocument, domElement, domElement2.getNextSiblingJGoClassElement());
        }
        return domElement.getNextSibling();
    }

    public float getThickness() {
        return ((IndicatorBarElliptical)this.getIndicator()).getThickness();
    }

    public void setThickness(float f) {
        ((IndicatorBarElliptical)this.getIndicator()).setThickness(f);
    }

    public boolean isFillClockwise() {
        return ((IndicatorBarElliptical)this.getIndicator()).isFillClockwise();
    }

    public void setFillClockwise(boolean bl) {
        ((IndicatorBarElliptical)this.getIndicator()).setFillClockwise(bl);
    }
}

