/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.instrumentdemo;

import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoRectangle;
import com.nwoods.jgo.JGoText;
import com.nwoods.jgo.examples.instrumentdemo.ClockHand;
import com.nwoods.jgo.examples.instrumentdemo.HourClockHand;
import com.nwoods.jgo.instruments.AbstractGraduatedScale;
import com.nwoods.jgo.instruments.GraduatedScaleElliptical;
import com.nwoods.jgo.instruments.MultipleIndicatorMeter;
import java.awt.Point;

public class Clock
extends MultipleIndicatorMeter {
    public static final int ChangedSecondHand = 14203;
    public static final int ChangedMinuteHand = 14204;
    public static final int ChangedHourHand = 14205;
    private ClockHand mySecondHand;
    private ClockHand myMinuteHand;
    private HourClockHand myHourHand;

    public void initialize() {
        super.initialize();
        this.setLabelRelativeSpot(2);
        this.myHourHand = this.createHourHand();
        this.myMinuteHand = this.createMinuteHand();
        this.mySecondHand = this.createSecondHand();
        this.addIndicator(this.myHourHand);
        this.addIndicator(this.myMinuteHand);
        this.addIndicator(this.mySecondHand);
        this.updateDigital();
    }

    public ClockHand getSecondHand() {
        return this.mySecondHand;
    }

    public void setSecondHand(ClockHand clockHand) {
        ClockHand clockHand2 = this.mySecondHand;
        if (clockHand2 != clockHand) {
            this.removeObject(this.mySecondHand);
            this.mySecondHand = clockHand;
            this.addObjectAtTail(this.mySecondHand);
            this.mySecondHand.setScale(this.getScale());
            this.update(14203, 0, clockHand2);
        }
    }

    public ClockHand getMinuteHand() {
        return this.myMinuteHand;
    }

    public void setMinuteHand(ClockHand clockHand) {
        ClockHand clockHand2 = this.myMinuteHand;
        if (clockHand2 != clockHand) {
            this.removeObject(this.myMinuteHand);
            this.myMinuteHand = clockHand;
            this.addObjectAtTail(this.myMinuteHand);
            this.myMinuteHand.setScale(this.getScale());
            this.update(14204, 0, clockHand2);
        }
    }

    public HourClockHand getHourHand() {
        return this.myHourHand;
    }

    public void setHourHand(HourClockHand hourClockHand) {
        HourClockHand hourClockHand2 = this.myHourHand;
        if (hourClockHand2 != hourClockHand) {
            this.removeObject(this.myHourHand);
            this.myHourHand = hourClockHand;
            this.addObjectAtTail(this.myHourHand);
            this.myHourHand.setScale(this.getScale());
            this.update(14205, 0, hourClockHand2);
        }
    }

    protected JGoObject createBackground() {
        JGoRectangle jGoRectangle = new JGoRectangle();
        jGoRectangle.setSelectable(false);
        jGoRectangle.setBrush(JGoBrush.lightGray);
        return jGoRectangle;
    }

    protected JGoText createLabel() {
        JGoText jGoText = new JGoText();
        jGoText.setSelectable(false);
        jGoText.setTransparent(true);
        return jGoText;
    }

    protected AbstractGraduatedScale createScale() {
        GraduatedScaleElliptical graduatedScaleElliptical = new GraduatedScaleElliptical();
        graduatedScaleElliptical.setMinimum(0.0);
        graduatedScaleElliptical.setMaximum(60.0);
        graduatedScaleElliptical.setTickLabels(false);
        graduatedScaleElliptical.setStartAngle(270.0);
        graduatedScaleElliptical.setSweepAngle(360.0);
        graduatedScaleElliptical.setVisible(false);
        return graduatedScaleElliptical;
    }

    public ClockHand createSecondHand() {
        ClockHand clockHand = new ClockHand();
        clockHand.setSelectable(false);
        clockHand.setScale(this.getScale());
        clockHand.setPen(JGoPen.red);
        clockHand.setStyle(0);
        clockHand.setConstantLength(true);
        clockHand.setActionEnabled(false);
        clockHand.setValue(0.0);
        return clockHand;
    }

    public ClockHand createMinuteHand() {
        ClockHand clockHand = new ClockHand();
        clockHand.setSelectable(false);
        clockHand.setScale(this.getScale());
        clockHand.setPen(JGoPen.black);
        clockHand.setBrush(JGoBrush.black);
        clockHand.setStyle(1);
        clockHand.setThickness(15.0f);
        clockHand.setConstantLength(true);
        clockHand.setActionEnabled(false);
        clockHand.setValue(0.0);
        return clockHand;
    }

    public HourClockHand createHourHand() {
        HourClockHand hourClockHand = new HourClockHand();
        hourClockHand.setSelectable(false);
        hourClockHand.setScale(this.getScale());
        hourClockHand.setPen(JGoPen.black);
        hourClockHand.setBrush(JGoBrush.black);
        hourClockHand.setStyle(1);
        hourClockHand.setThickness(15.0f);
        hourClockHand.setConstantLength(true);
        hourClockHand.setActionEnabled(false);
        hourClockHand.setValue(0.0);
        return hourClockHand;
    }

    protected void copyChildren(JGoArea jGoArea, JGoCopyEnvironment jGoCopyEnvironment) {
        super.copyChildren(jGoArea, jGoCopyEnvironment);
        Clock clock = (Clock)jGoArea;
        clock.mySecondHand = (ClockHand)jGoCopyEnvironment.get(this.mySecondHand);
        clock.myMinuteHand = (ClockHand)jGoCopyEnvironment.get(this.myMinuteHand);
        clock.myHourHand = (HourClockHand)jGoCopyEnvironment.get(this.myHourHand);
        if (clock.mySecondHand != null) {
            clock.mySecondHand.setScale(clock.getScale());
        }
        if (clock.myMinuteHand != null) {
            clock.myMinuteHand.setScale(clock.getScale());
        }
        if (clock.myHourHand != null) {
            clock.myHourHand.setScale(clock.getScale());
        }
    }

    public JGoObject removeObjectAtPos(JGoListPosition jGoListPosition) {
        JGoObject jGoObject = super.removeObjectAtPos(jGoListPosition);
        if (jGoObject == this.mySecondHand) {
            this.mySecondHand = null;
        } else if (jGoObject == this.myMinuteHand) {
            this.myMinuteHand = null;
        } else if (jGoObject == this.myHourHand) {
            this.myHourHand = null;
        }
        return jGoObject;
    }

    public void layoutChildren(JGoObject jGoObject) {
        if (this.isInitializing()) {
            return;
        }
        super.layoutChildren(jGoObject);
        this.layoutIndicators(jGoObject);
    }

    public void layoutIndicators(JGoObject jGoObject) {
        AbstractGraduatedScale abstractGraduatedScale = this.getScale();
        Point point = new Point(abstractGraduatedScale.getLeft() + abstractGraduatedScale.getWidth() / 2, abstractGraduatedScale.getTop() + abstractGraduatedScale.getHeight() / 2);
        if (this.mySecondHand != null) {
            this.getSecondHand().setBoundingRect(this.getScale().getBoundingRect());
            this.getSecondHand().setPivotPoint(point);
            this.getSecondHand().setThickness(Math.min(this.getScale().getWidth(), this.getScale().getHeight()) / 20);
            this.getSecondHand().setLength(Math.min(this.getScale().getWidth(), this.getScale().getHeight()) * 3 / 8);
        }
        if (this.myMinuteHand != null) {
            this.getMinuteHand().setBoundingRect(this.getScale().getBoundingRect());
            this.getMinuteHand().setPivotPoint(point);
            this.getMinuteHand().setThickness(Math.min(this.getScale().getWidth(), this.getScale().getHeight()) / 20);
            this.getMinuteHand().setLength(Math.min(this.getScale().getWidth(), this.getScale().getHeight()) * 3 / 8);
        }
        if (this.myHourHand != null) {
            this.getHourHand().setBoundingRect(this.getScale().getBoundingRect());
            this.getHourHand().setPivotPoint(point);
            this.getHourHand().setThickness(Math.min(this.getScale().getWidth(), this.getScale().getHeight()) / 20);
            this.getHourHand().setLength(Math.min(this.getScale().getWidth(), this.getScale().getHeight()) * 2 / 8);
        }
    }

    public double getSecond() {
        return Math.floor(this.getSecondHand().getValue());
    }

    public int getMinute() {
        return (int)Math.floor(this.getMinuteHand().getValue());
    }

    public int getHour() {
        return (int)Math.floor(this.getHourHand().getValue() / 5.0);
    }

    public void setTime(int n, int n2, double d) {
        this.getSecondHand().setValue(d);
        this.getMinuteHand().setValue((double)n2 + d / 60.0);
        this.getHourHand().setValue(5.0 * ((double)n + (double)n2 / 60.0 + d / 3600.0));
        this.updateDigital();
    }

    public void incrementTime() {
        this.getSecondHand().setValue(this.getSecondHand().getValue() + 1.0);
        this.getMinuteHand().setValue(this.getMinuteHand().getValue() + 0.016666666666666666);
        this.getHourHand().setValue(this.getHourHand().getValue() + 0.001388888888888889);
        this.updateDigital();
    }

    public void updateDigital() {
        if (this.getLabel() == null) {
            return;
        }
        String string = Integer.toString(this.getHour() % 12);
        if (string == "0") {
            string = "12";
        }
        string = string + ":";
        if (this.getMinute() < 10) {
            string = string + "0";
        }
        string = string + Integer.toString(this.getMinute()) + ":";
        if (this.getSecond() < 10.0) {
            string = string + "0";
        }
        string = string + Double.toString(this.getSecond());
        string = this.getHour() < 12 ? string + "am" : string + "pm";
        this.getLabel().setText(string);
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit jGoDocumentChangedEdit) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 14001: {
                jGoDocumentChangedEdit.setNewValue(this.getBackground());
                return;
            }
            case 14004: {
                jGoDocumentChangedEdit.setNewValue(this.getScale());
                return;
            }
            case 14203: {
                jGoDocumentChangedEdit.setNewValue(this.getSecondHand());
                return;
            }
            case 14204: {
                jGoDocumentChangedEdit.setNewValue(this.getMinuteHand());
                return;
            }
            case 14205: {
                jGoDocumentChangedEdit.setNewValue(this.getHourHand());
                return;
            }
        }
        super.copyNewValueForRedo(jGoDocumentChangedEdit);
    }

    public void changeValue(JGoDocumentChangedEdit jGoDocumentChangedEdit, boolean bl) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 14001: {
                this.setBackground((JGoObject)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
            case 14004: {
                this.setScale((GraduatedScaleElliptical)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
            case 14203: {
                this.setSecondHand((ClockHand)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
            case 14204: {
                this.setMinuteHand((ClockHand)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
            case 14205: {
                this.setHourHand((HourClockHand)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
        }
        super.changeValue(jGoDocumentChangedEdit, bl);
    }
}

