/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.instrumentdemo;

import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.instruments.AbstractGraduatedScale;
import com.nwoods.jgo.instruments.AbstractIndicator;
import com.nwoods.jgo.instruments.GraduatedScaleElliptical;
import com.nwoods.jgo.instruments.IndicatorBar;
import com.nwoods.jgo.instruments.IndicatorBarElliptical;
import com.nwoods.jgo.instruments.IndicatorNeedle;
import com.nwoods.jgo.instruments.Meter;
import com.nwoods.jgo.instruments.Phase;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;

public class GaugeMeter
extends Meter {
    public static final int ChangedGauge = 13800;
    private IndicatorBar myGauge;

    public void initialize() {
        super.initialize();
        int n = 30;
        if (this.getLabel() != null) {
            n += this.getLabel().getHeight();
        }
        this.setInsets(new Insets(30, 30, n, 30));
        this.myGauge = this.createGauge();
        JGoListPosition jGoListPosition = this.findObject(this.getScale());
        if (jGoListPosition != null) {
            this.insertObjectBefore(jGoListPosition, this.myGauge);
        } else {
            this.addObjectAtTail(this.myGauge);
        }
        this.layoutChildren(null);
    }

    protected AbstractGraduatedScale createScale() {
        GraduatedScaleElliptical graduatedScaleElliptical = new GraduatedScaleElliptical();
        graduatedScaleElliptical.setStartAngle(110.0);
        graduatedScaleElliptical.setSweepAngle(320.0);
        graduatedScaleElliptical.setTickUnit(2.0);
        graduatedScaleElliptical.setTickMajorFrequency(10);
        graduatedScaleElliptical.setTickLengthLeft(0.1f);
        graduatedScaleElliptical.setTickLengthRight(10.0f);
        graduatedScaleElliptical.setLabelDistance(10);
        return graduatedScaleElliptical;
    }

    protected AbstractIndicator createIndicator() {
        IndicatorNeedle indicatorNeedle = new IndicatorNeedle();
        indicatorNeedle.setActionEnabled(true);
        indicatorNeedle.setLength(this.getScale().getHeight() / 2);
        indicatorNeedle.setStyle(1);
        indicatorNeedle.setThickness(20.0f);
        indicatorNeedle.setBrush(JGoBrush.red);
        return indicatorNeedle;
    }

    protected IndicatorBar createGauge() {
        IndicatorBarElliptical indicatorBarElliptical = new IndicatorBarElliptical();
        indicatorBarElliptical.setThickness(20.0f);
        indicatorBarElliptical.addPhase(new Phase(0.0, 75.0, Color.green));
        indicatorBarElliptical.addPhase(new Phase(75.0, 90.0, Color.yellow));
        indicatorBarElliptical.setScale(this.getScale());
        indicatorBarElliptical.setValue(indicatorBarElliptical.getScale().getMaximum());
        return indicatorBarElliptical;
    }

    public IndicatorBar getGauge() {
        return this.myGauge;
    }

    public void setGauge(IndicatorBar indicatorBar) {
        IndicatorBar indicatorBar2 = this.myGauge;
        if (indicatorBar2 != indicatorBar) {
            if (indicatorBar2 != null) {
                this.removeObject(indicatorBar2);
            }
            this.myGauge = indicatorBar;
            if (indicatorBar != null) {
                JGoListPosition jGoListPosition = this.findObject(this.getScale());
                if (jGoListPosition != null) {
                    this.insertObjectBefore(jGoListPosition, indicatorBar);
                } else {
                    this.addObjectAtHead(indicatorBar);
                }
            }
            this.update(13800, 0, indicatorBar2);
        }
    }

    public void layoutChildren(JGoObject jGoObject) {
        if (this.isInitializing()) {
            return;
        }
        super.layoutChildren(jGoObject);
        if (this.getScale() != null) {
            Serializable serializable;
            if (this.getGauge() != null) {
                serializable = new Rectangle(this.getScale().getBoundingRect());
                this.getGauge().setBoundingRect((Rectangle)serializable);
            }
            serializable = null;
            if (this.getIndicator() instanceof IndicatorNeedle) {
                serializable = (IndicatorNeedle)this.getIndicator();
            }
            if (serializable != null) {
                AbstractGraduatedScale abstractGraduatedScale = this.getScale();
                ((IndicatorNeedle)serializable).setPivotPoint(new Point(abstractGraduatedScale.getLeft() + abstractGraduatedScale.getWidth() / 2, abstractGraduatedScale.getTop() + abstractGraduatedScale.getHeight() / 2));
                if (((IndicatorNeedle)this.getIndicator()).isConstantLength()) {
                    ((IndicatorNeedle)serializable).setLength(Math.min(this.getScale().getWidth() / 2, this.getScale().getHeight() / 2));
                }
            }
        }
    }

    protected void copyChildren(JGoArea jGoArea, JGoCopyEnvironment jGoCopyEnvironment) {
        super.copyChildren(jGoArea, jGoCopyEnvironment);
        GaugeMeter gaugeMeter = (GaugeMeter)jGoArea;
        gaugeMeter.myGauge = (IndicatorBar)jGoCopyEnvironment.get(this.myGauge);
        gaugeMeter.myGauge.setScale(gaugeMeter.getScale());
    }

    public JGoObject removeObjectAtPos(JGoListPosition jGoListPosition) {
        JGoObject jGoObject = super.removeObjectAtPos(jGoListPosition);
        if (jGoObject == this.myGauge) {
            this.myGauge = null;
        }
        return jGoObject;
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit jGoDocumentChangedEdit) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 13800: {
                jGoDocumentChangedEdit.setNewValue(this.getGauge());
                return;
            }
        }
        super.copyNewValueForRedo(jGoDocumentChangedEdit);
    }

    public void changeValue(JGoDocumentChangedEdit jGoDocumentChangedEdit, boolean bl) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 13800: {
                this.setGauge((IndicatorBar)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
        }
        super.changeValue(jGoDocumentChangedEdit, bl);
    }
}

