/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.instrumentdemo;

import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoLayer;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoSelection;
import com.nwoods.jgo.JGoView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class Inspector {
    private static InspectorTableModel myModel = null;
    private static JDialog myDialog = null;
    private static JTable myTable = null;
    static /* synthetic */ Class class$java$awt$Color;
    static /* synthetic */ Class class$java$awt$Insets;
    static /* synthetic */ Class class$com$nwoods$jgo$JGoPen;
    static /* synthetic */ Class class$com$nwoods$jgo$JGoBrush;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$awt$Point;
    static /* synthetic */ Class class$java$awt$Dimension;
    static /* synthetic */ Class class$java$awt$Rectangle;
    static /* synthetic */ Class class$java$lang$Class;

    public static void inspect(Object object) {
        try {
            if (myDialog == null) {
                myModel = new InspectorTableModel();
                myTable = new JTable(myModel);
                myTable.setPreferredScrollableViewportSize(new Dimension(300, 500));
                myTable.addMouseListener(new MouseAdapter(){

                    public void mouseClicked(MouseEvent mouseEvent) {
                        myModel.mouseClicked(mouseEvent.getClickCount(), myTable.rowAtPoint(mouseEvent.getPoint()), myTable.columnAtPoint(mouseEvent.getPoint()));
                    }
                });
                JScrollPane jScrollPane = new JScrollPane(myTable);
                JDialog jDialog = new JDialog((Frame)null, "Properties", false);
                jDialog.getContentPane().setLayout(new BorderLayout());
                jDialog.getContentPane().add((Component)jScrollPane, "Center");
                jDialog.pack();
                jDialog.setVisible(true);
                myDialog = jDialog;
            }
            myModel.setObject(object);
            myTable.getColumnModel().getColumn(0).setPreferredWidth(35);
            myDialog.setVisible(true);
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace();
        }
    }

    public static void refresh() {
        if (myModel != null && myDialog != null && myDialog.isVisible()) {
            myModel.setObject(myModel.getObject());
        }
    }

    public static JDialog getInspector() {
        return myDialog;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class InspectorTableModel
    extends AbstractTableModel {
        private Object myObject = null;
        private ArrayList myGetters = new ArrayList();
        private ArrayList mySetters = new ArrayList();

        public Object getObject() {
            return this.myObject;
        }

        public void setObject(Object object) {
            this.myObject = object;
            this.myGetters = new ArrayList();
            this.mySetters = new ArrayList();
            if (this.myObject != null) {
                this.addMethods(this.myObject.getClass());
            }
            this.fireTableChanged(new TableModelEvent(this));
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return "Property";
            }
            return "Value";
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return this.myGetters.size();
        }

        public Object getValueAt(int n, int n2) {
            Method method = (Method)this.myGetters.get(n);
            if (n2 == 0) {
                return this.getPropertyName(method);
            }
            try {
                Object object = method.invoke(this.myObject, new Object[0]);
                if (object instanceof Point) {
                    Point point = (Point)object;
                    return Integer.toString(point.x) + "," + Integer.toString(point.y);
                }
                if (object instanceof Dimension) {
                    Dimension dimension = (Dimension)object;
                    return Integer.toString(dimension.width) + "x" + Integer.toString(dimension.height);
                }
                if (object instanceof Rectangle) {
                    Rectangle rectangle = (Rectangle)object;
                    return Integer.toString(rectangle.x) + "," + Integer.toString(rectangle.y) + ";" + Integer.toString(rectangle.width) + "x" + Integer.toString(rectangle.height);
                }
                return object;
            }
            catch (Exception exception) {
                return exception.toString();
            }
        }

        public boolean isCellEditable(int n, int n2) {
            Class<?> clazz;
            return n2 == 1 && this.mySetters.get(n) != null && (clazz = this.myObject.getClass()) != (class$java$awt$Color == null ? (class$java$awt$Color = Inspector.class$("java.awt.Color")) : class$java$awt$Color) && clazz != (class$java$awt$Insets == null ? (class$java$awt$Insets = Inspector.class$("java.awt.Insets")) : class$java$awt$Insets) && clazz != (class$com$nwoods$jgo$JGoPen == null ? (class$com$nwoods$jgo$JGoPen = Inspector.class$("com.nwoods.jgo.JGoPen")) : class$com$nwoods$jgo$JGoPen) && clazz != (class$com$nwoods$jgo$JGoBrush == null ? (class$com$nwoods$jgo$JGoBrush = Inspector.class$("com.nwoods.jgo.JGoBrush")) : class$com$nwoods$jgo$JGoBrush);
        }

        public void setValueAt(Object object, int n, int n2) {
            Method method = (Method)this.mySetters.get(n);
            if (method == null) {
                return;
            }
            Class<?>[] classArray = method.getParameterTypes();
            if (classArray.length == 0) {
                return;
            }
            Class<?> clazz = classArray[0];
            if (object instanceof String) {
                String string = (String)object;
                if (clazz == (class$java$lang$String == null ? (class$java$lang$String = Inspector.class$("java.lang.String")) : class$java$lang$String)) {
                    this.invokeSetter(method, string);
                } else if (clazz == Boolean.TYPE) {
                    Boolean bl = Boolean.FALSE;
                    if (string.equals("true")) {
                        bl = Boolean.TRUE;
                    }
                    this.invokeSetter(method, bl);
                } else if (clazz == Integer.TYPE) {
                    try {
                        Integer n3 = Integer.valueOf(string);
                        this.invokeSetter(method, n3);
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(null, exception.toString());
                    }
                } else if (clazz == Float.TYPE) {
                    try {
                        Float f = Float.valueOf(string);
                        this.invokeSetter(method, f);
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(null, exception.toString());
                    }
                } else if (clazz == Double.TYPE) {
                    try {
                        Double d = Double.valueOf(string);
                        this.invokeSetter(method, d);
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(null, exception.toString());
                    }
                } else if (clazz == (class$java$awt$Point == null ? (class$java$awt$Point = Inspector.class$("java.awt.Point")) : class$java$awt$Point)) {
                    try {
                        int n4 = string.indexOf(44);
                        int n5 = Integer.parseInt(string.substring(0, n4).trim());
                        int n6 = Integer.parseInt(string.substring(n4 + 1).trim());
                        Point point = new Point(n5, n6);
                        this.invokeSetter(method, point);
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(null, exception.toString());
                    }
                } else if (clazz == (class$java$awt$Dimension == null ? (class$java$awt$Dimension = Inspector.class$("java.awt.Dimension")) : class$java$awt$Dimension)) {
                    try {
                        int n7 = string.indexOf(120);
                        int n8 = Integer.parseInt(string.substring(0, n7).trim());
                        int n9 = Integer.parseInt(string.substring(n7 + 1).trim());
                        Dimension dimension = new Dimension(n8, n9);
                        this.invokeSetter(method, dimension);
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(null, exception.toString());
                    }
                } else if (clazz == (class$java$awt$Rectangle == null ? (class$java$awt$Rectangle = Inspector.class$("java.awt.Rectangle")) : class$java$awt$Rectangle)) {
                    try {
                        int n10 = string.indexOf(44);
                        int n11 = Integer.parseInt(string.substring(0, n10).trim());
                        int n12 = string.indexOf(59);
                        int n13 = Integer.parseInt(string.substring(n10 + 1, n12).trim());
                        int n14 = string.indexOf(120);
                        int n15 = Integer.parseInt(string.substring(n12 + 1, n14).trim());
                        int n16 = Integer.parseInt(string.substring(n14 + 1).trim());
                        Point point = new Point(n11, n13);
                        this.invokeSetter(method, point);
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(null, exception.toString());
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "not handled: type=" + clazz.toString() + " value=" + string);
                }
            } else {
                JOptionPane.showMessageDialog(null, "not handled: type=" + clazz.toString() + ", valuetype=" + object.getClass().toString() + " value=" + object.toString());
            }
            this.fireTableChanged(new TableModelEvent(this));
        }

        private void invokeSetter(Method method, Object object) {
            JGoDocument jGoDocument = null;
            if (this.myObject instanceof JGoDocument) {
                jGoDocument = (JGoDocument)this.myObject;
            } else if (this.myObject instanceof JGoObject) {
                jGoDocument = ((JGoObject)this.myObject).getDocument();
            } else if (this.myObject instanceof JGoLayer) {
                jGoDocument = ((JGoLayer)this.myObject).getDocument();
            } else if (this.myObject instanceof JGoView) {
                jGoDocument = ((JGoView)this.myObject).getDocument();
            } else if (this.myObject instanceof JGoSelection) {
                jGoDocument = ((JGoSelection)this.myObject).getView().getDocument();
            }
            if (jGoDocument != null) {
                jGoDocument.startTransaction();
            }
            try {
                method.invoke(this.myObject, object);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, exception.toString());
            }
            if (jGoDocument != null) {
                jGoDocument.endTransaction("modified property: " + method.toString());
            }
        }

        public void mouseClicked(int n, int n2, int n3) {
            Object object;
            Method method;
            Class<?> clazz;
            if (n >= 2 && (clazz = (method = (Method)this.myGetters.get(n2)).getReturnType()) != (class$java$lang$String == null ? (class$java$lang$String = Inspector.class$("java.lang.String")) : class$java$lang$String) && clazz != Boolean.TYPE && clazz != Integer.TYPE && clazz != Float.TYPE && clazz != Double.TYPE && clazz != (class$java$lang$Class == null ? (class$java$lang$Class = Inspector.class$("java.lang.Class")) : class$java$lang$Class) && clazz != (class$java$awt$Point == null ? (class$java$awt$Point = Inspector.class$("java.awt.Point")) : class$java$awt$Point) && clazz != (class$java$awt$Dimension == null ? (class$java$awt$Dimension = Inspector.class$("java.awt.Dimension")) : class$java$awt$Dimension) && clazz != (class$java$awt$Rectangle == null ? (class$java$awt$Rectangle = Inspector.class$("java.awt.Rectangle")) : class$java$awt$Rectangle) && clazz != (class$java$awt$Color == null ? (class$java$awt$Color = Inspector.class$("java.awt.Color")) : class$java$awt$Color) && clazz != (class$java$awt$Insets == null ? (class$java$awt$Insets = Inspector.class$("java.awt.Insets")) : class$java$awt$Insets) && (object = this.getValueAt(n2, 1)) != null) {
                this.setObject(object);
            }
        }

        public boolean isEditableObject(Object object) {
            return object instanceof String || object instanceof Boolean || object instanceof Integer || object instanceof Float || object instanceof Double || object instanceof Point || object instanceof Dimension || object instanceof Rectangle || object instanceof Color || object instanceof Insets;
        }

        private void addMethods(Class clazz) {
            if (clazz.getSuperclass() != null) {
                this.addMethods(clazz.getSuperclass());
            }
            Method[] methodArray = clazz.getDeclaredMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                Method method = methodArray[i];
                if (!this.isDisplayable(method)) continue;
                this.myGetters.add(method);
                String string = "set" + this.getPropertyName(method);
                try {
                    Method method2 = this.myObject.getClass().getMethod(string, method.getReturnType());
                    this.mySetters.add(method2);
                    continue;
                }
                catch (Exception exception) {
                    this.mySetters.add(null);
                }
            }
        }

        private String getPropertyName(Method method) {
            String string = method.getName();
            if (string.length() > 3 && string.substring(0, 3).equals("get")) {
                return string.substring(3);
            }
            if (string.length() > 2 && string.substring(0, 2).equals("is")) {
                return string.substring(2);
            }
            return null;
        }

        private boolean isDisplayable(Method method) {
            return method.getParameterTypes().length == 0 && this.getPropertyName(method) != null && Modifier.isPublic(method.getModifiers());
        }
    }
}

