/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.instrumentdemo;

import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoImage;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoUndoManager;
import com.nwoods.jgo.JGoView;
import com.nwoods.jgo.JGoViewEvent;
import com.nwoods.jgo.JGoViewListener;
import com.nwoods.jgo.examples.instrumentdemo.BarMeter;
import com.nwoods.jgo.examples.instrumentdemo.BarMeterElliptical;
import com.nwoods.jgo.examples.instrumentdemo.Clock;
import com.nwoods.jgo.examples.instrumentdemo.GaugeMeter;
import com.nwoods.jgo.examples.instrumentdemo.GradientBarMeter;
import com.nwoods.jgo.examples.instrumentdemo.Inspector;
import com.nwoods.jgo.examples.instrumentdemo.InstrumentsDemoFrame_AboutBox;
import com.nwoods.jgo.examples.instrumentdemo.InstrumentsDemoFrame_jMenuCopy_actionAdapter;
import com.nwoods.jgo.examples.instrumentdemo.InstrumentsDemoFrame_jMenuCut_actionAdapter;
import com.nwoods.jgo.examples.instrumentdemo.InstrumentsDemoFrame_jMenuFileExit_ActionAdapter;
import com.nwoods.jgo.examples.instrumentdemo.InstrumentsDemoFrame_jMenuHelpAbout_ActionAdapter;
import com.nwoods.jgo.examples.instrumentdemo.InstrumentsDemoFrame_jMenuInspect_actionAdapter;
import com.nwoods.jgo.examples.instrumentdemo.InstrumentsDemoFrame_jMenuPaste_actionAdapter;
import com.nwoods.jgo.examples.instrumentdemo.InstrumentsDemoFrame_jMenuRedo_actionAdapter;
import com.nwoods.jgo.examples.instrumentdemo.InstrumentsDemoFrame_jMenuSVGIn_actionAdapter;
import com.nwoods.jgo.examples.instrumentdemo.InstrumentsDemoFrame_jMenuSVGOut_actionAdapter;
import com.nwoods.jgo.examples.instrumentdemo.InstrumentsDemoFrame_jMenuToggleAnimation_actionAdapter;
import com.nwoods.jgo.examples.instrumentdemo.InstrumentsDemoFrame_jMenuUndo_actionAdapter;
import com.nwoods.jgo.examples.instrumentdemo.InstrumentsDemoFrame_jMenuZoomIn_actionAdapter;
import com.nwoods.jgo.examples.instrumentdemo.InstrumentsDemoFrame_jMenuZoomNormalSize_actionAdapter;
import com.nwoods.jgo.examples.instrumentdemo.InstrumentsDemoFrame_jMenuZoomOut_actionAdapter;
import com.nwoods.jgo.examples.instrumentdemo.InstrumentsDemoFrame_jMenuZoomToFit_actionAdapter;
import com.nwoods.jgo.examples.instrumentdemo.KnobMeter;
import com.nwoods.jgo.examples.instrumentdemo.MultiBarMeter;
import com.nwoods.jgo.examples.instrumentdemo.MultiPhaseMeter;
import com.nwoods.jgo.examples.instrumentdemo.MultiPhaseMeterElliptical;
import com.nwoods.jgo.examples.instrumentdemo.NeedleMeter;
import com.nwoods.jgo.examples.instrumentdemo.NeedleMeterElliptical;
import com.nwoods.jgo.examples.instrumentdemo.OverrunMeter;
import com.nwoods.jgo.examples.instrumentdemo.Pipe;
import com.nwoods.jgo.examples.instrumentdemo.Ruler;
import com.nwoods.jgo.examples.instrumentdemo.SliderMeter;
import com.nwoods.jgo.examples.instrumentdemo.SliderMeterElliptical;
import com.nwoods.jgo.examples.instrumentdemo.Tank;
import com.nwoods.jgo.examples.instrumentdemo.Thermometer;
import com.nwoods.jgo.instruments.GraduatedScaleElliptical;
import com.nwoods.jgo.instruments.GraduatedScaleLinear;
import com.nwoods.jgo.instruments.Meter;
import com.nwoods.jgo.svg.DefaultDocument;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.Timer;

public class InstrumentsDemoFrame
extends JFrame
implements JGoViewListener {
    JPanel contentPane;
    JMenuBar jMenuBar1 = new JMenuBar();
    JMenu jMenuFile = new JMenu();
    JMenuItem jMenuFileExit = new JMenuItem();
    JMenu jMenuHelp = new JMenu();
    JMenuItem jMenuHelpAbout = new JMenuItem();
    ImageIcon image1;
    ImageIcon image2;
    ImageIcon image3;
    BorderLayout borderLayout1 = new BorderLayout();
    JTabbedPane jTabbedPane1 = new JTabbedPane();
    JMenu jMenuEdit = new JMenu();
    JMenuItem jMenuZoomOut = new JMenuItem();
    JMenuItem jMenuZoomIn = new JMenuItem();
    JGoView jGoScales = new JGoView();
    JGoView jGoMeters = new JGoView();
    JGoView jGoSpecial = new JGoView();
    JMenuItem jMenuZoomNormalSize = new JMenuItem();
    JMenuItem jMenuZoomToFit = new JMenuItem();
    JMenuItem jMenuPaste = new JMenuItem();
    JMenuItem jMenuCopy = new JMenuItem();
    JMenuItem jMenuCut = new JMenuItem();
    JMenuItem jMenuUndo = new JMenuItem();
    JMenuItem jMenuRedo = new JMenuItem();
    JMenuItem jMenuInspect = new JMenuItem();
    private ArrayList myMeters = new ArrayList();
    private Action myTimer1Action = null;
    private Timer myTimer1 = null;
    private Clock myClock = null;
    private Action myTimer2Action = null;
    private Timer myTimer2 = null;
    JMenuItem jMenuSVGOut = new JMenuItem();
    JMenuItem jMenuSVGIn = new JMenuItem();
    JMenuItem jMenuToggleAnimation = new JMenuItem();
    static /* synthetic */ Class class$com$nwoods$jgo$examples$instrumentdemo$InstrumentDemo;

    public InstrumentsDemoFrame() {
        this.enableEvents(64L);
        try {
            this.jbInit();
            this.jGoScales.addViewListener(this);
            this.jGoMeters.addViewListener(this);
            this.jGoSpecial.addViewListener(this);
            this.jGoScales.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    InstrumentsDemoFrame.this.handleKeyPressed(keyEvent);
                }
            });
            this.jGoMeters.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    InstrumentsDemoFrame.this.handleKeyPressed(keyEvent);
                }
            });
            this.jGoSpecial.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    InstrumentsDemoFrame.this.handleKeyPressed(keyEvent);
                }
            });
            this.populateSpecial(this.jGoSpecial);
            this.jTabbedPane1.addTab("Special", this.jGoSpecial);
            this.populateSampleMeters(this.jGoMeters);
            this.jTabbedPane1.addTab("Sample Meters", this.jGoMeters);
            this.populateBasicScales(this.jGoScales);
            this.jTabbedPane1.addTab("Basic Scales", this.jGoScales);
            this.jGoScales.getDocument().setUndoManager(new JGoUndoManager(){

                public void endTransaction(String string) {
                    super.endTransaction(string);
                    Inspector.refresh();
                }
            });
            this.jGoMeters.getDocument().setUndoManager(new JGoUndoManager(){

                public void endTransaction(String string) {
                    super.endTransaction(string);
                    Inspector.refresh();
                }
            });
            this.jGoSpecial.getDocument().setUndoManager(new JGoUndoManager(){

                public void endTransaction(String string) {
                    super.endTransaction(string);
                    Inspector.refresh();
                }
            });
            this.myTimer1Action = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Serializable serializable;
                    InstrumentsDemoFrame.this.jGoScales.getDocument().setSkipsUndoManager(true);
                    InstrumentsDemoFrame.this.jGoMeters.getDocument().setSkipsUndoManager(true);
                    InstrumentsDemoFrame.this.jGoSpecial.getDocument().setSkipsUndoManager(true);
                    for (int i = 0; i < InstrumentsDemoFrame.this.myMeters.size(); ++i) {
                        if (!(InstrumentsDemoFrame.this.myMeters.get(i) instanceof Meter)) continue;
                        serializable = (Meter)InstrumentsDemoFrame.this.myMeters.get(i);
                        double d = ((Meter)serializable).getValue();
                        ((Meter)serializable).setValue(d + ((Meter)serializable).getScale().getRange() / 100.0);
                        if (d == ((Meter)serializable).getValue()) {
                            ((Meter)serializable).setValue(((Meter)serializable).getScale().getMinimum());
                        }
                        if (!(serializable instanceof GaugeMeter)) continue;
                        GaugeMeter gaugeMeter = (GaugeMeter)serializable;
                        gaugeMeter.getGauge().setValue(gaugeMeter.getGauge().getValue() + gaugeMeter.getScale().getRange() / 100.0);
                    }
                    JGoDocument jGoDocument = InstrumentsDemoFrame.this.jGoSpecial.getDocument();
                    serializable = jGoDocument.getFirstObjectPos();
                    while (serializable != null) {
                        JGoObject jGoObject = jGoDocument.getObjectAtPos((JGoListPosition)serializable);
                        serializable = jGoDocument.getNextObjectPosAtTop((JGoListPosition)serializable);
                        if (!(jGoObject instanceof Tank)) continue;
                        Tank tank = (Tank)jGoObject;
                        tank.drain();
                    }
                    InstrumentsDemoFrame.this.jGoScales.getDocument().setSkipsUndoManager(false);
                    InstrumentsDemoFrame.this.jGoMeters.getDocument().setSkipsUndoManager(false);
                    InstrumentsDemoFrame.this.jGoSpecial.getDocument().setSkipsUndoManager(false);
                }
            };
            this.myTimer1 = new Timer(100, this.myTimer1Action);
            this.myTimer1.start();
            this.myTimer2Action = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JGoDocument jGoDocument = InstrumentsDemoFrame.this.jGoSpecial.getDocument();
                    jGoDocument.setSkipsUndoManager(true);
                    if (InstrumentsDemoFrame.this.myClock != null) {
                        InstrumentsDemoFrame.this.myClock.incrementTime();
                    }
                    jGoDocument.setSkipsUndoManager(false);
                }
            };
            this.myTimer2 = new Timer(1000, this.myTimer2Action);
            this.myTimer2.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void populateBasicScales(JGoView jGoView) {
        JGoDocument jGoDocument = jGoView.getDocument();
        GraduatedScaleLinear graduatedScaleLinear = new GraduatedScaleLinear();
        graduatedScaleLinear.setSelectable(true);
        graduatedScaleLinear.setStartPoint(new Point(40, 160));
        graduatedScaleLinear.setEndPoint(new Point(210, 45));
        graduatedScaleLinear.setTickLengthLeft(10.0f);
        graduatedScaleLinear.setTickMajorLengthRatio(1.0f);
        graduatedScaleLinear.setTickUnit(2.5);
        graduatedScaleLinear.setTickMajorFrequency(4);
        graduatedScaleLinear.setMinimum(-23.0);
        graduatedScaleLinear.setMaximum(77.0);
        jGoDocument.addObjectAtTail(graduatedScaleLinear);
        GraduatedScaleElliptical graduatedScaleElliptical = new GraduatedScaleElliptical();
        graduatedScaleElliptical.setSelectable(true);
        graduatedScaleElliptical.setBoundingRect(210, 120, 100, 80);
        graduatedScaleElliptical.setStartAngle(20.0);
        graduatedScaleElliptical.setSweepAngle(200.0);
        graduatedScaleElliptical.setTickLengthLeft(10.0f);
        graduatedScaleElliptical.setMinimum(40.0);
        graduatedScaleElliptical.setMaximum(150.0);
        jGoDocument.addObjectAtTail(graduatedScaleElliptical);
        Ruler ruler = new Ruler();
        ruler.setStartPoint(new Point(26, 300));
        ruler.setEndPoint(new Point(260, 300));
        jGoDocument.addObjectAtTail(ruler);
    }

    private void populateSampleMeters(JGoView jGoView) {
        JGoDocument jGoDocument = jGoView.getDocument();
        NeedleMeter needleMeter = new NeedleMeter();
        needleMeter.initialize();
        needleMeter.setBoundingRect(10, 10, 200, 110);
        needleMeter.getScale().setMinimum(-20.0);
        jGoDocument.addObjectAtTail(needleMeter);
        NeedleMeterElliptical needleMeterElliptical = new NeedleMeterElliptical();
        needleMeterElliptical.initialize();
        needleMeterElliptical.setBoundingRect(7, 530, 201, 207);
        jGoDocument.addObjectAtTail(needleMeterElliptical);
        BarMeter barMeter = new BarMeter();
        barMeter.initialize();
        barMeter.setBoundingRect(234, 11, 200, 80);
        barMeter.setValue(30.0);
        jGoDocument.addObjectAtTail(barMeter);
        GradientBarMeter gradientBarMeter = new GradientBarMeter();
        gradientBarMeter.initialize();
        gradientBarMeter.setBoundingRect(234, 105, 200, 80);
        gradientBarMeter.setValue(90.0);
        jGoDocument.addObjectAtTail(gradientBarMeter);
        BarMeterElliptical barMeterElliptical = new BarMeterElliptical();
        barMeterElliptical.initialize();
        barMeterElliptical.setBoundingRect(546, 11, 200, 200);
        barMeterElliptical.setValue(30.0);
        jGoDocument.addObjectAtTail(barMeterElliptical);
        SliderMeter sliderMeter = new SliderMeter();
        sliderMeter.initialize();
        sliderMeter.setBoundingRect(450, 11, 80, 200);
        sliderMeter.setValue(30.0);
        jGoDocument.addObjectAtTail(sliderMeter);
        SliderMeterElliptical sliderMeterElliptical = new SliderMeterElliptical();
        sliderMeterElliptical.initialize();
        sliderMeterElliptical.setBoundingRect(274, 539, 200, 200 + sliderMeterElliptical.getLabel().getHeight());
        sliderMeterElliptical.setValue(30.0);
        jGoDocument.addObjectAtTail(sliderMeterElliptical);
        OverrunMeter overrunMeter = new OverrunMeter();
        overrunMeter.initialize();
        overrunMeter.setBoundingRect(16, 250, 200, 200 + overrunMeter.getLabel().getHeight());
        overrunMeter.setValue(30.0);
        this.myMeters.add(overrunMeter);
        jGoDocument.addObjectAtTail(overrunMeter);
        GaugeMeter gaugeMeter = new GaugeMeter();
        gaugeMeter.initialize();
        gaugeMeter.setBoundingRect(266, 250, 200, 200 + gaugeMeter.getLabel().getHeight());
        this.myMeters.add(gaugeMeter);
        jGoDocument.addObjectAtTail(gaugeMeter);
        MultiPhaseMeter multiPhaseMeter = new MultiPhaseMeter();
        multiPhaseMeter.initialize();
        multiPhaseMeter.setBoundingRect(516, 250, 200, 200 + multiPhaseMeter.getLabel().getHeight());
        multiPhaseMeter.setValue(30.0);
        this.myMeters.add(multiPhaseMeter);
        jGoDocument.addObjectAtTail(multiPhaseMeter);
        MultiPhaseMeterElliptical multiPhaseMeterElliptical = new MultiPhaseMeterElliptical();
        multiPhaseMeterElliptical.initialize();
        multiPhaseMeterElliptical.setBoundingRect(766, 250, 200, 200 + multiPhaseMeterElliptical.getLabel().getHeight());
        multiPhaseMeterElliptical.setValue(30.0);
        this.myMeters.add(multiPhaseMeterElliptical);
        jGoDocument.addObjectAtTail(multiPhaseMeterElliptical);
        KnobMeter knobMeter = new KnobMeter();
        knobMeter.initialize();
        knobMeter.setBoundingRect(764, 12, 200, 200 + knobMeter.getLabel().getHeight());
        knobMeter.setValue(30.0);
        jGoDocument.addObjectAtTail(knobMeter);
    }

    private void populateSpecial(JGoView jGoView) {
        JGoDocument jGoDocument = jGoView.getDocument();
        Clock clock = new Clock();
        clock.initialize();
        JGoImage jGoImage = new JGoImage();
        jGoImage.setSelectable(false);
        jGoImage.loadImage((class$com$nwoods$jgo$examples$instrumentdemo$InstrumentDemo == null ? (class$com$nwoods$jgo$examples$instrumentdemo$InstrumentDemo = InstrumentsDemoFrame.class$("com.nwoods.jgo.examples.instrumentdemo.InstrumentDemo")) : class$com$nwoods$jgo$examples$instrumentdemo$InstrumentDemo).getResource("clock_face2.gif"), false);
        clock.setBackground(jGoImage);
        clock.setBoundingRect(10, 10, 150, 150);
        Date date = new Date();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        clock.setTime(gregorianCalendar.get(11), gregorianCalendar.get(12), gregorianCalendar.get(13));
        this.myClock = clock;
        jGoDocument.addObjectAtTail(clock);
        Thermometer thermometer = new Thermometer();
        thermometer.initialize();
        thermometer.setBoundingRect(30, 200, 100, 250);
        jGoDocument.addObjectAtTail(thermometer);
        Tank tank = new Tank();
        tank.initialize();
        tank.setBoundingRect(220, 50, 70, 100);
        tank.setValue(900.0);
        jGoDocument.addObjectAtTail(tank);
        Tank tank2 = new Tank();
        tank2.initialize();
        tank2.setBoundingRect(280, 200, 70, 100);
        tank2.setValue(600.0);
        jGoDocument.addObjectAtTail(tank2);
        Tank tank3 = new Tank();
        tank3.initialize();
        tank3.setBoundingRect(160, 200, 70, 100);
        tank3.setValue(900.0);
        jGoDocument.addObjectAtTail(tank3);
        Tank tank4 = new Tank();
        tank4.initialize();
        tank4.setBoundingRect(400, 200, 70, 100);
        tank4.setValue(0.0);
        jGoDocument.addObjectAtTail(tank4);
        Pipe pipe = new Pipe();
        pipe.setFromPort(tank.getOutputPort());
        pipe.setToPort(tank2.getInputPort());
        pipe.setRate(2.0);
        jGoDocument.addObjectAtHead(pipe);
        Pipe pipe2 = new Pipe();
        pipe2.setFromPort(tank.getOutputPort());
        pipe2.setToPort(tank3.getInputPort());
        pipe2.setRate(0.5);
        jGoDocument.addObjectAtHead(pipe2);
        Pipe pipe3 = new Pipe();
        pipe3.setFromPort(tank2.getOutputPort());
        pipe3.setToPort(tank4.getInputPort());
        jGoDocument.addObjectAtHead(pipe3);
        MultiBarMeter multiBarMeter = new MultiBarMeter();
        multiBarMeter.initialize();
        multiBarMeter.setBoundingRect(500, 50, 400, 300);
        jGoDocument.addObjectAtTail(multiBarMeter);
    }

    private void jbInit() throws Exception {
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(this.borderLayout1);
        this.setSize(new Dimension(1024, 870));
        this.setTitle("Instruments Demo");
        this.jMenuFile.setText("File");
        this.jMenuFileExit.setText("Exit");
        this.jMenuFileExit.addActionListener(new InstrumentsDemoFrame_jMenuFileExit_ActionAdapter(this));
        this.jMenuHelp.setText("Help");
        this.jMenuHelpAbout.setText("About");
        this.jMenuHelpAbout.addActionListener(new InstrumentsDemoFrame_jMenuHelpAbout_ActionAdapter(this));
        this.contentPane.setPreferredSize(new Dimension(800, 600));
        this.contentPane.setRequestFocusEnabled(true);
        this.jTabbedPane1.setPreferredSize(new Dimension(800, 600));
        this.jMenuEdit.setText("Edit");
        this.jMenuZoomOut.setText("Zoom Out");
        this.jMenuZoomOut.setAccelerator(KeyStroke.getKeyStroke(117, 1));
        this.jMenuZoomOut.addActionListener(new InstrumentsDemoFrame_jMenuZoomOut_actionAdapter(this));
        this.jMenuZoomIn.setText("Zoom In");
        this.jMenuZoomIn.setAccelerator(KeyStroke.getKeyStroke(117, 2));
        this.jMenuZoomIn.addActionListener(new InstrumentsDemoFrame_jMenuZoomIn_actionAdapter(this));
        this.jMenuZoomNormalSize.setText("Zoom Normal Size");
        this.jMenuZoomNormalSize.setAccelerator(KeyStroke.getKeyStroke(117, 3));
        this.jMenuZoomNormalSize.addActionListener(new InstrumentsDemoFrame_jMenuZoomNormalSize_actionAdapter(this));
        this.jMenuZoomToFit.setText("Zoom To Fit");
        this.jMenuZoomToFit.setAccelerator(KeyStroke.getKeyStroke(117, 0));
        this.jMenuZoomToFit.addActionListener(new InstrumentsDemoFrame_jMenuZoomToFit_actionAdapter(this));
        this.jMenuCut.setText("Cut");
        this.jMenuCut.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.jMenuCut.addActionListener(new InstrumentsDemoFrame_jMenuCut_actionAdapter(this));
        this.jMenuCopy.setText("Copy");
        this.jMenuCopy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.jMenuCopy.addActionListener(new InstrumentsDemoFrame_jMenuCopy_actionAdapter(this));
        this.jMenuPaste.setText("Paste");
        this.jMenuPaste.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.jMenuPaste.addActionListener(new InstrumentsDemoFrame_jMenuPaste_actionAdapter(this));
        this.jMenuUndo.setText("Undo");
        this.jMenuUndo.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.jMenuUndo.addActionListener(new InstrumentsDemoFrame_jMenuUndo_actionAdapter(this));
        this.jMenuRedo.setText("Redo");
        this.jMenuRedo.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        this.jMenuRedo.addActionListener(new InstrumentsDemoFrame_jMenuRedo_actionAdapter(this));
        this.jMenuInspect.setText("Inspect");
        this.jMenuInspect.setAccelerator(KeyStroke.getKeyStroke(10, 0));
        this.jMenuInspect.addActionListener(new InstrumentsDemoFrame_jMenuInspect_actionAdapter(this));
        this.jMenuSVGOut.setText("Write SVG");
        this.jMenuSVGOut.addActionListener(new InstrumentsDemoFrame_jMenuSVGOut_actionAdapter(this));
        this.jMenuSVGIn.setText("Read SVG");
        this.jMenuSVGIn.addActionListener(new InstrumentsDemoFrame_jMenuSVGIn_actionAdapter(this));
        this.jMenuToggleAnimation.setText("Stop Animation");
        this.jMenuToggleAnimation.addActionListener(new InstrumentsDemoFrame_jMenuToggleAnimation_actionAdapter(this));
        this.jMenuFile.add(this.jMenuSVGOut);
        this.jMenuFile.add(this.jMenuSVGIn);
        this.jMenuFile.add(this.jMenuFileExit);
        this.jMenuHelp.add(this.jMenuHelpAbout);
        this.jMenuBar1.add(this.jMenuFile);
        this.jMenuBar1.add(this.jMenuEdit);
        this.jMenuBar1.add(this.jMenuHelp);
        this.setJMenuBar(this.jMenuBar1);
        this.contentPane.add((Component)this.jTabbedPane1, "Center");
        this.jMenuEdit.add(this.jMenuCut);
        this.jMenuEdit.add(this.jMenuCopy);
        this.jMenuEdit.add(this.jMenuPaste);
        this.jMenuEdit.addSeparator();
        this.jMenuEdit.add(this.jMenuUndo);
        this.jMenuEdit.add(this.jMenuRedo);
        this.jMenuEdit.addSeparator();
        this.jMenuEdit.add(this.jMenuZoomOut);
        this.jMenuEdit.add(this.jMenuZoomIn);
        this.jMenuEdit.add(this.jMenuZoomNormalSize);
        this.jMenuEdit.add(this.jMenuZoomToFit);
        this.jMenuEdit.addSeparator();
        this.jMenuEdit.add(this.jMenuToggleAnimation);
        this.jMenuEdit.addSeparator();
        this.jMenuEdit.add(this.jMenuInspect);
    }

    public void jMenuFileExit_actionPerformed(ActionEvent actionEvent) {
        System.exit(0);
    }

    public void jMenuHelpAbout_actionPerformed(ActionEvent actionEvent) {
        InstrumentsDemoFrame_AboutBox instrumentsDemoFrame_AboutBox = new InstrumentsDemoFrame_AboutBox(this);
        Dimension dimension = instrumentsDemoFrame_AboutBox.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        instrumentsDemoFrame_AboutBox.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        instrumentsDemoFrame_AboutBox.setModal(true);
        instrumentsDemoFrame_AboutBox.pack();
        instrumentsDemoFrame_AboutBox.setVisible(true);
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            this.jMenuFileExit_actionPerformed(null);
        }
    }

    void jMenuZoomOut_actionPerformed(ActionEvent actionEvent) {
        JGoView jGoView = (JGoView)this.jTabbedPane1.getSelectedComponent();
        double d = Math.rint(jGoView.getScale() * (double)0.9f * 100.0) / 100.0;
        jGoView.setScale(d);
    }

    void jMenuZoomIn_actionPerformed(ActionEvent actionEvent) {
        JGoView jGoView = (JGoView)this.jTabbedPane1.getSelectedComponent();
        double d = Math.rint(jGoView.getScale() / (double)0.9f * 100.0) / 100.0;
        jGoView.setScale(d);
    }

    void jMenuZoomNormalSize_actionPerformed(ActionEvent actionEvent) {
        JGoView jGoView = (JGoView)this.jTabbedPane1.getSelectedComponent();
        double d = 1.0;
        jGoView.setScale(d);
    }

    void jMenuZoomToFit_actionPerformed(ActionEvent actionEvent) {
        JGoView jGoView = (JGoView)this.jTabbedPane1.getSelectedComponent();
        double d = 1.0;
        if (!jGoView.getDocument().isEmpty()) {
            double d2 = jGoView.getExtentSize().width;
            double d3 = jGoView.getPrintDocumentSize().width;
            double d4 = jGoView.getExtentSize().height;
            double d5 = jGoView.getPrintDocumentSize().height;
            d = Math.min(d2 / d3, d4 / d5);
        }
        if (d > 2.0) {
            d = 1.0;
        }
        jGoView.setScale(d *= jGoView.getScale());
        jGoView.setViewPosition(0, 0);
    }

    public void viewChanged(JGoViewEvent jGoViewEvent) {
        switch (jGoViewEvent.getHint()) {
            case 1: 
            case 20: 
            case 21: {
                JGoView jGoView = (JGoView)this.jTabbedPane1.getSelectedComponent();
                if (Inspector.getInspector() == null || !Inspector.getInspector().isVisible()) break;
                Inspector.inspect(jGoView.getSelection().getPrimarySelection());
                break;
            }
            case 23: {
                JGoView jGoView = (JGoView)this.jTabbedPane1.getSelectedComponent();
                Inspector.inspect(jGoView.getSelection().getPrimarySelection());
            }
        }
    }

    void handleKeyPressed(KeyEvent keyEvent) {
        JGoView jGoView = (JGoView)this.jTabbedPane1.getSelectedComponent();
        int n = keyEvent.getKeyCode();
        if (n == 10) {
            this.inspectAction();
        } else if (n == 127) {
            jGoView.deleteSelection();
        } else if (n == 36) {
            Rectangle rectangle = jGoView.getDocument().computeBounds();
            jGoView.setViewPosition(rectangle.x, rectangle.y);
        } else if (n == 35) {
            Rectangle rectangle = jGoView.getDocument().computeBounds();
            Dimension dimension = jGoView.getExtentSize();
            jGoView.setViewPosition(Math.max(rectangle.x, rectangle.x + rectangle.width - dimension.width), Math.max(rectangle.y, rectangle.y + rectangle.height - dimension.height));
        } else if (keyEvent.isControlDown() && n == 65) {
            jGoView.selectAll();
        } else if (keyEvent.isControlDown() && n == 81) {
            System.exit(0);
        }
    }

    void inspectAction() {
        JGoView jGoView = (JGoView)this.jTabbedPane1.getSelectedComponent();
        Inspector.inspect(jGoView.getSelection().getPrimarySelection());
        JDialog jDialog = Inspector.getInspector();
        if (jDialog != null && !jDialog.isVisible()) {
            jDialog.setVisible(true);
        }
    }

    void jMenuCut_actionPerformed(ActionEvent actionEvent) {
        JGoView jGoView = (JGoView)this.jTabbedPane1.getSelectedComponent();
        jGoView.cut();
    }

    void jMenuCopy_actionPerformed(ActionEvent actionEvent) {
        JGoView jGoView = (JGoView)this.jTabbedPane1.getSelectedComponent();
        jGoView.copy();
    }

    void jMenuPaste_actionPerformed(ActionEvent actionEvent) {
        JGoView jGoView = (JGoView)this.jTabbedPane1.getSelectedComponent();
        jGoView.paste();
    }

    void jMenuUndo_actionPerformed(ActionEvent actionEvent) {
        JGoView jGoView = (JGoView)this.jTabbedPane1.getSelectedComponent();
        jGoView.getDocument().undo();
    }

    void jMenuRedo_actionPerformed(ActionEvent actionEvent) {
        JGoView jGoView = (JGoView)this.jTabbedPane1.getSelectedComponent();
        jGoView.getDocument().redo();
    }

    void jMenuInspect_actionPerformed(ActionEvent actionEvent) {
        this.inspectAction();
    }

    void jMenuSVGOut_actionPerformed(ActionEvent actionEvent) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream("c:\\temp\\test.svg");
            DefaultDocument defaultDocument = new DefaultDocument();
            defaultDocument.setGenerateJGoXML(true);
            defaultDocument.setGenerateSVG(true);
            JGoView jGoView = (JGoView)this.jTabbedPane1.getSelectedComponent();
            defaultDocument.SVGWriteDoc((OutputStream)fileOutputStream, jGoView.getDocument());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void jMenuSVGIn_actionPerformed(ActionEvent actionEvent) {
        try {
            JGoView jGoView = (JGoView)this.jTabbedPane1.getSelectedComponent();
            JGoDocument jGoDocument = jGoView.getDocument();
            FileInputStream fileInputStream = new FileInputStream("c:\\temp\\test.svg");
            DefaultDocument defaultDocument = new DefaultDocument();
            defaultDocument.SVGReadDoc((InputStream)fileInputStream, jGoDocument);
            fileInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void jMenuToggleAnimation_actionPerformed(ActionEvent actionEvent) {
        if (this.myTimer1.isRunning()) {
            this.myTimer1.stop();
            this.myTimer2.stop();
            this.jMenuToggleAnimation.setText("Start Animation");
        } else {
            this.myTimer1.restart();
            this.myTimer2.restart();
            this.jMenuToggleAnimation.setText("Stop Animation");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

