/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.instrumentdemo;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoDrawable;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoStroke;
import com.nwoods.jgo.JGoView;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;

public class JGoCylinder
extends JGoDrawable {
    public static final int ChangedMinorRadius = 1481;
    public static final int ChangedPerspective = 1483;
    private int myMinorRadius = 10;
    private int myPerspective = 2;
    private transient GeneralPath myPath = null;

    public JGoObject copyObject(JGoCopyEnvironment jGoCopyEnvironment) {
        JGoCylinder jGoCylinder = (JGoCylinder)super.copyObject(jGoCopyEnvironment);
        jGoCylinder.myMinorRadius = this.myMinorRadius;
        jGoCylinder.myPerspective = this.myPerspective;
        jGoCylinder.myPath = null;
        return jGoCylinder;
    }

    public int getMinorRadius() {
        return this.myMinorRadius;
    }

    public void setMinorRadius(int n) {
        int n2 = this.myMinorRadius;
        if (n < 0) {
            n = 0;
        }
        if (n2 != n) {
            this.myMinorRadius = n;
            this.resetPath();
            this.update(1481, n2, null);
        }
    }

    public int getPerspective() {
        return this.myPerspective;
    }

    public void setPerspective(int n) {
        int n2 = this.myPerspective;
        if (n2 != n) {
            this.myPerspective = n;
            this.resetPath();
            this.update(1483, n2, null);
        }
    }

    protected void geometryChange(Rectangle rectangle) {
        super.geometryChange(rectangle);
        this.resetPath();
    }

    public void paint(Graphics2D graphics2D, JGoView jGoView) {
        GeneralPath generalPath = this.getPath(jGoView);
        JGoCylinder.drawPath(graphics2D, this.getPen(), this.getBrush(), generalPath);
    }

    GeneralPath getPath(JGoView jGoView) {
        if (this.myPath == null) {
            this.myPath = new GeneralPath(1, 8);
        }
        if (this.myPath.getCurrentPoint() == null) {
            this.makePath(this.myPath, jGoView);
        }
        return this.myPath;
    }

    void resetPath() {
        if (this.myPath != null) {
            this.myPath.reset();
        }
    }

    void makePath(GeneralPath generalPath, JGoView jGoView) {
        Rectangle rectangle = this.getBoundingRect();
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = this.getMinorRadius();
        if (n5 == 0) {
            int n6 = n;
            int n7 = n + n3;
            int n8 = n2;
            int n9 = n2 + n4;
            generalPath.moveTo(n6, n8);
            generalPath.lineTo(n7, n8);
            generalPath.lineTo(n7, n9);
            generalPath.lineTo(n6, n9);
            generalPath.lineTo(n6, n8);
        } else if (this.getPerspective() == 2 || this.getPerspective() == 6) {
            if (n5 > n4 / 2) {
                n5 = n4 / 2;
            }
            int n10 = n5 * 2;
            int n11 = n;
            int n12 = n + n3;
            int n13 = n2;
            int n14 = n2 + n5;
            int n15 = n2 + n4 - n10;
            int n16 = n2 + n4 - n5;
            if (this.getPerspective() == 2) {
                generalPath.moveTo(n12, n14);
                generalPath.lineTo(n12, n16);
                generalPath.append(new Arc2D.Float(n11, n15, n3, n10, 0.0f, -180.0f, 0), true);
                generalPath.lineTo(n11, n14);
                generalPath.append(new Ellipse2D.Float(n11, n13, n3, n10), false);
            } else {
                generalPath.moveTo(n11, n16);
                generalPath.lineTo(n11, n14);
                generalPath.append(new Arc2D.Float(n11, n13, n3, n10, 180.0f, -180.0f, 0), true);
                generalPath.lineTo(n12, n16);
                generalPath.append(new Ellipse2D.Float(n11, n15, n3, n10), false);
            }
        } else {
            if (n5 > n3 / 2) {
                n5 = n3 / 2;
            }
            int n17 = n5 * 2;
            int n18 = n;
            int n19 = n + n5;
            int n20 = n + n3 - n17;
            int n21 = n + n3 - n5;
            int n22 = n2;
            int n23 = n2 + n4;
            if (this.getPerspective() == 8) {
                generalPath.moveTo(n19, n22);
                generalPath.lineTo(n21, n22);
                generalPath.append(new Arc2D.Float(n20, n22, n17, n4, 90.0f, -180.0f, 0), true);
                generalPath.lineTo(n19, n23);
                generalPath.append(new Ellipse2D.Float(n18, n22, n17, n4), false);
            } else {
                generalPath.moveTo(n21, n23);
                generalPath.lineTo(n19, n23);
                generalPath.append(new Arc2D.Float(n18, n22, n17, n4, 270.0f, -180.0f, 0), true);
                generalPath.lineTo(n21, n22);
                generalPath.append(new Ellipse2D.Float(n20, n22, n17, n4), false);
            }
        }
    }

    public boolean isPointInObj(Point point) {
        if (!super.isPointInObj(point)) {
            return false;
        }
        GeneralPath generalPath = this.getPath(null);
        return generalPath.contains(point.x, point.y);
    }

    public boolean getNearestIntersectionPoint(int n, int n2, int n3, int n4, Point point) {
        float f;
        float f2;
        float f3;
        float f4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19;
        int n20;
        int n21;
        int n22;
        int n23;
        int n24;
        int n25;
        int n26;
        int n27;
        int n28;
        int n29;
        int n30 = this.getPen() != null ? (this.getPen().getWidth() + 1) / 2 : 1;
        Rectangle rectangle = this.getBoundingRect();
        int n31 = rectangle.x - n30;
        int n32 = rectangle.y - n30;
        int n33 = rectangle.width + 2 * n30;
        int n34 = rectangle.height + 2 * n30;
        int n35 = this.getMinorRadius();
        if (this.getPerspective() == 2 || this.getPerspective() == 6) {
            if (n35 > n34 / 2) {
                n35 = n34 / 2;
            }
            n29 = n35 * 2;
            n28 = n31;
            n27 = n31 + n33;
            n26 = n32;
            n25 = n32 + n35;
            int n36 = n32 + n34 - n29;
            int n37 = n32 + n34 - n35;
            n24 = n27;
            n23 = n25;
            n22 = n27;
            n21 = n37;
            n20 = n28;
            n19 = n37;
            n18 = n28;
            n17 = n25;
            if (this.getPerspective() == 2) {
                n16 = n28;
                n15 = n36;
                n14 = n33;
                n13 = n29;
                n12 = 0;
                n11 = -180;
                n10 = n28;
                n9 = n26;
                n8 = n33;
                n7 = n29;
                n6 = 180;
                n5 = -180;
            } else {
                n16 = n28;
                n15 = n26;
                n14 = n33;
                n13 = n29;
                n12 = 180;
                n11 = -180;
                n10 = n28;
                n9 = n36;
                n8 = n33;
                n7 = n29;
                n6 = 0;
                n5 = -180;
            }
        } else {
            if (n35 > n33 / 2) {
                n35 = n33 / 2;
            }
            n29 = n35 * 2;
            n28 = n31;
            n27 = n31 + n35;
            n26 = n31 + n33 - n29;
            n25 = n31 + n33 - n35;
            int n38 = n32;
            int n39 = n32 + n34;
            n24 = n27;
            n23 = n38;
            n22 = n25;
            n21 = n38;
            n20 = n25;
            n19 = n39;
            n18 = n27;
            n17 = n39;
            if (this.getPerspective() == 8) {
                n16 = n26;
                n15 = n38;
                n14 = n29;
                n13 = n34;
                n12 = 270;
                n11 = -180;
                n10 = n28;
                n9 = n38;
                n8 = n29;
                n7 = n34;
                n6 = 90;
                n5 = -180;
            } else {
                n16 = n28;
                n15 = n38;
                n14 = n29;
                n13 = n34;
                n12 = 90;
                n11 = -180;
                n10 = n26;
                n9 = n38;
                n8 = n29;
                n7 = n34;
                n6 = 270;
                n5 = -180;
            }
        }
        Point point2 = new Point();
        float f5 = 1.0E21f;
        n27 = 0;
        n26 = 0;
        if (JGoStroke.getNearestIntersectionOnLine(n24, n23, n22, n21, n, n2, n3, n4, point2) && (f4 = (float)((point2.x - n) * (point2.x - n) + (point2.y - n2) * (point2.y - n2))) < f5) {
            f5 = f4;
            n27 = point2.x;
            n26 = point2.y;
        }
        if (JGoStroke.getNearestIntersectionOnLine(n20, n19, n18, n17, n, n2, n3, n4, point2) && (f3 = (float)((point2.x - n) * (point2.x - n) + (point2.y - n2) * (point2.y - n2))) < f5) {
            f5 = f3;
            n27 = point2.x;
            n26 = point2.y;
        }
        if (JGoCylinder.getNearestIntersectionOnArc(n16, n15, n14, n13, n, n2, n3, n4, point2, n12, -n11) && (f2 = (float)((point2.x - n) * (point2.x - n) + (point2.y - n2) * (point2.y - n2))) < f5) {
            f5 = f2;
            n27 = point2.x;
            n26 = point2.y;
        }
        if (JGoCylinder.getNearestIntersectionOnArc(n10, n9, n8, n7, n, n2, n3, n4, point2, n6, -n5) && (f = (float)((point2.x - n) * (point2.x - n) + (point2.y - n2) * (point2.y - n2))) < f5) {
            f5 = f;
            n27 = point2.x;
            n26 = point2.y;
        }
        point.x = n27;
        point.y = n26;
        return f5 < 1.0E21f;
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit jGoDocumentChangedEdit) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 1481: {
                jGoDocumentChangedEdit.setNewValueInt(this.getMinorRadius());
                return;
            }
            case 1483: {
                jGoDocumentChangedEdit.setNewValueInt(this.getPerspective());
                return;
            }
        }
        super.copyNewValueForRedo(jGoDocumentChangedEdit);
    }

    public void changeValue(JGoDocumentChangedEdit jGoDocumentChangedEdit, boolean bl) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 1: {
                super.changeValue(jGoDocumentChangedEdit, bl);
                this.resetPath();
                return;
            }
            case 1481: {
                this.setMinorRadius(jGoDocumentChangedEdit.getValueInt(bl));
                return;
            }
            case 1483: {
                this.setPerspective(jGoDocumentChangedEdit.getValueInt(bl));
                return;
            }
        }
        super.changeValue(jGoDocumentChangedEdit, bl);
        this.resetPath();
    }

    public static boolean getNearestIntersectionOnArc(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Point point, float f, float f2) {
        boolean bl;
        float f3;
        float f4;
        float f5 = n3 / 2;
        float f6 = n4 / 2;
        float f7 = (float)n + f5;
        float f8 = (float)n2 + f6;
        if (f2 < 0.0f) {
            f4 = f + f2;
            f3 = -f2;
        } else {
            f4 = f;
            f3 = f2;
        }
        if (n5 != n7) {
            boolean bl2;
            float f9 = n5 > n7 ? (float)(n6 - n8) / (float)(n5 - n7) : (float)(n8 - n6) / (float)(n7 - n5);
            float f10 = (float)n6 - f8 - f9 * ((float)n5 - f7);
            float f11 = (float)Math.sqrt(f5 * f5 * (f9 * f9) + f6 * f6 - f10 * f10);
            float f12 = (-(f5 * f5 * f9 * f10) + f5 * f6 * f11) / (f6 * f6 + f5 * f5 * (f9 * f9)) + f7;
            float f13 = (-(f5 * f5 * f9 * f10) - f5 * f6 * f11) / (f6 * f6 + f5 * f5 * (f9 * f9)) + f7;
            float f14 = f9 * (f12 - f7) + f10 + f8;
            float f15 = f9 * (f13 - f7) + f10 + f8;
            float f16 = JGoCylinder.GetAngle(f12 - f7, f14 - f8);
            float f17 = JGoCylinder.GetAngle(f13 - f7, f15 - f8);
            if (f16 < f4) {
                f16 += 360.0f;
            }
            if (f17 < f4) {
                f17 += 360.0f;
            }
            if (f16 > f4 + f3) {
                f16 -= 360.0f;
            }
            if (f17 > f4 + f3) {
                f17 -= 360.0f;
            }
            boolean bl3 = f16 >= f4 && f16 <= f4 + f3;
            boolean bl4 = bl2 = f17 >= f4 && f17 <= f4 + f3;
            if (bl3 && bl2) {
                float f18;
                float f19 = Math.abs(((float)n5 - f12) * ((float)n5 - f12)) + Math.abs(((float)n6 - f14) * ((float)n6 - f14));
                if (f19 < (f18 = Math.abs(((float)n5 - f13) * ((float)n5 - f13)) + Math.abs(((float)n6 - f15) * ((float)n6 - f15)))) {
                    point.x = (int)f12;
                    point.y = (int)f14;
                } else {
                    point.x = (int)f13;
                    point.y = (int)f15;
                }
                return true;
            }
            if (bl3 && !bl2) {
                point.x = (int)f12;
                point.y = (int)f14;
                return true;
            }
            if (!bl3 && bl2) {
                point.x = (int)f13;
                point.y = (int)f15;
                return true;
            }
            point.x = 0;
            point.y = 0;
            return false;
        }
        float f20 = (float)Math.sqrt(f6 * f6 - f6 * f6 / (f5 * f5) * (((float)n5 - f7) * ((float)n5 - f7)));
        float f21 = f8 + f20;
        float f22 = f8 - f20;
        float f23 = JGoCylinder.GetAngle((float)n5 - f7, f21 - f8);
        float f24 = JGoCylinder.GetAngle((float)n5 - f7, f22 - f8);
        if (f23 < f4) {
            f23 += 360.0f;
        }
        if (f24 < f4) {
            f24 += 360.0f;
        }
        if (f23 > f4 + f3) {
            f23 -= 360.0f;
        }
        if (f24 > f4 + f3) {
            f24 -= 360.0f;
        }
        boolean bl5 = f23 >= f4 && f23 <= f4 + f3;
        boolean bl6 = bl = f24 >= f4 && f24 <= f4 + f3;
        if (bl5 && bl) {
            float f25;
            float f26 = Math.abs(f21 - (float)n6);
            if (f26 < (f25 = Math.abs(f22 - (float)n6))) {
                point.x = n5;
                point.y = (int)f21;
            } else {
                point.x = n5;
                point.y = (int)f22;
            }
            return true;
        }
        if (bl5 && !bl) {
            point.x = n5;
            point.y = (int)f21;
            return true;
        }
        if (!bl5 && bl) {
            point.x = n5;
            point.y = (int)f22;
            return true;
        }
        point.x = 0;
        point.y = 0;
        return false;
    }

    static float GetAngle(float f, float f2) {
        float f3;
        if (f == 0.0f) {
            f3 = f2 > 0.0f ? 90.0f : 270.0f;
        } else if (f2 == 0.0f) {
            f3 = f > 0.0f ? 0.0f : 180.0f;
        } else {
            f3 = (float)(Math.atan(Math.abs(f2 / f)) * 180.0 / Math.PI);
            if (f < 0.0f) {
                f3 = f2 < 0.0f ? (f3 += 180.0f) : 180.0f - f3;
            } else if (f2 < 0.0f) {
                f3 = 360.0f - f3;
            }
        }
        return f3;
    }

    public void SVGWriteObject(DomDoc domDoc, DomElement domElement) {
        if (domDoc.JGoXMLOutputEnabled()) {
            DomElement domElement2 = domDoc.createJGoClassElement("com.nwoods.jgo.examples.instrumentdemo.JGoCylinder", domElement);
            domElement2.setAttribute("minorradius", Integer.toString(this.myMinorRadius));
            domElement2.setAttribute("perspective", Integer.toString(this.myPerspective));
        }
        super.SVGWriteObject(domDoc, domElement);
    }

    public DomNode SVGReadObject(DomDoc domDoc, JGoDocument jGoDocument, DomElement domElement, DomElement domElement2) {
        if (domElement2 != null) {
            this.myMinorRadius = Integer.parseInt(domElement2.getAttribute("minorradius"));
            this.myPerspective = Integer.parseInt(domElement2.getAttribute("perspective"));
            super.SVGReadObject(domDoc, jGoDocument, domElement, domElement2.getNextSiblingJGoClassElement());
        }
        return domElement.getNextSibling();
    }
}

