/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.instrumentdemo;

import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoImage;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoNode;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoRectangle;
import com.nwoods.jgo.JGoText;

public class JGoSimpleNode
extends JGoNode {
    public static final int OrientationHorizontal = 0;
    public static final int OrientationVertical = 1;
    public static final int ChangedText = 2601;
    public static final int ChangedIcon = 2602;
    public static final int ChangedLabel = 2603;
    public static final int ChangedInPort = 2604;
    public static final int ChangedOutPort = 2605;
    public static final int ChangedOrientation = 2606;
    private String myText = "";
    private JGoObject myIcon = null;
    private JGoText myLabel = null;
    private JGoPort myInPort = null;
    private JGoPort myOutPort = null;
    private int myOrientation = 0;

    public void initialize(String string, String string2) {
        this.setInitializing(true);
        this.myIcon = this.createIcon(string);
        this.addObjectAtTail(this.myIcon);
        this.initializeCommon(string2);
    }

    public void initialize(JGoObject jGoObject, String string) {
        this.setInitializing(true);
        this.myIcon = jGoObject;
        this.addObjectAtTail(jGoObject);
        this.initializeCommon(string);
    }

    private void initializeCommon(String string) {
        this.myText = string;
        this.myLabel = this.createLabel(string);
        this.addObjectAtTail(this.myLabel);
        if (this.myLabel != null) {
            this.myLabel.setUpdatePartner(true);
        }
        this.myInPort = this.createPort(true);
        this.addObjectAtTail(this.myInPort);
        this.myOutPort = this.createPort(false);
        this.addObjectAtTail(this.myOutPort);
        this.setInitializing(false);
        this.layoutChildren(null);
    }

    protected JGoObject createIcon(String string) {
        if (string != null) {
            JGoImage jGoImage = new JGoImage();
            jGoImage.loadImage(string, false);
            return jGoImage;
        }
        JGoRectangle jGoRectangle = new JGoRectangle();
        jGoRectangle.setSelectable(false);
        jGoRectangle.setSize(20, 20);
        return jGoRectangle;
    }

    protected JGoText createLabel(String string) {
        JGoText jGoText = null;
        if (string != null) {
            jGoText = new JGoText();
            jGoText.setText(string);
            jGoText.setSelectable(false);
            jGoText.setAlignment(2);
        }
        return jGoText;
    }

    protected JGoPort createPort(boolean bl) {
        JGoPort jGoPort = new JGoPort();
        jGoPort.setSize(6, 6);
        jGoPort.setValidSource(!bl);
        jGoPort.setValidDestination(bl);
        return jGoPort;
    }

    protected void copyChildren(JGoArea jGoArea, JGoCopyEnvironment jGoCopyEnvironment) {
        super.copyChildren(jGoArea, jGoCopyEnvironment);
        JGoSimpleNode jGoSimpleNode = (JGoSimpleNode)jGoArea;
        jGoSimpleNode.myText = this.myText;
        jGoSimpleNode.myIcon = (JGoObject)jGoCopyEnvironment.get(this.myIcon);
        jGoSimpleNode.myLabel = (JGoText)jGoCopyEnvironment.get(this.myLabel);
        jGoSimpleNode.myInPort = (JGoPort)jGoCopyEnvironment.get(this.myInPort);
        jGoSimpleNode.myOutPort = (JGoPort)jGoCopyEnvironment.get(this.myOutPort);
        jGoSimpleNode.myOrientation = this.myOrientation;
    }

    public void layoutChildren(JGoObject jGoObject) {
        if (this.isInitializing()) {
            return;
        }
        JGoObject jGoObject2 = this.getIcon();
        if (jGoObject2 == null) {
            return;
        }
        if (this.getOrientation() == 0) {
            if (this.getLabel() != null) {
                this.getLabel().setSpotLocation(2, jGoObject2, 6);
            }
            if (this.getInPort() != null) {
                this.getInPort().setSpotLocation(4, jGoObject2, 8);
            }
            if (this.getOutPort() != null) {
                this.getOutPort().setSpotLocation(8, jGoObject2, 4);
            }
        } else {
            if (this.getLabel() != null) {
                this.getLabel().setSpotLocation(8, jGoObject2, 4);
            }
            if (this.getInPort() != null) {
                this.getInPort().setSpotLocation(6, jGoObject2, 2);
            }
            if (this.getOutPort() != null) {
                this.getOutPort().setSpotLocation(2, jGoObject2, 6);
            }
        }
    }

    public JGoObject removeObjectAtPos(JGoListPosition jGoListPosition) {
        JGoObject jGoObject = super.removeObjectAtPos(jGoListPosition);
        if (jGoObject == this.myIcon) {
            this.myIcon = null;
        } else if (jGoObject == this.myLabel) {
            this.myLabel = null;
        } else if (jGoObject == this.myInPort) {
            this.myInPort = null;
        } else if (jGoObject == this.myOutPort) {
            this.myOutPort = null;
        }
        return jGoObject;
    }

    public JGoObject getIcon() {
        return this.myIcon;
    }

    public void setIcon(JGoObject jGoObject) {
        JGoObject jGoObject2 = this.myIcon;
        if (jGoObject2 != jGoObject) {
            if (jGoObject2 != null) {
                this.removeObject(jGoObject2);
            }
            this.myIcon = jGoObject;
            if (jGoObject != null) {
                this.addObjectAtHead(jGoObject);
            }
            this.update(2602, 0, jGoObject2);
        }
    }

    public JGoImage getImage() {
        if (this.getIcon() instanceof JGoImage) {
            return (JGoImage)this.getIcon();
        }
        return null;
    }

    public String getText() {
        return this.myText;
    }

    public void setText(String string) {
        String string2 = this.myText;
        if (string2 != string) {
            this.myText = string;
            this.update(2601, 0, string2);
            if (this.getLabel() != null) {
                this.getLabel().setText(string);
            }
        }
    }

    public JGoText getLabel() {
        return this.myLabel;
    }

    public void setLabel(JGoText jGoText) {
        JGoText jGoText2 = this.myLabel;
        if (jGoText2 != jGoText) {
            if (jGoText2 != null) {
                this.removeObject(jGoText2);
            }
            this.myLabel = jGoText;
            if (jGoText != null) {
                this.addObjectAtTail(jGoText);
                jGoText.setUpdatePartner(true);
            }
            this.update(2603, 0, jGoText2);
        }
    }

    public JGoPort getInPort() {
        return this.myInPort;
    }

    public JGoPort getInputPort() {
        return this.myInPort;
    }

    public void setInPort(JGoPort jGoPort) {
        JGoPort jGoPort2 = this.myInPort;
        if (jGoPort2 != jGoPort) {
            if (jGoPort2 != null) {
                this.removeObject(jGoPort2);
            }
            this.myInPort = jGoPort;
            if (jGoPort != null) {
                this.addObjectAtTail(jGoPort);
            }
            this.update(2604, 0, jGoPort2);
        }
    }

    public JGoPort getOutPort() {
        return this.myOutPort;
    }

    public JGoPort getOutputPort() {
        return this.myOutPort;
    }

    public void setOutPort(JGoPort jGoPort) {
        JGoPort jGoPort2 = this.myOutPort;
        if (jGoPort2 != jGoPort) {
            if (jGoPort2 != null) {
                this.removeObject(jGoPort2);
            }
            this.myOutPort = jGoPort;
            if (jGoPort != null) {
                this.addObjectAtTail(jGoPort);
            }
            this.update(2605, 0, jGoPort2);
        }
    }

    public int getOrientation() {
        return this.myOrientation;
    }

    public void setOrientation(int n) {
        this.setOrientation(n, false);
    }

    private void setOrientation(int n, boolean bl) {
        int n2 = this.myOrientation;
        if (n2 != n) {
            this.myOrientation = n;
            this.update(2606, n2, null);
            if (!bl) {
                this.OnOrientationUpdate(n2);
            }
        }
    }

    public void OnOrientationUpdate(int n) {
        if (this.getOrientation() == 1) {
            if (this.getInPort() != null) {
                this.getInPort().setToSpot(2);
                this.getInPort().setFromSpot(2);
            }
            if (this.getOutPort() != null) {
                this.getOutPort().setToSpot(6);
                this.getOutPort().setFromSpot(6);
            }
        } else {
            if (this.getInPort() != null) {
                this.getInPort().setToSpot(8);
                this.getInPort().setFromSpot(8);
            }
            if (this.getOutPort() != null) {
                this.getOutPort().setToSpot(4);
                this.getOutPort().setFromSpot(4);
            }
        }
        this.layoutChildren(null);
    }

    protected void partnerUpdate(JGoObject jGoObject, int n, int n2, Object object) {
        super.partnerUpdate(jGoObject, n, n2, object);
        if (n == 501 && jGoObject == this.getLabel()) {
            this.setText(this.getLabel().getText());
        }
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit jGoDocumentChangedEdit) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 2601: {
                jGoDocumentChangedEdit.setNewValue(this.getText());
                return;
            }
            case 2602: {
                jGoDocumentChangedEdit.setNewValue(this.getIcon());
                return;
            }
            case 2603: {
                jGoDocumentChangedEdit.setNewValue(this.getLabel());
                return;
            }
            case 2604: {
                jGoDocumentChangedEdit.setNewValue(this.getInPort());
                return;
            }
            case 2605: {
                jGoDocumentChangedEdit.setNewValue(this.getOutPort());
                return;
            }
            case 2606: {
                jGoDocumentChangedEdit.setNewValueInt(this.getOrientation());
                return;
            }
        }
        super.copyNewValueForRedo(jGoDocumentChangedEdit);
    }

    public void changeValue(JGoDocumentChangedEdit jGoDocumentChangedEdit, boolean bl) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 2601: {
                this.setText((String)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
            case 2602: {
                this.setIcon((JGoObject)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
            case 2603: {
                this.setLabel((JGoText)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
            case 2604: {
                this.setInPort((JGoPort)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
            case 2605: {
                this.setOutPort((JGoPort)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
            case 2606: {
                this.setOrientation(jGoDocumentChangedEdit.getValueInt(bl));
                return;
            }
        }
        super.changeValue(jGoDocumentChangedEdit, bl);
    }
}

