/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.instrumentdemo;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.examples.instrumentdemo.RoundGradientPaint;
import com.nwoods.jgo.instruments.AbstractGraduatedScale;
import com.nwoods.jgo.instruments.AbstractIndicator;
import com.nwoods.jgo.instruments.GraduatedScaleElliptical;
import com.nwoods.jgo.instruments.IndicatorKnob;
import com.nwoods.jgo.instruments.Meter;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.Point2D;

public class KnobMeter
extends Meter {
    public void initialize() {
        super.initialize();
        int n = 30;
        if (this.getLabel() != null) {
            n += this.getLabel().getHeight();
        }
        this.setInsets(new Insets(30, 30, n, 30));
    }

    public JGoObject copyObject(JGoCopyEnvironment jGoCopyEnvironment) {
        KnobMeter knobMeter = (KnobMeter)super.copyObject(jGoCopyEnvironment);
        knobMeter.UpdateBrush();
        return knobMeter;
    }

    protected AbstractGraduatedScale createScale() {
        GraduatedScaleElliptical graduatedScaleElliptical = new GraduatedScaleElliptical();
        graduatedScaleElliptical.setStartAngle(90.0);
        graduatedScaleElliptical.setSweepAngle(315.0);
        graduatedScaleElliptical.setTickUnit(2.0);
        graduatedScaleElliptical.setTickMajorFrequency(10);
        return graduatedScaleElliptical;
    }

    protected AbstractIndicator createIndicator() {
        IndicatorKnob indicatorKnob = new IndicatorKnob();
        indicatorKnob.setActionEnabled(true);
        indicatorKnob.setQuantized(true);
        indicatorKnob.setQuantizeUnit(2.0);
        return indicatorKnob;
    }

    private void UpdateBrush() {
        if (this.getIndicator() != null) {
            Rectangle rectangle = this.getIndicator().getBoundingRect();
            if (rectangle.width > 0 && rectangle.height > 0) {
                RoundGradientPaint roundGradientPaint = new RoundGradientPaint(rectangle.x + rectangle.width / 3, rectangle.y + rectangle.height / 3, Color.white, new Point2D.Double(rectangle.width / 3, rectangle.height / 3), Color.blue);
                this.getIndicator().setBrush(new JGoBrush(roundGradientPaint));
            } else {
                this.getIndicator().setBrush(JGoBrush.make(65535, new Color(127, 127, 220)));
            }
        }
    }

    protected void geometryChange(Rectangle rectangle) {
        super.geometryChange(rectangle);
        this.UpdateBrush();
    }

    public void layoutChildren(JGoObject jGoObject) {
        if (this.isInitializing()) {
            return;
        }
        if (this.getBackground() != null) {
            if (jGoObject == null) {
                this.getBackground().setBoundingRect(this.getBoundingRect());
            }
            if (jGoObject == null || jGoObject == this.getBackground()) {
                Insets insets = this.getInsets();
                Rectangle rectangle = new Rectangle(this.getBackground().getBoundingRect());
                if (rectangle.width > insets.left + insets.right) {
                    rectangle.x += insets.left;
                    rectangle.width -= insets.left + insets.right;
                }
                if (rectangle.height > insets.top + insets.bottom) {
                    rectangle.y += insets.top;
                    rectangle.height -= insets.top + insets.bottom;
                }
                if (rectangle.width != rectangle.height) {
                    rectangle.height = rectangle.width = Math.min(rectangle.width, rectangle.height);
                    rectangle.x = this.getBackground().getLeft() + this.getBackground().getWidth() / 2 - rectangle.width / 2;
                    rectangle.y = this.getBackground().getTop() + this.getBackground().getHeight() / 2 - rectangle.height / 2;
                }
                if (this.getScale() != null) {
                    this.getScale().setBoundingRect(rectangle);
                }
                if (this.getIndicator() != null) {
                    this.getIndicator().setBoundingRect(rectangle);
                }
                if (this.getLabel() != null) {
                    this.getLabel().setSpotLocation(this.getLabelRelativeSpot(), this.getBackground(), this.getLabelSpot());
                }
            }
        }
        this.UpdateBrush();
    }

    public void changeValue(JGoDocumentChangedEdit jGoDocumentChangedEdit, boolean bl) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 1: {
                super.changeValue(jGoDocumentChangedEdit, bl);
                this.UpdateBrush();
                break;
            }
            default: {
                super.changeValue(jGoDocumentChangedEdit, bl);
            }
        }
    }

    public void SVGWriteObject(DomDoc domDoc, DomElement domElement) {
        if (domDoc.JGoXMLOutputEnabled()) {
            DomElement domElement2 = domDoc.createJGoClassElement("com.nwoods.jgo.examples.instrumentdemo.KnobMeter", domElement);
        }
        super.SVGWriteObject(domDoc, domElement);
    }

    public DomNode SVGReadObject(DomDoc domDoc, JGoDocument jGoDocument, DomElement domElement, DomElement domElement2) {
        if (domElement2 != null) {
            super.SVGReadObject(domDoc, jGoDocument, domElement, domElement2.getNextSiblingJGoClassElement());
        }
        return domElement.getNextSibling();
    }
}

