/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.instrumentdemo;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.examples.instrumentdemo.JGoCylinder;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Rectangle;

public class LinearGradientCylinder
extends JGoCylinder {
    public static final int ChangedStartColor = 12412;
    public static final int ChangedEndColor = 12413;
    private Color myStartColor = Color.white;
    private Color myEndColor = Color.gray;

    protected void geometryChange(Rectangle rectangle) {
        super.geometryChange(rectangle);
        this.setBrush(null);
    }

    public JGoBrush getBrush() {
        JGoBrush jGoBrush = super.getBrush();
        if (jGoBrush == null) {
            Rectangle rectangle = this.getBoundingRect();
            jGoBrush = new JGoBrush(new GradientPaint(rectangle.x, rectangle.y + rectangle.height / 2, this.getStartColor(), rectangle.x + rectangle.width, rectangle.y + rectangle.height / 2, this.getEndColor()));
            this.setBrush(jGoBrush);
        }
        return jGoBrush;
    }

    public Color getStartColor() {
        return this.myStartColor;
    }

    public void setStartColor(Color color) {
        Color color2 = this.myStartColor;
        if (color2 != color) {
            this.myStartColor = color;
            this.setBrush(null);
            this.update(12412, 0, color2);
        }
    }

    public Color getEndColor() {
        return this.myEndColor;
    }

    public void setEndColor(Color color) {
        Color color2 = this.myEndColor;
        if (color2 != color) {
            this.myEndColor = color;
            this.setBrush(null);
            this.update(12413, 0, color2);
        }
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit jGoDocumentChangedEdit) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 12412: {
                jGoDocumentChangedEdit.setNewValue(this.getStartColor());
                return;
            }
            case 12413: {
                jGoDocumentChangedEdit.setNewValue(this.getEndColor());
                return;
            }
        }
        super.copyNewValueForRedo(jGoDocumentChangedEdit);
    }

    public void changeValue(JGoDocumentChangedEdit jGoDocumentChangedEdit, boolean bl) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 1: {
                super.changeValue(jGoDocumentChangedEdit, bl);
                this.setBrush(null);
                break;
            }
            case 12412: {
                this.setStartColor((Color)jGoDocumentChangedEdit.getValue(bl));
                break;
            }
            case 12413: {
                this.setEndColor((Color)jGoDocumentChangedEdit.getValue(bl));
                break;
            }
            default: {
                super.changeValue(jGoDocumentChangedEdit, bl);
            }
        }
    }

    public void SVGWriteObject(DomDoc domDoc, DomElement domElement) {
        if (domDoc.JGoXMLOutputEnabled()) {
            DomElement domElement2 = domDoc.createJGoClassElement("com.nwoods.jgo.examples.instrumentdemo.LinearGradientCylinder", domElement);
        }
        super.SVGWriteObject(domDoc, domElement);
    }

    public DomNode SVGReadObject(DomDoc domDoc, JGoDocument jGoDocument, DomElement domElement, DomElement domElement2) {
        if (domElement2 != null) {
            super.SVGReadObject(domDoc, jGoDocument, domElement, domElement2.getNextSiblingJGoClassElement());
        }
        return domElement.getNextSibling();
    }
}

