/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.instrumentdemo;

import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.instruments.AbstractGraduatedScale;
import com.nwoods.jgo.instruments.GraduatedScaleLinear;
import com.nwoods.jgo.instruments.IndicatorBar;
import com.nwoods.jgo.instruments.MultipleIndicatorMeter;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Random;

public class MultiBarMeter
extends MultipleIndicatorMeter {
    public void initialize() {
        super.initialize();
        Random random = new Random();
        for (int i = 0; i < 3; ++i) {
            IndicatorBar indicatorBar = new IndicatorBar();
            if (i == 0) {
                indicatorBar.setBrush(JGoBrush.green);
            } else if (i == 1) {
                indicatorBar.setBrush(JGoBrush.yellow);
            } else if (i == 2) {
                indicatorBar.setBrush(JGoBrush.blue);
            }
            indicatorBar.setScale(this.getScale());
            indicatorBar.setActionEnabled(true);
            indicatorBar.setValue(random.nextDouble() * 100.0);
            this.addIndicator(indicatorBar);
        }
    }

    protected AbstractGraduatedScale createScale() {
        GraduatedScaleLinear graduatedScaleLinear = new GraduatedScaleLinear();
        graduatedScaleLinear.setLabelStyle(0);
        graduatedScaleLinear.setTickMajorLengthRatio(1.0f);
        graduatedScaleLinear.setTickUnit(5.0);
        graduatedScaleLinear.setTickMajorFrequency(2);
        graduatedScaleLinear.setTickLengthLeft(0.0f);
        return graduatedScaleLinear;
    }

    public void layoutChildren(JGoObject jGoObject) {
        if (this.isInitializing()) {
            return;
        }
        if (jGoObject == this.getScale() && this.getScale() != null) {
            return;
        }
        super.layoutChildren(jGoObject);
        Rectangle rectangle = new Rectangle(this.getBoundingRect());
        rectangle.grow(-rectangle.width / 10, -rectangle.height / 10);
        GraduatedScaleLinear graduatedScaleLinear = null;
        if (this.getScale() instanceof GraduatedScaleLinear) {
            graduatedScaleLinear = (GraduatedScaleLinear)this.getScale();
        }
        if (graduatedScaleLinear != null) {
            graduatedScaleLinear.setBoundingRect(rectangle);
            graduatedScaleLinear.setStartPoint(new Point(rectangle.x, rectangle.y + rectangle.height));
            graduatedScaleLinear.setEndPoint(new Point(rectangle.x, rectangle.y));
            graduatedScaleLinear.setTickLengthRight(rectangle.width);
        }
        float f = (float)rectangle.width / (float)(this.getIndicatorCount() + 1);
        for (int i = 0; i < this.getIndicatorCount(); ++i) {
            IndicatorBar indicatorBar = null;
            if (this.getIndicator(i) instanceof IndicatorBar) {
                indicatorBar = (IndicatorBar)this.getIndicator(i);
            }
            if (indicatorBar == null) continue;
            indicatorBar.setBoundingRect(rectangle);
            indicatorBar.setStartOffset(new Dimension((int)(f * (float)(i + 1)), 0));
            indicatorBar.setThickness(f / 2.0f);
        }
    }
}

