/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.instrumentdemo;

import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.instruments.AbstractGraduatedScale;
import com.nwoods.jgo.instruments.AbstractIndicator;
import com.nwoods.jgo.instruments.GraduatedScaleLinear;
import com.nwoods.jgo.instruments.IndicatorBar;
import com.nwoods.jgo.instruments.Meter;
import com.nwoods.jgo.instruments.Phase;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;

public class MultiPhaseMeter
extends Meter {
    protected AbstractGraduatedScale createScale() {
        GraduatedScaleLinear graduatedScaleLinear = new GraduatedScaleLinear();
        graduatedScaleLinear.setTickUnit(2.0);
        graduatedScaleLinear.setTickMajorFrequency(10);
        return graduatedScaleLinear;
    }

    protected AbstractIndicator createIndicator() {
        IndicatorBar indicatorBar = new IndicatorBar();
        indicatorBar.setActionEnabled(true);
        indicatorBar.setThickness(6.0f);
        indicatorBar.addPhase(new Phase(10.0, 40.0, Color.green));
        indicatorBar.addPhase(new Phase(55.0, 70.0, Color.yellow));
        indicatorBar.addPhase(new Phase(80.0, 95.0, Color.blue));
        return indicatorBar;
    }

    public void layoutChildren(JGoObject jGoObject) {
        if (this.isInitializing()) {
            return;
        }
        super.layoutChildren(jGoObject);
        GraduatedScaleLinear graduatedScaleLinear = null;
        if (this.getScale() instanceof GraduatedScaleLinear) {
            graduatedScaleLinear = (GraduatedScaleLinear)this.getScale();
        }
        if (graduatedScaleLinear != null) {
            Rectangle rectangle = new Rectangle(graduatedScaleLinear.getBoundingRect());
            graduatedScaleLinear.setStartPoint(new Point(rectangle.x + rectangle.width / 10, rectangle.y + rectangle.height / 4));
            graduatedScaleLinear.setEndPoint(new Point(rectangle.x + 9 * rectangle.width / 10, rectangle.y + 3 * rectangle.height / 4));
        }
    }
}

