/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.instrumentdemo;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.instruments.AbstractGraduatedScale;
import com.nwoods.jgo.instruments.AbstractIndicator;
import com.nwoods.jgo.instruments.GraduatedScaleLinear;
import com.nwoods.jgo.instruments.IndicatorNeedle;
import com.nwoods.jgo.instruments.Meter;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;

public class NeedleMeter
extends Meter {
    protected AbstractGraduatedScale createScale() {
        GraduatedScaleLinear graduatedScaleLinear = new GraduatedScaleLinear();
        graduatedScaleLinear.setTickUnit(2.0);
        graduatedScaleLinear.setTickMajorFrequency(10);
        return graduatedScaleLinear;
    }

    protected AbstractIndicator createIndicator() {
        IndicatorNeedle indicatorNeedle = new IndicatorNeedle();
        indicatorNeedle.setActionEnabled(true);
        indicatorNeedle.setConstantLength(true);
        indicatorNeedle.setPen(JGoPen.red);
        return indicatorNeedle;
    }

    public void layoutChildren(JGoObject jGoObject) {
        Serializable serializable;
        if (this.isInitializing()) {
            return;
        }
        super.layoutChildren(jGoObject);
        GraduatedScaleLinear graduatedScaleLinear = null;
        if (this.getScale() instanceof GraduatedScaleLinear) {
            graduatedScaleLinear = (GraduatedScaleLinear)this.getScale();
        }
        if (graduatedScaleLinear != null) {
            serializable = new Rectangle(graduatedScaleLinear.getBoundingRect());
            if (this.getOrientation() == 0) {
                if (((Rectangle)serializable).width < 40) {
                    graduatedScaleLinear.setStartPoint(new Point(((Rectangle)serializable).x + ((Rectangle)serializable).width / 10, ((Rectangle)serializable).y + ((Rectangle)serializable).height / 3));
                    graduatedScaleLinear.setEndPoint(new Point(((Rectangle)serializable).x + 9 * ((Rectangle)serializable).width / 10, ((Rectangle)serializable).y + ((Rectangle)serializable).height / 3));
                } else {
                    graduatedScaleLinear.setStartPoint(new Point(((Rectangle)serializable).x + 10, ((Rectangle)serializable).y + ((Rectangle)serializable).height / 3));
                    graduatedScaleLinear.setEndPoint(new Point(((Rectangle)serializable).x + ((Rectangle)serializable).width - 10, ((Rectangle)serializable).y + ((Rectangle)serializable).height / 3));
                }
            } else if (((Rectangle)serializable).height < 40) {
                graduatedScaleLinear.setStartPoint(new Point(((Rectangle)serializable).x + 2 * ((Rectangle)serializable).width / 3, ((Rectangle)serializable).y + ((Rectangle)serializable).height / 10));
                graduatedScaleLinear.setEndPoint(new Point(((Rectangle)serializable).x + 2 * ((Rectangle)serializable).width / 3, ((Rectangle)serializable).y + 9 * ((Rectangle)serializable).height / 10));
            } else {
                graduatedScaleLinear.setStartPoint(new Point(((Rectangle)serializable).x + 2 * ((Rectangle)serializable).width / 3, ((Rectangle)serializable).y + ((Rectangle)serializable).height - 10));
                graduatedScaleLinear.setEndPoint(new Point(((Rectangle)serializable).x + 2 * ((Rectangle)serializable).width / 3, ((Rectangle)serializable).y + 10));
            }
        }
        serializable = null;
        if (this.getIndicator() instanceof IndicatorNeedle) {
            serializable = (IndicatorNeedle)this.getIndicator();
        }
        if (serializable != null) {
            Rectangle rectangle = new Rectangle(((JGoObject)serializable).getBoundingRect());
            if (this.getOrientation() == 0) {
                ((IndicatorNeedle)serializable).setLength(rectangle.height);
                ((IndicatorNeedle)serializable).setPivotPoint(new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height));
            } else {
                ((IndicatorNeedle)serializable).setLength(rectangle.width);
                ((IndicatorNeedle)serializable).setPivotPoint(new Point(rectangle.x, rectangle.y + rectangle.height / 2));
            }
        }
    }

    public void SVGWriteObject(DomDoc domDoc, DomElement domElement) {
        if (domDoc.JGoXMLOutputEnabled()) {
            DomElement domElement2 = domDoc.createJGoClassElement("com.nwoods.jgo.examples.instrumentdemo.NeedleMeter", domElement);
        }
        super.SVGWriteObject(domDoc, domElement);
    }

    public DomNode SVGReadObject(DomDoc domDoc, JGoDocument jGoDocument, DomElement domElement, DomElement domElement2) {
        if (domElement2 != null) {
            super.SVGReadObject(domDoc, jGoDocument, domElement, domElement2.getNextSiblingJGoClassElement());
        }
        return domElement.getNextSibling();
    }

    public boolean isConstantLength() {
        return ((IndicatorNeedle)this.getIndicator()).isConstantLength();
    }

    public void setConstantLength(boolean bl) {
        ((IndicatorNeedle)this.getIndicator()).setConstantLength(bl);
    }

    public float getLength() {
        return ((IndicatorNeedle)this.getIndicator()).getLength();
    }

    public void setLength(float f) {
        ((IndicatorNeedle)this.getIndicator()).setLength(f);
    }

    public float getThickness() {
        return ((IndicatorNeedle)this.getIndicator()).getThickness();
    }

    public void setThickness(float f) {
        ((IndicatorNeedle)this.getIndicator()).setThickness(f);
    }

    public int getStyle() {
        return ((IndicatorNeedle)this.getIndicator()).getStyle();
    }

    public void setStyle(int n) {
        ((IndicatorNeedle)this.getIndicator()).setStyle(n);
    }
}

