/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.instrumentdemo;

import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoEllipse;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.instruments.AbstractGraduatedScale;
import com.nwoods.jgo.instruments.AbstractIndicator;
import com.nwoods.jgo.instruments.GraduatedScaleElliptical;
import com.nwoods.jgo.instruments.IndicatorNeedle;
import com.nwoods.jgo.instruments.Meter;
import java.awt.Color;
import java.awt.Point;

public class NeedleMeterElliptical
extends Meter {
    public void initialize() {
        super.initialize();
        this.setLabelRelativeSpot(2);
    }

    protected JGoObject createBackground() {
        JGoEllipse jGoEllipse = new JGoEllipse();
        jGoEllipse.setSelectable(false);
        jGoEllipse.setPen(JGoPen.make(65535, 3, Color.gray));
        jGoEllipse.setBrush(JGoBrush.make(65535, new Color(0, 0, 127)));
        return jGoEllipse;
    }

    protected AbstractGraduatedScale createScale() {
        GraduatedScaleElliptical graduatedScaleElliptical = new GraduatedScaleElliptical();
        graduatedScaleElliptical.setPen(JGoPen.make(65535, 2, Color.gray));
        graduatedScaleElliptical.setTickColor(Color.orange);
        graduatedScaleElliptical.setTickWidth(2);
        graduatedScaleElliptical.setTickMajorWidth(3);
        graduatedScaleElliptical.getLabelTemplate().setTextColor(Color.orange);
        graduatedScaleElliptical.getLabelTemplate().setBold(true);
        graduatedScaleElliptical.setStartAngle(110.0);
        graduatedScaleElliptical.setSweepAngle(320.0);
        graduatedScaleElliptical.setMaximum(100.0);
        graduatedScaleElliptical.setMinimum(0.0);
        graduatedScaleElliptical.setTickUnit(5.0);
        graduatedScaleElliptical.setTickMajorFrequency(4);
        graduatedScaleElliptical.setTickLengthLeft(0.0f);
        graduatedScaleElliptical.setLabelStyle(1);
        return graduatedScaleElliptical;
    }

    protected AbstractIndicator createIndicator() {
        IndicatorNeedle indicatorNeedle = new IndicatorNeedle();
        indicatorNeedle.setActionEnabled(true);
        indicatorNeedle.setConstantLength(true);
        indicatorNeedle.setStyle(1);
        indicatorNeedle.setBrush(JGoBrush.orange);
        indicatorNeedle.setThickness(12.0f);
        indicatorNeedle.setQuantized(false);
        indicatorNeedle.setQuantizeUnit(5.0);
        return indicatorNeedle;
    }

    public void layoutChildren(JGoObject jGoObject) {
        if (this.isInitializing()) {
            return;
        }
        super.layoutChildren(jGoObject);
        IndicatorNeedle indicatorNeedle = null;
        if (this.getIndicator() instanceof IndicatorNeedle) {
            indicatorNeedle = (IndicatorNeedle)this.getIndicator();
        }
        if (indicatorNeedle != null && this.getScale() != null) {
            AbstractGraduatedScale abstractGraduatedScale = this.getScale();
            Point point = new Point(abstractGraduatedScale.getLeft() + abstractGraduatedScale.getWidth() / 2, abstractGraduatedScale.getTop() + abstractGraduatedScale.getHeight() / 2);
            indicatorNeedle.setPivotPoint(point);
            if (this.isConstantLength()) {
                indicatorNeedle.setLength(Math.min(abstractGraduatedScale.getWidth() / 2, abstractGraduatedScale.getHeight() / 2));
            }
        }
    }

    public boolean isConstantLength() {
        return ((IndicatorNeedle)this.getIndicator()).isConstantLength();
    }

    public void setConstantLength(boolean bl) {
        ((IndicatorNeedle)this.getIndicator()).setConstantLength(bl);
    }

    public float getLength() {
        return ((IndicatorNeedle)this.getIndicator()).getLength();
    }

    public void setLength(float f) {
        ((IndicatorNeedle)this.getIndicator()).setLength(f);
    }

    public float getThickness() {
        return ((IndicatorNeedle)this.getIndicator()).getThickness();
    }

    public void setThickness(float f) {
        ((IndicatorNeedle)this.getIndicator()).setThickness(f);
    }

    public int getStyle() {
        return ((IndicatorNeedle)this.getIndicator()).getStyle();
    }

    public void setStyle(int n) {
        ((IndicatorNeedle)this.getIndicator()).setStyle(n);
    }
}

