/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.instrumentdemo;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.examples.instrumentdemo.OverrunIndicator;
import com.nwoods.jgo.instruments.AbstractGraduatedScale;
import com.nwoods.jgo.instruments.AbstractIndicator;
import com.nwoods.jgo.instruments.GraduatedScaleElliptical;
import com.nwoods.jgo.instruments.IndicatorNeedle;
import com.nwoods.jgo.instruments.Meter;
import com.nwoods.jgo.instruments.Phase;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Point;

public class OverrunMeter
extends Meter {
    public void initialize() {
        super.initialize();
        int n = 30;
        if (this.getLabel() != null) {
            n += this.getLabel().getHeight();
        }
        this.setInsets(new Insets(30, 30, n, 30));
    }

    protected AbstractGraduatedScale createScale() {
        GraduatedScaleElliptical graduatedScaleElliptical = new GraduatedScaleElliptical();
        graduatedScaleElliptical.setStartAngle(180.0);
        graduatedScaleElliptical.setSweepAngle(360.0);
        graduatedScaleElliptical.setTickUnit(5.0);
        graduatedScaleElliptical.setTickMajorFrequency(2);
        graduatedScaleElliptical.setLabelStyle(0);
        return graduatedScaleElliptical;
    }

    protected AbstractIndicator createIndicator() {
        OverrunIndicator overrunIndicator = new OverrunIndicator();
        overrunIndicator.setActionEnabled(true);
        overrunIndicator.addPhase(new Phase(0.0, 100.0, Color.green));
        overrunIndicator.addPhase(new Phase(100.0, 200.0, Color.blue));
        overrunIndicator.addPhase(new Phase(200.0, 300.0, Color.red));
        return overrunIndicator;
    }

    public void layoutChildren(JGoObject jGoObject) {
        if (this.isInitializing()) {
            return;
        }
        super.layoutChildren(jGoObject);
        if (this.getScale() != null) {
            IndicatorNeedle indicatorNeedle = null;
            if (this.getIndicator() instanceof IndicatorNeedle) {
                indicatorNeedle = (IndicatorNeedle)this.getIndicator();
            }
            if (indicatorNeedle != null) {
                AbstractGraduatedScale abstractGraduatedScale = this.getScale();
                indicatorNeedle.setPivotPoint(new Point(abstractGraduatedScale.getLeft() + abstractGraduatedScale.getWidth() / 2, abstractGraduatedScale.getTop() + abstractGraduatedScale.getHeight() / 2));
                if (((IndicatorNeedle)this.getIndicator()).isConstantLength()) {
                    indicatorNeedle.setLength(Math.min(abstractGraduatedScale.getWidth() / 2, abstractGraduatedScale.getHeight() / 2));
                }
            }
        }
    }

    public void SVGWriteObject(DomDoc domDoc, DomElement domElement) {
        if (domDoc.JGoXMLOutputEnabled()) {
            DomElement domElement2 = domDoc.createJGoClassElement("com.nwoods.jgo.examples.instrumentdemo.OverrunMeter", domElement);
        }
        super.SVGWriteObject(domDoc, domElement);
    }

    public DomNode SVGReadObject(DomDoc domDoc, JGoDocument jGoDocument, DomElement domElement, DomElement domElement2) {
        if (domElement2 != null) {
            super.SVGReadObject(domDoc, jGoDocument, domElement, domElement2.getNextSiblingJGoClassElement());
        }
        return domElement.getNextSibling();
    }
}

