/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.instrumentdemo;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoLabeledLink;
import com.nwoods.jgo.JGoLinkLabel;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoText;
import com.nwoods.jgo.examples.instrumentdemo.Tank;
import java.awt.Color;
import java.text.NumberFormat;
import java.text.ParseException;

public class Pipe
extends JGoLabeledLink {
    public static final int ChangedRate = 12450;
    private NumberFormat myFormatter = NumberFormat.getNumberInstance();
    private double myRate = 1.0;

    public Pipe() {
        this.setOrthogonal(true);
        this.setRoundedCorners(true);
        this.setPen(JGoPen.make(65535, 4, Color.gray));
        this.setHighlight(JGoPen.make(65535, 6, Color.black));
        JGoLinkLabel jGoLinkLabel = new JGoLinkLabel();
        jGoLinkLabel.setSelectable(false);
        jGoLinkLabel.setBkColor(Color.white);
        jGoLinkLabel.setTransparent(false);
        jGoLinkLabel.setEditable(true);
        jGoLinkLabel.setEditOnSingleClick(true);
        jGoLinkLabel.setText(Double.toString(this.getRate()));
        jGoLinkLabel.setAlignment(2);
        this.setMidLabel(jGoLinkLabel);
        jGoLinkLabel.setUpdatePartner(true);
    }

    public JGoObject copyObject(JGoCopyEnvironment jGoCopyEnvironment) {
        Pipe pipe = (Pipe)super.copyObject(jGoCopyEnvironment);
        pipe.myRate = this.myRate;
        return pipe;
    }

    public double getRate() {
        return this.myRate;
    }

    public void setRate(double d) {
        double d2 = this.myRate;
        if (d2 != d) {
            this.myRate = d;
            this.update(12450, 0, new Double(d2));
            JGoText jGoText = null;
            if (this.getMidLabel() instanceof JGoText) {
                jGoText = (JGoText)this.getMidLabel();
            }
            if (jGoText != null) {
                jGoText.setText(Double.toString(d));
            }
        }
    }

    protected void partnerUpdate(JGoObject jGoObject, int n, int n2, Object object) {
        if (n == 501 && jGoObject instanceof JGoText && jGoObject == this.getMidLabel()) {
            JGoText jGoText = (JGoText)jGoObject;
            String string = jGoText.getText();
            try {
                double d = this.myFormatter.parse(string).doubleValue();
                this.setRate(d);
            }
            catch (ParseException parseException) {
                jGoText.setText((String)object);
            }
        }
    }

    public double MaxFlow() {
        Tank tank = null;
        if (this.getFromPort() != null && this.getFromPort().getParentNode() instanceof Tank) {
            tank = (Tank)this.getFromPort().getParentNode();
        }
        Tank tank2 = null;
        if (this.getToPort() != null && this.getToPort().getParentNode() instanceof Tank) {
            tank2 = (Tank)this.getToPort().getParentNode();
        }
        if (tank != null && tank2 != null) {
            return Math.min(this.getRate(), Math.min(tank.getValue() - tank.getMinimum(), tank2.getMaximum() - tank2.getValue()));
        }
        return 0.0;
    }

    public void Flow(double d) {
        Tank tank = null;
        if (this.getFromPort() != null && this.getFromPort().getParentNode() instanceof Tank) {
            tank = (Tank)this.getFromPort().getParentNode();
        }
        Tank tank2 = null;
        if (this.getToPort() != null && this.getToPort().getParentNode() instanceof Tank) {
            tank2 = (Tank)this.getToPort().getParentNode();
        }
        if (tank != null && tank2 != null) {
            tank.setValue(tank.getValue() - d);
            tank2.setValue(tank2.getValue() + d);
        }
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit jGoDocumentChangedEdit) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 12450: {
                jGoDocumentChangedEdit.setNewValue(new Double(this.getRate()));
                return;
            }
        }
        super.copyNewValueForRedo(jGoDocumentChangedEdit);
    }

    public void changeValue(JGoDocumentChangedEdit jGoDocumentChangedEdit, boolean bl) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 12450: {
                this.setRate(jGoDocumentChangedEdit.getValueDouble(bl));
                return;
            }
        }
        super.changeValue(jGoDocumentChangedEdit, bl);
    }

    public void SVGWriteObject(DomDoc domDoc, DomElement domElement) {
        if (domDoc.JGoXMLOutputEnabled()) {
            DomElement domElement2 = domDoc.createJGoClassElement("com.nwoods.jgo.examples.instrumentdemo.Pipe", domElement);
        }
        super.SVGWriteObject(domDoc, domElement);
    }

    public DomNode SVGReadObject(DomDoc domDoc, JGoDocument jGoDocument, DomElement domElement, DomElement domElement2) {
        if (domElement2 != null) {
            super.SVGReadObject(domDoc, jGoDocument, domElement, domElement2.getNextSiblingJGoClassElement());
        }
        return domElement.getNextSibling();
    }
}

