/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.instrumentdemo;

import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoView;
import com.nwoods.jgo.instruments.GraduatedScaleLinear;
import java.awt.Point;
import java.awt.Rectangle;

public class Ruler
extends GraduatedScaleLinear {
    public static final int ChangedMetric = 15101;
    private transient double myDpiX = 96.0;
    private boolean myMetric = true;

    public Ruler() {
        this.setSelectable(true);
        this.setMinimum(0.0);
        this.setTickBase(0.0);
        this.setTickUnit(0.1);
        this.setTickMajorFrequency(10);
        this.setTickMajorWidth(0);
        this.setTickLengthLeft(8.0f);
        this.setTickLengthRight(0.0f);
        this.setLabelFormat("{0,number}");
    }

    public JGoObject copyObject(JGoCopyEnvironment jGoCopyEnvironment) {
        Ruler ruler = (Ruler)super.copyObject(jGoCopyEnvironment);
        ruler.myMetric = this.myMetric;
        return ruler;
    }

    protected Rectangle computeBoundingRect() {
        Rectangle rectangle = super.computeBoundingRect();
        this.UpdateMaximum();
        return rectangle;
    }

    private void UpdateMaximum() {
        double d = this.getLength();
        if (this.isMetric()) {
            this.setMaximum(d / (this.myDpiX / 2.54));
        } else {
            this.setMaximum(d / this.myDpiX);
        }
    }

    public boolean isMetric() {
        return this.myMetric;
    }

    public void setMetric(boolean bl) {
        boolean bl2 = this.myMetric;
        if (bl2 != bl) {
            this.myMetric = bl;
            this.update(15101, bl2 ? 1 : 0, null);
            if (bl) {
                this.setTickUnit(0.1);
                this.setTickMajorFrequency(10);
                this.UpdateMaximum();
            } else {
                this.setTickUnit(0.125);
                this.setTickMajorFrequency(8);
                this.UpdateMaximum();
            }
        }
    }

    public boolean doMouseDblClick(int n, Point point, Point point2, JGoView jGoView) {
        this.setMetric(!this.isMetric());
        return true;
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit jGoDocumentChangedEdit) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 15101: {
                jGoDocumentChangedEdit.setNewValueInt(this.isMetric() ? 1 : 0);
                return;
            }
        }
        super.copyNewValueForRedo(jGoDocumentChangedEdit);
    }

    public void changeValue(JGoDocumentChangedEdit jGoDocumentChangedEdit, boolean bl) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 15101: {
                this.setMetric(jGoDocumentChangedEdit.getValueInt(bl) == 1);
                return;
            }
        }
        super.changeValue(jGoDocumentChangedEdit, bl);
    }
}

