/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.instrumentdemo;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.instruments.AbstractGraduatedScale;
import com.nwoods.jgo.instruments.AbstractIndicator;
import com.nwoods.jgo.instruments.GraduatedScaleLinear;
import com.nwoods.jgo.instruments.IndicatorSlider;
import com.nwoods.jgo.instruments.Meter;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;

public class SliderMeter
extends Meter {
    public void initialize() {
        super.initialize();
        this.setOrientation(1);
    }

    protected AbstractGraduatedScale createScale() {
        GraduatedScaleLinear graduatedScaleLinear = new GraduatedScaleLinear();
        graduatedScaleLinear.setTickUnit(2.0);
        graduatedScaleLinear.setTickMajorFrequency(10);
        return graduatedScaleLinear;
    }

    protected AbstractIndicator createIndicator() {
        IndicatorSlider indicatorSlider = new IndicatorSlider();
        indicatorSlider.setActionEnabled(true);
        indicatorSlider.setDimensions(new Dimension(30, 10));
        indicatorSlider.setStyle(1);
        indicatorSlider.setPen(JGoPen.blue);
        indicatorSlider.setBrush(JGoBrush.white);
        return indicatorSlider;
    }

    public void layoutChildren(JGoObject jGoObject) {
        if (this.isInitializing()) {
            return;
        }
        super.layoutChildren(jGoObject);
        GraduatedScaleLinear graduatedScaleLinear = null;
        if (this.getScale() instanceof GraduatedScaleLinear) {
            graduatedScaleLinear = (GraduatedScaleLinear)this.getScale();
        }
        if (graduatedScaleLinear != null) {
            Rectangle rectangle = new Rectangle(graduatedScaleLinear.getBoundingRect());
            if (this.getOrientation() == 0) {
                if (rectangle.width < 40) {
                    graduatedScaleLinear.setStartPoint(new Point(rectangle.x + rectangle.width / 10, rectangle.y + rectangle.height / 2));
                    graduatedScaleLinear.setEndPoint(new Point(rectangle.x + 9 * rectangle.width / 10, rectangle.y + rectangle.height / 2));
                } else {
                    graduatedScaleLinear.setStartPoint(new Point(rectangle.x + 10, rectangle.y + rectangle.height / 2));
                    graduatedScaleLinear.setEndPoint(new Point(rectangle.x + rectangle.width - 10, rectangle.y + rectangle.height / 2));
                }
            } else if (rectangle.height < 40) {
                graduatedScaleLinear.setStartPoint(new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 10));
                graduatedScaleLinear.setEndPoint(new Point(rectangle.x + rectangle.width / 2, rectangle.y + 9 * rectangle.height / 10));
            } else {
                graduatedScaleLinear.setStartPoint(new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height - 10));
                graduatedScaleLinear.setEndPoint(new Point(rectangle.x + rectangle.width / 2, rectangle.y + 10));
            }
        }
    }

    public void SVGWriteObject(DomDoc domDoc, DomElement domElement) {
        if (domDoc.JGoXMLOutputEnabled()) {
            DomElement domElement2 = domDoc.createJGoClassElement("com.nwoods.jgo.examples.instrumentdemo.SliderMeter", domElement);
        }
        super.SVGWriteObject(domDoc, domElement);
    }

    public DomNode SVGReadObject(DomDoc domDoc, JGoDocument jGoDocument, DomElement domElement, DomElement domElement2) {
        if (domElement2 != null) {
            super.SVGReadObject(domDoc, jGoDocument, domElement, domElement2.getNextSiblingJGoClassElement());
        }
        return domElement.getNextSibling();
    }

    public int getIndicatorStyle() {
        return ((IndicatorSlider)this.getIndicator()).getStyle();
    }

    public void setIndicatorStyle(int n) {
        ((IndicatorSlider)this.getIndicator()).setStyle(n);
    }
}

