/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.instrumentdemo;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.examples.instrumentdemo.JGoSimpleNode;
import com.nwoods.jgo.examples.instrumentdemo.LinearGradientCylinder;
import com.nwoods.jgo.examples.instrumentdemo.Pipe;
import com.nwoods.jgo.instruments.AbstractIndicator;
import com.nwoods.jgo.instruments.GraduatedScaleLinear;
import com.nwoods.jgo.instruments.IndicatorBar;
import com.nwoods.jgo.instruments.Meter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.NumberFormat;
import java.text.ParseException;

public class Tank
extends JGoSimpleNode {
    private NumberFormat myFormatter = NumberFormat.getNumberInstance();

    public void initialize() {
        Meter meter = new Meter();
        meter.setSelectable(false);
        meter.setLabel(null);
        meter.setInsets(new Insets(0, 0, 0, 0));
        LinearGradientCylinder linearGradientCylinder = new LinearGradientCylinder();
        linearGradientCylinder.setSelectable(false);
        linearGradientCylinder.setMinorRadius(4);
        linearGradientCylinder.setSize(new Dimension(40, 80));
        meter.setBackground(linearGradientCylinder);
        GraduatedScaleLinear graduatedScaleLinear = new GraduatedScaleLinear();
        graduatedScaleLinear.setMaximum(1000.0);
        graduatedScaleLinear.setTickMajorFrequency(10);
        graduatedScaleLinear.setTickUnit(100.0);
        graduatedScaleLinear.setTickLabels(false);
        meter.setScale(graduatedScaleLinear);
        IndicatorBar indicatorBar = new IndicatorBar();
        indicatorBar.setActionEnabled(true);
        indicatorBar.setBrush(JGoBrush.blue);
        indicatorBar.setScale(graduatedScaleLinear);
        indicatorBar.setThickness(10.0f);
        indicatorBar.setValue(500.0);
        meter.setIndicator(indicatorBar);
        indicatorBar.setPartner(this);
        indicatorBar.setUpdatePartner(true);
        meter.setSize(30, 100);
        this.initialize(meter, "Tank");
        this.setOrientation(1);
        this.getLabel().setEditable(true);
        this.getLabel().setBkColor(Color.white);
        this.getLabel().setTransparent(false);
        this.getLabel().setUpdatePartner(true);
    }

    public JGoObject copyObject(JGoCopyEnvironment jGoCopyEnvironment) {
        AbstractIndicator abstractIndicator;
        Tank tank = (Tank)super.copyObject(jGoCopyEnvironment);
        Meter meter = tank.getMeter();
        if (meter != null && (abstractIndicator = meter.getIndicator()) != null) {
            abstractIndicator.setPartner(tank);
            abstractIndicator.setUpdatePartner(true);
        }
        return tank;
    }

    protected JGoPort createPort(boolean bl) {
        JGoPort jGoPort = new JGoPort();
        jGoPort.setStyle(4);
        jGoPort.setPen(JGoPen.black);
        jGoPort.setBrush(JGoBrush.gray);
        jGoPort.setAutoRescale(false);
        jGoPort.setSize(6, 6);
        jGoPort.setValidSource(!bl);
        jGoPort.setValidDestination(bl);
        return jGoPort;
    }

    public Meter getMeter() {
        if (this.getIcon() instanceof Meter) {
            return (Meter)this.getIcon();
        }
        return null;
    }

    public void layoutChildren(JGoObject jGoObject) {
        if (this.isInitializing()) {
            return;
        }
        super.layoutChildren(jGoObject);
        if (this.getMeter() == null) {
            return;
        }
        if (this.getMeter().getScale() == null) {
            return;
        }
        if (this.getMeter().getScale() == jGoObject) {
            return;
        }
        GraduatedScaleLinear graduatedScaleLinear = null;
        if (this.getMeter().getScale() instanceof GraduatedScaleLinear) {
            graduatedScaleLinear = (GraduatedScaleLinear)this.getMeter().getScale();
        }
        if (graduatedScaleLinear != null && this.getMeter().getBackground() != null) {
            Rectangle rectangle = new Rectangle(this.getMeter().getBackground().getBoundingRect());
            graduatedScaleLinear.setStartPoint(new Point(rectangle.x + rectangle.width / 2, rectangle.y + 19 * rectangle.height / 20));
            graduatedScaleLinear.setEndPoint(new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 20));
            if (this.getMeter().getIndicator() != null) {
                this.getMeter().getIndicator().setBoundingRect(graduatedScaleLinear.getBoundingRect());
            }
        }
    }

    protected void partnerUpdate(JGoObject jGoObject, int n, int n2, Object object) {
        if (n == 13300 && jGoObject == this.getMeter().getIndicator() && this.getLabel() != null) {
            this.myFormatter.setMaximumFractionDigits(1);
            String string = this.myFormatter.format(this.getValue());
            this.getLabel().setText(string);
        } else if (n == 501 && jGoObject == this.getLabel() && this.getLabel() != null) {
            String string = this.getLabel().getText();
            try {
                this.myFormatter.setMaximumFractionDigits(1);
                double d = this.myFormatter.parse(string).doubleValue();
                this.setValue(d);
            }
            catch (ParseException parseException) {
                this.getLabel().setText((String)object);
            }
        }
    }

    public double getValue() {
        if (this.getMeter() == null) {
            return 0.0;
        }
        if (this.getMeter().getIndicator() != null) {
            return this.getMeter().getIndicator().getValue();
        }
        return 0.0;
    }

    public void setValue(double d) {
        if (this.getMeter().getIndicator() != null) {
            this.getMeter().getIndicator().setValue(d);
        }
    }

    public double getMinimum() {
        if (this.getMeter() == null) {
            return 0.0;
        }
        if (this.getMeter().getScale() != null) {
            return this.getMeter().getScale().getMinimum();
        }
        return 0.0;
    }

    public void setMinimum(double d) {
        if (this.getMeter().getScale() != null) {
            this.getMeter().getScale().setMinimum(d);
        }
    }

    public double getMaximum() {
        if (this.getMeter().getScale() != null) {
            return this.getMeter().getScale().getMaximum();
        }
        return 0.0;
    }

    public void setMaximum(double d) {
        if (this.getMeter().getScale() != null) {
            this.getMeter().getScale().setMaximum(d);
        }
    }

    public void drain() {
        if (this.getValue() <= this.getMinimum()) {
            return;
        }
        double d = 0.0;
        JGoPort jGoPort = this.getOutputPort();
        JGoListPosition jGoListPosition = jGoPort.getFirstLinkPos();
        while (jGoListPosition != null) {
            JGoLink jGoLink = jGoPort.getLinkAtPos(jGoListPosition);
            jGoListPosition = jGoPort.getNextLinkPos(jGoListPosition);
            Pipe pipe = null;
            if (jGoLink instanceof Pipe) {
                pipe = (Pipe)jGoLink;
            }
            if (pipe == null) continue;
            d += pipe.MaxFlow();
        }
        if (d > 0.0) {
            double d2 = Math.min(d, this.getValue() - this.getMinimum());
            jGoListPosition = jGoPort.getFirstLinkPos();
            while (jGoListPosition != null) {
                JGoLink jGoLink = jGoPort.getLinkAtPos(jGoListPosition);
                jGoListPosition = jGoPort.getNextLinkPos(jGoListPosition);
                Pipe pipe = null;
                if (jGoLink instanceof Pipe) {
                    pipe = (Pipe)jGoLink;
                }
                if (pipe == null) continue;
                double d3 = pipe.MaxFlow();
                pipe.Flow(d3);
                d2 -= d3;
            }
        }
    }

    public void SVGWriteObject(DomDoc domDoc, DomElement domElement) {
        if (domDoc.JGoXMLOutputEnabled()) {
            DomElement domElement2 = domDoc.createJGoClassElement("com.nwoods.jgo.examples.instrumentdemo.Tank", domElement);
        }
        super.SVGWriteObject(domDoc, domElement);
    }

    public DomNode SVGReadObject(DomDoc domDoc, JGoDocument jGoDocument, DomElement domElement, DomElement domElement2) {
        if (domElement2 != null) {
            super.SVGReadObject(domDoc, jGoDocument, domElement, domElement2.getNextSiblingJGoClassElement());
        }
        return domElement.getNextSibling();
    }
}

