/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.instrumentdemo;

import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoEllipse;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoRectangle;
import com.nwoods.jgo.JGoText;
import com.nwoods.jgo.instruments.AbstractGraduatedScale;
import com.nwoods.jgo.instruments.AbstractIndicator;
import com.nwoods.jgo.instruments.GraduatedScaleLinear;
import com.nwoods.jgo.instruments.IndicatorBar;
import com.nwoods.jgo.instruments.Meter;
import java.awt.Point;
import java.awt.Rectangle;

public class Thermometer
extends Meter {
    private GraduatedScaleLinear myFScale;
    private JGoText myScaleLabel;
    private JGoEllipse myBulb;

    public void initialize() {
        super.initialize();
        this.myFScale = this.createFahrenheitScale();
        JGoListPosition jGoListPosition = this.findObject(this.getIndicator());
        if (jGoListPosition != null) {
            this.insertObjectBefore(jGoListPosition, this.myFScale);
        } else {
            this.addObjectAtTail(this.myFScale);
        }
        this.myScaleLabel = this.createScaleLabel();
        jGoListPosition = this.findObject(this.getBackground());
        if (jGoListPosition != null) {
            this.insertObjectAfter(jGoListPosition, this.myScaleLabel);
        } else {
            this.addObjectAtTail(this.myScaleLabel);
        }
        JGoEllipse jGoEllipse = new JGoEllipse();
        jGoEllipse.setPen(null);
        jGoEllipse.setBrush(JGoBrush.red);
        this.addObjectAtTail(jGoEllipse);
        this.myBulb = jGoEllipse;
        this.layoutChildren(null);
    }

    protected JGoObject createBackground() {
        JGoRectangle jGoRectangle = new JGoRectangle();
        jGoRectangle.setSelectable(false);
        jGoRectangle.setBrush(JGoBrush.gray);
        return jGoRectangle;
    }

    protected JGoText createScaleLabel() {
        JGoText jGoText = new JGoText();
        jGoText.setSelectable(false);
        jGoText.setTransparent(true);
        jGoText.setBold(true);
        jGoText.setText("F        C");
        return jGoText;
    }

    protected GraduatedScaleLinear createFahrenheitScale() {
        GraduatedScaleLinear graduatedScaleLinear = new GraduatedScaleLinear();
        graduatedScaleLinear.setMinimum(-40.0);
        graduatedScaleLinear.setMaximum(212.0);
        graduatedScaleLinear.setTickLengthRight(0.0f);
        graduatedScaleLinear.setTickLengthLeft(10.0f);
        graduatedScaleLinear.setTickUnit(5.0);
        graduatedScaleLinear.setTickMajorFrequency(4);
        graduatedScaleLinear.setLabelStyle(0);
        return graduatedScaleLinear;
    }

    protected AbstractGraduatedScale createScale() {
        GraduatedScaleLinear graduatedScaleLinear = new GraduatedScaleLinear();
        graduatedScaleLinear.setMinimum(-40.0);
        graduatedScaleLinear.setMaximum(100.0);
        graduatedScaleLinear.setTickLengthRight(10.0f);
        graduatedScaleLinear.setTickLengthLeft(0.0f);
        graduatedScaleLinear.setTickUnit(5.0);
        graduatedScaleLinear.setTickMajorFrequency(4);
        graduatedScaleLinear.setLabelStyle(1);
        return graduatedScaleLinear;
    }

    protected AbstractIndicator createIndicator() {
        IndicatorBar indicatorBar = new IndicatorBar();
        indicatorBar.setActionEnabled(true);
        indicatorBar.setThickness(8.0f);
        indicatorBar.setPen(null);
        return indicatorBar;
    }

    protected void copyChildren(JGoArea jGoArea, JGoCopyEnvironment jGoCopyEnvironment) {
        super.copyChildren(jGoArea, jGoCopyEnvironment);
        Thermometer thermometer = (Thermometer)jGoArea;
        thermometer.myFScale = (GraduatedScaleLinear)jGoCopyEnvironment.get(this.myFScale);
        thermometer.myScaleLabel = (JGoText)jGoCopyEnvironment.get(this.myScaleLabel);
        thermometer.myBulb = (JGoEllipse)jGoCopyEnvironment.get(this.myBulb);
    }

    public JGoObject removeObjectAtPos(JGoListPosition jGoListPosition) {
        JGoObject jGoObject = super.removeObjectAtPos(jGoListPosition);
        if (jGoObject == this.myFScale) {
            this.myFScale = null;
        } else if (jGoObject == this.myScaleLabel) {
            this.myScaleLabel = null;
        } else if (jGoObject == this.myBulb) {
            this.myBulb = null;
        }
        return jGoObject;
    }

    public void layoutChildren(JGoObject jGoObject) {
        if (this.isInitializing()) {
            return;
        }
        super.layoutChildren(jGoObject);
        if (this.getBackground() != null) {
            Rectangle rectangle = new Rectangle(this.getBackground().getBoundingRect());
            int n = 0;
            if (this.getScaleLabel() != null) {
                n = this.getScaleLabel().getHeight();
                this.getScaleLabel().setSpotLocation(2, this.getBackground(), 2);
            }
            int n2 = 0;
            if (this.getLabel() != null) {
                n2 = this.getLabel().getHeight();
                if (this.myBulb != null) {
                    n2 += 12;
                }
            }
            Point point = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height - n2 - 5);
            Point point2 = new Point(rectangle.x + rectangle.width / 2, rectangle.y + n + 5);
            if (this.getCelsiusScale() != null) {
                this.getCelsiusScale().setStartPoint(point);
                this.getCelsiusScale().setEndPoint(point2);
                if (this.myBulb != null) {
                    this.myBulb.setSize(14, 14);
                    this.myBulb.setSpotLocation(2, point.x, point.y - 1);
                }
            }
            if (this.getFahrenheitScale() != null) {
                this.getFahrenheitScale().setStartPoint(point);
                this.getFahrenheitScale().setEndPoint(point2);
            }
        }
    }

    public GraduatedScaleLinear getFahrenheitScale() {
        return this.myFScale;
    }

    public GraduatedScaleLinear getCelsiusScale() {
        return (GraduatedScaleLinear)this.getScale();
    }

    public JGoText getScaleLabel() {
        return this.myScaleLabel;
    }

    public double getCelsius() {
        return this.getIndicator().getValue();
    }

    public void setCelsius(double d) {
        this.getIndicator().setValue(d);
    }

    public double getFahrenheit() {
        return Thermometer.convertCtoF(this.getIndicator().getValue());
    }

    public void setFahrenheit(double d) {
        this.getIndicator().setValue(Thermometer.convertFtoC(d));
    }

    public static double convertFtoC(double d) {
        return (d - 32.0) * 5.0 / 9.0;
    }

    public static double convertCtoF(double d) {
        return d * 9.0 / 5.0 + 32.0;
    }
}

