/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.updatedemo;

import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoLabeledPart;
import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoNode;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoUndoManager;
import com.nwoods.jgo.examples.updatedemo.UpdateDemo;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.undo.UndoableEdit;

public class UndoMgr
extends JGoUndoManager {
    private String myLogPrefix = "";

    public boolean addEdit(UndoableEdit undoableEdit) {
        this.setLogPrefix("");
        this.logChanges(undoableEdit, true);
        return super.addEdit(undoableEdit);
    }

    public void endTransaction(String string) {
        boolean bl = this.getTransactionLevel() == 1;
        super.endTransaction(string);
        if (bl) {
            UpdateDemo.AddLogMessage("  ended: " + string);
        }
    }

    public void undo() {
        if (this.canUndo()) {
            this.setLogPrefix(" UNDO: ");
            this.logChanges(this.editToBeUndone(), false);
        }
        super.undo();
    }

    public void redo() {
        if (this.canRedo()) {
            this.setLogPrefix(" REDO: ");
            this.logChanges(this.editToBeRedone(), true);
        }
        super.redo();
    }

    public String getLogPrefix() {
        return this.myLogPrefix;
    }

    public void setLogPrefix(String string) {
        this.myLogPrefix = string;
    }

    public void logChanges(UndoableEdit undoableEdit, boolean bl) {
        block4: {
            if (!(undoableEdit instanceof JGoUndoManager.JGoCompoundEdit)) break block4;
            JGoUndoManager.JGoCompoundEdit jGoCompoundEdit = (JGoUndoManager.JGoCompoundEdit)undoableEdit;
            Vector vector = jGoCompoundEdit.getAllEdits();
            if (bl) {
                for (int i = 0; i < vector.size(); ++i) {
                    JGoDocumentChangedEdit jGoDocumentChangedEdit = (JGoDocumentChangedEdit)vector.get(i);
                    this.logChange(jGoDocumentChangedEdit);
                }
            } else {
                for (int i = vector.size() - 1; i >= 0; --i) {
                    JGoDocumentChangedEdit jGoDocumentChangedEdit = (JGoDocumentChangedEdit)vector.get(i);
                    this.logChange(jGoDocumentChangedEdit);
                }
            }
        }
    }

    public void logChange(JGoDocumentChangedEdit jGoDocumentChangedEdit) {
        if (jGoDocumentChangedEdit.getHint() == 202) {
            UpdateDemo.AddLogMessage(this.getLogPrefix() + "inserted " + this.ID(jGoDocumentChangedEdit.getObject()));
        } else if (jGoDocumentChangedEdit.getHint() == 204) {
            UpdateDemo.AddLogMessage(this.getLogPrefix() + "removed " + this.ID(jGoDocumentChangedEdit.getObject()));
        } else if (jGoDocumentChangedEdit.getHint() == 203) {
            if (jGoDocumentChangedEdit.getFlags() == 201) {
                UpdateDemo.AddLogMessage(this.getLogPrefix() + "changed link's From port from: " + this.ID(jGoDocumentChangedEdit.getOldValue()) + "  to: " + this.ID(jGoDocumentChangedEdit.getNewValue()));
            } else if (jGoDocumentChangedEdit.getFlags() == 202) {
                UpdateDemo.AddLogMessage(this.getLogPrefix() + "changed link's To port from: " + this.ID(jGoDocumentChangedEdit.getOldValue()) + "  to: " + this.ID(jGoDocumentChangedEdit.getNewValue()));
            } else if (jGoDocumentChangedEdit.getFlags() == 1 && jGoDocumentChangedEdit.getObject() instanceof JGoNode) {
                UpdateDemo.AddLogMessage(this.getLogPrefix() + "changed BoundingRect from: " + this.RECT((Rectangle)jGoDocumentChangedEdit.getOldValue()) + "  to: " + this.RECT(((JGoObject)jGoDocumentChangedEdit.getObject()).getBoundingRect()));
            }
        }
    }

    public String ID(Object object) {
        if (object == null) {
            return "(null)";
        }
        if (object instanceof JGoPort) {
            JGoPort jGoPort = (JGoPort)object;
            if (jGoPort.getParentNode() != jGoPort) {
                return this.ID(jGoPort.getParentNode());
            }
            return jGoPort.toString();
        }
        if (object instanceof JGoLabeledPart) {
            JGoLabeledPart jGoLabeledPart = (JGoLabeledPart)object;
            return jGoLabeledPart.getText();
        }
        if (object instanceof JGoLink) {
            JGoLink jGoLink = (JGoLink)object;
            return "link from " + this.ID(jGoLink.getFromPort().getParentNode()) + " to " + this.ID(jGoLink.getToPort().getParentNode());
        }
        return "";
    }

    public String RECT(Rectangle rectangle) {
        return Integer.toString(rectangle.x) + "," + Integer.toString(rectangle.y) + "," + Integer.toString(rectangle.width) + "," + Integer.toString(rectangle.height);
    }
}

