/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.updatedemo;

import com.nwoods.jgo.JGoBasicNode;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentEvent;
import com.nwoods.jgo.JGoDocumentListener;
import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoRectangle;
import com.nwoods.jgo.JGoView;
import com.nwoods.jgo.JGoViewEvent;
import com.nwoods.jgo.JGoViewListener;
import com.nwoods.jgo.examples.updatedemo.UndoMgr;
import com.nwoods.jgo.examples.updatedemo.UpdateView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;

public class UpdateDemo
extends JApplet
implements Runnable,
JGoViewListener,
JGoDocumentListener {
    public static UpdateDemo App = null;
    private JGoView myView;
    private JTextArea myTextArea;
    private JScrollPane myScrollPane;
    private int myNodeCounter = 0;

    public UpdateDemo() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.myTextArea = new JTextArea(50, 30);
        this.myScrollPane = new JScrollPane(this.myTextArea);
        jPanel.add((Component)this.myScrollPane, "Center");
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton();
        jButton.setText("Clear");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                App.ClearLog();
            }
        });
        jPanel2.add(jButton);
        jPanel.add((Component)jPanel2, "South");
        JSplitPane jSplitPane = new JSplitPane();
        this.myView = new UpdateView();
        jSplitPane.add((Component)this.myView, "left");
        jSplitPane.add((Component)jPanel, "right");
        this.getContentPane().add((Component)jSplitPane, "Center");
    }

    public void start() {
        new Thread(this).start();
    }

    public void run() {
        this.myView.initializeDragDropHandling();
    }

    public static void main(String[] stringArray) {
        try {
            UpdateDemo updateDemo;
            JFrame jFrame = new JFrame();
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            jFrame.setTitle("UpdateDemo -- Double-click in background to add new nodes; ^Z undo; ^Y redo");
            jFrame.setSize(800, 400);
            App = updateDemo = new UpdateDemo();
            Container container = jFrame.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)updateDemo, "Center");
            container.validate();
            jFrame.setVisible(true);
            updateDemo.init();
            updateDemo.start();
        }
        catch (Throwable throwable) {
            System.err.println(throwable);
            throwable.printStackTrace();
            System.exit(1);
        }
    }

    public static void AddLogMessage(String string) {
        UpdateDemo.App.myTextArea.append("\n" + string);
    }

    public static void ClearLog() {
        UpdateDemo.App.myTextArea.setText("");
    }

    public void init() {
        this.myView.setBackground(JGoBrush.ColorBlack);
        this.myView.setPrimarySelectionColor(JGoBrush.ColorMagenta);
        this.myView.setSecondarySelectionColor(this.myView.getPrimarySelectionColor());
        this.myView.setIncludingNegativeCoords(true);
        this.myView.setHidingDisabledScrollbars(true);
        this.myView.setDragsRealtime(false);
        this.myView.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                UpdateDemo.this.handleKeyPressed(keyEvent);
            }
        });
        this.myView.addViewListener(this);
        JGoDocument jGoDocument = this.myView.getDocument();
        jGoDocument.addDocumentListener(this);
        JGoBasicNode jGoBasicNode = this.insertNode(new Point(50, 50), true);
        jGoBasicNode.setText("first");
        JGoBasicNode jGoBasicNode2 = this.insertNode(new Point(130, 50), false);
        jGoBasicNode2.setText("second");
        jGoDocument.addObjectAtTail(new JGoLink(jGoBasicNode.getPort(), jGoBasicNode2.getPort()));
        jGoDocument.setUndoManager(new UndoMgr());
    }

    void handleKeyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 127) {
            this.myView.deleteSelection();
        } else if (n == 155) {
            Rectangle rectangle = this.myView.getViewRect();
            this.insertNode(new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2), this.myNodeCounter % 2 == 0);
        } else if (n == 36) {
            Rectangle rectangle = this.myView.getDocument().computeBounds();
            this.myView.setViewPosition(rectangle.x, rectangle.y);
        } else if (n == 35) {
            Rectangle rectangle = this.myView.getDocument().computeBounds();
            Dimension dimension = this.myView.getExtentSize();
            this.myView.setViewPosition(Math.max(rectangle.x, rectangle.x + rectangle.width - dimension.width), Math.max(rectangle.y, rectangle.y + rectangle.height - dimension.height));
        } else if (keyEvent.isControlDown() && n == 65) {
            this.myView.selectAll();
        } else if (keyEvent.isControlDown() && n == 88) {
            this.myView.cut();
        } else if (keyEvent.isControlDown() && n == 67) {
            this.myView.copy();
        } else if (keyEvent.isControlDown() && n == 86) {
            this.myView.paste();
        } else if (keyEvent.isControlDown() && n == 90) {
            this.myView.getDocument().undo();
        } else if (keyEvent.isControlDown() && n == 89) {
            this.myView.getDocument().redo();
        }
    }

    public void viewChanged(JGoViewEvent jGoViewEvent) {
        if (jGoViewEvent.getHint() == 2) {
            if (jGoViewEvent.getJGoObject() instanceof JGoLink) {
                JGoLink jGoLink = (JGoLink)jGoViewEvent.getJGoObject();
                jGoLink.setPen(JGoPen.make(65535, 2, JGoBrush.ColorGray));
                jGoLink.setBrush(JGoBrush.gray);
                jGoLink.setArrowHeads(false, true);
            }
        } else if (jGoViewEvent.getHint() == 25) {
            this.insertNode(jGoViewEvent.getPointDocCoords(), this.myNodeCounter % 2 == 0);
        }
    }

    public void documentChanged(JGoDocumentEvent jGoDocumentEvent) {
        if (jGoDocumentEvent.getHint() == 202 && jGoDocumentEvent.getJGoObject() instanceof JGoLink) {
            JGoLink jGoLink = (JGoLink)jGoDocumentEvent.getJGoObject();
            jGoLink.setBrush(JGoBrush.makeStockBrush(this.getRandomColor(100)));
            jGoLink.setPen(JGoPen.make(65535, 2, jGoLink.getBrush().getColor()));
            jGoLink.setArrowHeads(false, true);
            jGoLink.setCubic(true);
            jGoLink.calculateStroke();
        }
    }

    JGoBasicNode insertNode(Point point, boolean bl) {
        JGoDocument jGoDocument = this.myView.getDocument();
        jGoDocument.startTransaction();
        JGoBasicNode jGoBasicNode = new JGoBasicNode(Integer.toString(++this.myNodeCounter));
        jGoBasicNode.setLabelSpot(0);
        jGoBasicNode.setLocation(point);
        if (bl) {
            jGoBasicNode.setDrawable(new JGoRectangle());
        }
        jGoBasicNode.setBrush(JGoBrush.makeStockBrush(this.getRandomColor(100)));
        jGoBasicNode.setPen(JGoPen.make(65535, 2, this.getRandomColor(130)));
        jGoBasicNode.getLabel().setEditable(true);
        jGoDocument.addObjectAtTail(jGoBasicNode);
        jGoDocument.endTransaction("inserted node");
        return jGoBasicNode;
    }

    Color getRandomColor(int n) {
        return new Color(n + (int)((double)(250 - n) * Math.random()), n + (int)((double)(250 - n) * Math.random()), n + (int)((double)(250 - n) * Math.random()));
    }
}

