/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.examples.MultiPortNode;
import java.awt.Dimension;
import java.awt.Point;

public class MultiPortNodePort
extends JGoPort {
    public static JGoBrush EMPTY = JGoBrush.Null;
    public static JGoBrush OK = JGoBrush.green;
    public static JGoBrush FULL = JGoBrush.red;
    public static final int ChangedMaxLinks = 75645;
    private int myMaxLinks = 3;

    public MultiPortNodePort() {
    }

    public MultiPortNodePort(boolean bl, boolean bl2, int n, Point point, Dimension dimension, JGoObject jGoObject, JGoArea jGoArea) {
        super(new Point(jGoObject.getLeft() + point.x, jGoObject.getTop() + point.y), dimension);
        this.initialize(bl, bl2, n, point, jGoObject, jGoArea);
    }

    public void initialize(boolean bl, boolean bl2, int n, Point point, JGoObject jGoObject, JGoArea jGoArea) {
        this.setDraggable(false);
        this.setStyle(2);
        this.setPen(JGoPen.darkGray);
        this.setBrush(null);
        this.setValidDestination(bl);
        this.setValidSource(bl2);
        this.setFromSpot(n);
        this.setToSpot(n);
        this.setTopLeft(jGoObject.getLeft() + point.x, jGoObject.getTop() + point.y);
        jGoArea.addObjectAtTail(this);
    }

    public JGoObject copyObject(JGoCopyEnvironment jGoCopyEnvironment) {
        MultiPortNodePort multiPortNodePort = (MultiPortNodePort)super.copyObject(jGoCopyEnvironment);
        if (multiPortNodePort != null) {
            multiPortNodePort.myMaxLinks = this.myMaxLinks;
        }
        return multiPortNodePort;
    }

    public MultiPortNode getNode() {
        return (MultiPortNode)this.getParent();
    }

    public int getMaxLinks() {
        return this.myMaxLinks;
    }

    public void setMaxLinks(int n) {
        int n2 = this.myMaxLinks;
        if (n2 != n && n >= 0) {
            this.myMaxLinks = n;
            this.update(75645, n2, null);
        }
    }

    public int getNumValidLinks() {
        int n = 0;
        JGoListPosition jGoListPosition = this.getFirstLinkPos();
        while (jGoListPosition != null) {
            JGoLink jGoLink = this.getLinkAtPos(jGoListPosition);
            jGoListPosition = this.getNextLinkPos(jGoListPosition);
            if (!jGoLink.isVisible() || jGoLink.getDocument() == null || jGoLink.getFromPort().getDocument() == null || jGoLink.getToPort().getDocument() == null) continue;
            ++n;
        }
        return n;
    }

    public boolean isValidSource() {
        return this.getMaxLinks() > 0 && this.getNumValidLinks() < this.getMaxLinks() && super.isValidSource();
    }

    public boolean isValidDestination() {
        return this.getMaxLinks() > 0 && this.getNumValidLinks() < this.getMaxLinks() && super.isValidDestination();
    }

    public boolean validLink(JGoPort jGoPort) {
        return super.validLink(jGoPort) && this.getNumValidLinks() < this.getMaxLinks() && (!(jGoPort instanceof MultiPortNodePort) || ((MultiPortNodePort)jGoPort).getNumValidLinks() < ((MultiPortNodePort)jGoPort).getMaxLinks());
    }

    public void linkChange() {
        int n = this.getNumLinks();
        if (n <= 0) {
            this.setBrush(EMPTY);
        } else if (n < this.getMaxLinks()) {
            this.setBrush(OK);
        } else {
            this.setBrush(FULL);
        }
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit jGoDocumentChangedEdit) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 75645: {
                jGoDocumentChangedEdit.setNewValueInt(this.getMaxLinks());
                return;
            }
        }
        super.copyNewValueForRedo(jGoDocumentChangedEdit);
    }

    public void changeValue(JGoDocumentChangedEdit jGoDocumentChangedEdit, boolean bl) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 75645: {
                this.setMaxLinks(jGoDocumentChangedEdit.getValueInt(bl));
                return;
            }
        }
        super.changeValue(jGoDocumentChangedEdit, bl);
    }

    public void SVGWriteObject(DomDoc domDoc, DomElement domElement) {
        if (domDoc.JGoXMLOutputEnabled()) {
            DomElement domElement2 = domDoc.createJGoClassElement("com.nwoods.jgo.examples.MultiPortNodePort", domElement);
            domElement2.setAttribute("maxlinks", Integer.toString(this.myMaxLinks));
        }
        super.SVGWriteObject(domDoc, domElement);
    }

    public DomNode SVGReadObject(DomDoc domDoc, JGoDocument jGoDocument, DomElement domElement, DomElement domElement2) {
        if (domElement2 != null) {
            this.myMaxLinks = Integer.parseInt(domElement2.getAttribute("maxlinks"));
            super.SVGReadObject(domDoc, jGoDocument, domElement, domElement2.getNextSiblingJGoClassElement());
        }
        return domElement.getNextSibling();
    }
}

