/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoNode;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoRectangle;
import com.nwoods.jgo.JGoView;
import com.nwoods.jgo.examples.ListArea;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;

public class RecordNode
extends JGoNode {
    public static final int HeaderChanged = 75583;
    public static final int FooterChanged = 75584;
    private ListArea myListArea = null;
    private JGoObject myHeader = null;
    private JGoObject myFooter = null;

    public void initialize() {
        this.myListArea = new ListArea();
        this.myListArea.initialize();
        this.myListArea.setVertical(true);
        this.myListArea.setSelectable(false);
        this.myListArea.getRect().setSelectable(false);
        this.addObjectAtHead(this.myListArea);
    }

    protected void copyChildren(JGoArea jGoArea, JGoCopyEnvironment jGoCopyEnvironment) {
        RecordNode recordNode = (RecordNode)jGoArea;
        super.copyChildren(jGoArea, jGoCopyEnvironment);
        recordNode.myListArea = (ListArea)jGoCopyEnvironment.get(this.myListArea);
        recordNode.myHeader = (JGoObject)jGoCopyEnvironment.get(this.myHeader);
        recordNode.myFooter = (JGoObject)jGoCopyEnvironment.get(this.myFooter);
    }

    public ListArea getListArea() {
        return this.myListArea;
    }

    public JGoObject getHeader() {
        return this.myHeader;
    }

    public void setHeader(JGoObject jGoObject) {
        JGoObject jGoObject2 = this.myHeader;
        if (jGoObject2 != jGoObject) {
            if (jGoObject2 != null) {
                this.removeObject(jGoObject2);
            }
            this.myHeader = jGoObject;
            if (jGoObject != null) {
                jGoObject.setSelectable(false);
                this.addObjectAtHead(jGoObject);
            }
            this.layoutChildren(jGoObject);
            this.update(75583, 0, jGoObject2);
        }
    }

    public JGoObject getFooter() {
        return this.myFooter;
    }

    public void setFooter(JGoObject jGoObject) {
        JGoObject jGoObject2 = this.myFooter;
        if (jGoObject2 != jGoObject) {
            if (jGoObject2 != null) {
                this.removeObject(jGoObject2);
            }
            this.myFooter = jGoObject;
            if (jGoObject != null) {
                jGoObject.setSelectable(false);
                this.addObjectAtHead(jGoObject);
            }
            this.layoutChildren(jGoObject);
            this.update(75584, 0, jGoObject2);
        }
    }

    protected Rectangle handleResize(Graphics2D graphics2D, JGoView jGoView, Rectangle rectangle, Point point, int n, int n2, int n3, int n4) {
        Dimension dimension = this.myListArea.getMinimumSize();
        if (this.getHeader() != null) {
            dimension.height += this.getHeader().getHeight();
        }
        if (this.getFooter() != null) {
            dimension.height += this.getFooter().getHeight();
        }
        return super.handleResize(graphics2D, jGoView, rectangle, point, n, n2, dimension.width, dimension.height);
    }

    public void setBoundingRect(int n, int n2, int n3, int n4) {
        Dimension dimension = this.myListArea.getMinimumSize();
        if (this.getHeader() != null) {
            dimension.height += this.getHeader().getHeight();
        }
        if (this.getFooter() != null) {
            dimension.height += this.getFooter().getHeight();
        }
        super.setBoundingRect(n, n2, Math.max(n3, dimension.width), Math.max(n4, dimension.height));
    }

    public void setVisible(boolean bl) {
        if (this.myListArea != null) {
            this.myListArea.setVisible(bl);
        }
        super.setVisible(bl);
    }

    public void layoutChildren(JGoObject jGoObject) {
        if (this.isInitializing() || this.myListArea == null) {
            return;
        }
        this.setInitializing(true);
        int n = this.getLeft();
        int n2 = this.getTop();
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        int n5 = 0;
        if (this.getHeader() != null) {
            n5 = this.getHeader().getHeight();
        }
        int n6 = 0;
        if (this.getFooter() != null) {
            n6 = this.getFooter().getHeight();
        }
        this.myListArea.setBoundingRect(n, n2 + n5, n3, n4 - n5 - n6);
        JGoRectangle jGoRectangle = this.myListArea.getRect();
        int n7 = jGoRectangle.getLeft() - this.myListArea.getLeft();
        int n8 = jGoRectangle.getTop() - this.myListArea.getTop();
        int n9 = jGoRectangle.getWidth();
        int n10 = jGoRectangle.getHeight();
        int n11 = this.myListArea.getWidth() - n9;
        int n12 = this.myListArea.getHeight() - n10;
        if (this.getHeader() != null) {
            this.getHeader().setBoundingRect(n + n7, n2, n9, n5);
        }
        if (this.getFooter() != null) {
            this.getFooter().setBoundingRect(n + n7, n2 + n4 - n6, n9, n6);
        }
        this.setInitializing(false);
    }

    protected boolean geometryChangeChild(JGoObject jGoObject, Rectangle rectangle) {
        if (this.isInitializing()) {
            return false;
        }
        if (jGoObject == this.myListArea && jGoObject.getWidth() != rectangle.width) {
            int n = this.myListArea.getRect().getWidth();
            if (this.getHeader() != null) {
                this.getHeader().setWidth(n);
            }
            if (this.getFooter() != null) {
                this.getFooter().setWidth(n);
            }
            this.setWidth(n);
            return true;
        }
        return super.geometryChangeChild(jGoObject, rectangle);
    }

    public void addItem(JGoObject jGoObject, JGoPort jGoPort, JGoPort jGoPort2, JGoObject jGoObject2) {
        if (jGoPort != null) {
            jGoPort.setValidSource(false);
            jGoPort.setValidDestination(true);
            if (this.myListArea.isVertical()) {
                jGoPort.setFromSpot(8);
                jGoPort.setToSpot(8);
            } else {
                jGoPort.setFromSpot(2);
                jGoPort.setToSpot(2);
            }
        }
        if (jGoPort2 != null) {
            jGoPort2.setValidSource(true);
            jGoPort2.setValidDestination(false);
            if (this.myListArea.isVertical()) {
                jGoPort2.setFromSpot(4);
                jGoPort2.setToSpot(4);
            } else {
                jGoPort2.setFromSpot(6);
                jGoPort2.setToSpot(6);
            }
        }
        this.myListArea.insertItem(this.getNumItems(), jGoObject, jGoPort, jGoPort2, jGoObject2);
    }

    public JGoPort getLeftPort(int n) {
        return (JGoPort)this.myListArea.getLeftPort(n);
    }

    public void setLeftPort(int n, JGoPort jGoPort) {
        if (jGoPort != null) {
            if (this.myListArea.isVertical()) {
                jGoPort.setFromSpot(8);
                jGoPort.setToSpot(8);
            } else {
                jGoPort.setFromSpot(2);
                jGoPort.setToSpot(2);
            }
        }
        this.myListArea.setLeftPort(n, jGoPort);
    }

    public JGoPort getRightPort(int n) {
        return (JGoPort)this.myListArea.getRightPort(n);
    }

    public void setRightPort(int n, JGoPort jGoPort) {
        if (jGoPort != null) {
            if (this.myListArea.isVertical()) {
                jGoPort.setFromSpot(4);
                jGoPort.setToSpot(4);
            } else {
                jGoPort.setFromSpot(6);
                jGoPort.setToSpot(6);
            }
        }
        this.myListArea.setRightPort(n, jGoPort);
    }

    public void SVGUpdateReference(String string, Object object) {
        super.SVGUpdateReference(string, object);
        if (string.equals("footer")) {
            this.myFooter = (JGoObject)object;
        } else if (string.equals("header")) {
            this.myHeader = (JGoObject)object;
        } else if (string.equals("listarea")) {
            this.myListArea = (ListArea)object;
        }
    }

    public void SVGWriteObject(DomDoc domDoc, DomElement domElement) {
        if (domDoc.JGoXMLOutputEnabled()) {
            DomElement domElement2 = domDoc.createJGoClassElement("com.nwoods.jgo.examples.RecordNode", domElement);
            if (this.myFooter != null) {
                domDoc.registerReferencingNode(domElement2, "footer", this.myFooter);
            }
            if (this.myHeader != null) {
                domDoc.registerReferencingNode(domElement2, "header", this.myHeader);
            }
            if (this.myListArea != null) {
                domDoc.registerReferencingNode(domElement2, "listarea", this.myListArea);
            }
        }
        super.SVGWriteObject(domDoc, domElement);
    }

    public DomNode SVGReadObject(DomDoc domDoc, JGoDocument jGoDocument, DomElement domElement, DomElement domElement2) {
        if (domElement2 != null) {
            String string = domElement2.getAttribute("footer");
            domDoc.registerReferencingObject(this, "footer", string);
            String string2 = domElement2.getAttribute("header");
            domDoc.registerReferencingObject(this, "header", string2);
            String string3 = domElement2.getAttribute("listarea");
            domDoc.registerReferencingObject(this, "listarea", string3);
            super.SVGReadObject(domDoc, jGoDocument, domElement, domElement2.getNextSiblingJGoClassElement());
        }
        return domElement.getNextSibling();
    }

    public int getNumItems() {
        return this.myListArea.getNumItems();
    }

    public JGoObject getItem(int n) {
        return this.myListArea.getItem(n);
    }

    public void setItem(int n, JGoObject jGoObject) {
        this.myListArea.setItem(n, jGoObject);
    }

    public int findItem(JGoObject jGoObject) {
        return this.myListArea.findItem(jGoObject);
    }

    public void removeItem(int n) {
        this.myListArea.removeItem(n);
    }

    public JGoObject getIcon(int n) {
        return this.myListArea.getIcon(n);
    }

    public void setIcon(int n, JGoObject jGoObject) {
        this.myListArea.setIcon(n, jGoObject);
    }

    public boolean isVertical() {
        return this.myListArea.isVertical();
    }

    public void setVertical(boolean bl) {
        this.myListArea.setVertical(bl);
    }

    public boolean isScrollBarOnRight() {
        return this.myListArea.isScrollBarOnRight();
    }

    public void setScrollBarOnRight(boolean bl) {
        this.myListArea.setScrollBarOnRight(bl);
    }

    public JGoPen getLinePen() {
        return this.myListArea.getLinePen();
    }

    public void setLinePen(JGoPen jGoPen) {
        this.myListArea.setLinePen(jGoPen);
    }

    public Insets getInsets() {
        return this.myListArea.getInsets();
    }

    public void setInsets(Insets insets) {
        this.myListArea.setInsets(insets);
    }

    public int getSpacing() {
        return this.myListArea.getSpacing();
    }

    public void setSpacing(int n) {
        this.myListArea.setSpacing(n);
    }

    public int getAlignment() {
        return this.myListArea.getAlignment();
    }

    public void setAlignment(int n) {
        this.myListArea.setAlignment(n);
    }

    public int getIconAlignment() {
        return this.myListArea.getIconAlignment();
    }

    public int getIconSpacing() {
        return this.myListArea.getIconSpacing();
    }

    public void setIconSpacing(int n) {
        this.myListArea.setIconSpacing(n);
    }

    public void setIconAlignment(int n) {
        this.myListArea.setIconAlignment(n);
    }

    public int getFirstVisibleIndex() {
        return this.myListArea.getFirstVisibleIndex();
    }

    public void setFirstVisibleIndex(int n) {
        this.myListArea.setFirstVisibleIndex(n);
    }

    public int getLastVisibleIndex() {
        return this.myListArea.getLastVisibleIndex();
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit jGoDocumentChangedEdit) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 75583: {
                jGoDocumentChangedEdit.setNewValue(this.getHeader());
                return;
            }
            case 75584: {
                jGoDocumentChangedEdit.setNewValue(this.getFooter());
                return;
            }
        }
        super.copyNewValueForRedo(jGoDocumentChangedEdit);
    }

    public void changeValue(JGoDocumentChangedEdit jGoDocumentChangedEdit, boolean bl) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 75583: {
                this.setHeader((JGoObject)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
            case 75584: {
                this.setFooter((JGoObject)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
        }
        super.changeValue(jGoDocumentChangedEdit, bl);
    }
}

