/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.animatedbasicapp;

import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoDrawable;
import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoView;
import java.awt.Graphics2D;
import java.awt.Point;

public class AnimatedLink
extends JGoLink {
    private transient int mySeg = 0;
    private transient float myDist = 0.0f;

    public AnimatedLink() {
    }

    public AnimatedLink(JGoPort jGoPort, JGoPort jGoPort2) {
        super(jGoPort, jGoPort2);
    }

    public void paint(Graphics2D graphics2D, JGoView jGoView) {
        super.paint(graphics2D, jGoView);
        AnimatedLink animatedLink = this;
        if (this.mySeg >= animatedLink.getNumPoints() - 1) {
            this.mySeg = 0;
        }
        Point point = animatedLink.getPoint(this.mySeg);
        Point point2 = animatedLink.getPoint(this.mySeg + 1);
        double d = Math.sqrt((point2.x - point.x) * (point2.x - point.x) + (point2.y - point.y) * (point2.y - point.y));
        int n = point2.x;
        int n2 = point2.y;
        if ((double)this.myDist >= d) {
            ++this.mySeg;
            this.myDist = 0.0f;
        } else if (d >= 1.0) {
            n = (int)((double)point.x + (double)((float)(point2.x - point.x) * this.myDist) / d);
            n2 = (int)((double)point.y + (double)((float)(point2.y - point.y) * this.myDist) / d);
        }
        JGoDrawable.drawEllipse(graphics2D, null, JGoBrush.red, n - 3, n2 - 3, 7, 7);
    }

    public void step() {
        this.myDist += 3.0f;
        this.update();
    }
}

