/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.classier;

import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoSelection;
import com.nwoods.jgo.JGoTextNode;
import java.awt.Color;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

class ClassNode
extends JGoTextNode {
    public static JGoPen myClassPen = JGoPen.lightGray;
    public static JGoBrush myClassBrush = JGoBrush.lightGray;
    public static JGoBrush mySelClassBrush = JGoBrush.makeStockBrush(new Color(200, 255, 255));
    public static JGoPen myInterfacePen = JGoPen.gray;
    public static JGoBrush myInterfaceBrush = JGoBrush.white;
    public static JGoBrush mySelInterfaceBrush = JGoBrush.makeStockBrush(new Color(200, 255, 255));
    public static JGoBrush myDetailBrush = JGoBrush.makeStockBrush(new Color(250, 250, 200, 200));
    private Object myObject = null;

    public ClassNode() {
    }

    public ClassNode(String string) {
        super(string);
    }

    public Object getObject() {
        return this.myObject;
    }

    public void setObject(Object object) {
        if (object != null && object instanceof Class) {
            Class clazz = (Class)object;
            this.myObject = clazz;
            this.setText(clazz.getName());
            this.getLabel().setMultiline(false);
            if (clazz.isInterface()) {
                this.setPen(myInterfacePen);
                this.setBrush(myInterfaceBrush);
                this.getLabel().setItalic(true);
            } else {
                this.setPen(myClassPen);
                this.setBrush(myClassBrush);
                this.getLabel().setItalic(false);
            }
        }
    }

    public void toggleInfo() {
        Class clazz = (Class)this.getObject();
        if (this.getLabel().isMultiline()) {
            this.getLabel().setMultiline(false);
            if (clazz.isInterface()) {
                this.setBrush(myInterfaceBrush);
            } else {
                this.setBrush(myClassBrush);
            }
            this.setText(clazz.getName());
        } else {
            this.getLabel().setMultiline(true);
            this.setBrush(myDetailBrush);
            String string = clazz.getName();
            string = string + this.getClassInfo(clazz);
            this.setText(string);
        }
    }

    public String getClassInfo(Class clazz) {
        String string = "";
        try {
            Object object;
            Object object2;
            int n;
            String string2 = clazz.getName() + ".";
            Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
            for (n = 0; n < constructorArray.length; ++n) {
                object2 = constructorArray[n];
                if (!this.isDisplayable((Member)object2)) continue;
                string = string + "\n";
                object = ((Constructor)object2).toString();
                object = this.replaceSubstring((String)object, string2, "");
                object = this.replaceSubstring((String)object, "com.nwoods.jgo.", "");
                object = this.replaceSubstring((String)object, "java.lang.", "");
                string = string + (String)object;
            }
            object2 = clazz.getDeclaredMethods();
            for (n = 0; n < ((Method[])object2).length; ++n) {
                object = object2[n];
                if (!this.isDisplayable((Member)object)) continue;
                string = string + "\n";
                String string3 = ((Method)object).toString();
                string3 = this.replaceSubstring(string3, string2, "");
                string3 = this.replaceSubstring(string3, "com.nwoods.jgo.", "");
                string3 = this.replaceSubstring(string3, "java.lang.", "");
                string = string + string3;
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace();
        }
        return string;
    }

    public boolean isDisplayable(Member member) {
        int n = member.getModifiers();
        return Modifier.isPublic(n) || Modifier.isProtected(n);
    }

    private String replaceSubstring(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        if (n < 0) {
            return string;
        }
        return string.substring(0, n) + string3 + this.replaceSubstring(string.substring(n + string2.length()), string2, string3);
    }

    protected void gainedSelection(JGoSelection jGoSelection) {
        this.getDocument().bringObjectToFront(this);
        Class clazz = (Class)this.getObject();
        if (clazz.isInterface()) {
            this.setBrush(mySelInterfaceBrush);
        } else {
            this.setBrush(mySelClassBrush);
        }
    }

    protected void lostSelection(JGoSelection jGoSelection) {
        Class clazz = (Class)this.getObject();
        if (this.getLabel().isMultiline()) {
            this.setBrush(myDetailBrush);
        } else if (clazz.isInterface()) {
            this.setBrush(myInterfaceBrush);
        } else {
            this.setBrush(myClassBrush);
        }
    }
}

