/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.classier;

import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoSelection;
import com.nwoods.jgo.JGoView;
import com.nwoods.jgo.JGoViewEvent;
import com.nwoods.jgo.JGoViewListener;
import com.nwoods.jgo.examples.classier.ClassNode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class Classier
extends JApplet
implements Runnable {
    protected int myHorizSeparation = 40;
    protected int myVertSeparation = 4;
    protected JGoPen myExtendsPen = JGoPen.black;
    protected JGoPen myImplementsPen = JGoPen.make(1, 1, Color.black);
    protected JGoView myView;
    protected JGoDocument myDoc;
    protected HashMap myMap = new HashMap();

    public Classier() {
        this.myView = new JGoView();
        this.myDoc = this.myView.getDocument();
        this.myView.setInternalMouseActions(2);
        this.myView.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n == 127) {
                    JGoSelection jGoSelection = Classier.this.myView.getSelection();
                    JGoListPosition jGoListPosition = jGoSelection.getFirstObjectPos();
                    while (jGoListPosition != null) {
                        ClassNode classNode;
                        Object object;
                        JGoObject jGoObject = jGoSelection.getObjectAtPos(jGoListPosition);
                        jGoListPosition = jGoSelection.getNextObjectPos(jGoListPosition);
                        if (!(jGoObject instanceof ClassNode) || (object = (classNode = (ClassNode)jGoObject).getObject()) == null) continue;
                        Classier.this.myMap.remove(object);
                    }
                    Classier.this.myView.deleteSelection();
                } else if (keyEvent.isControlDown() && n == 81) {
                    System.exit(0);
                } else if (keyEvent.isControlDown() && n == 80) {
                    Classier.this.myView.print();
                } else if (n == 118) {
                    double d = Math.rint(Classier.this.myView.getScale() * (double)0.9f * 100.0) / 100.0;
                    Classier.this.myView.setScale(d);
                } else if (n == 119) {
                    double d = Math.rint(Classier.this.myView.getScale() / (double)0.9f * 100.0) / 100.0;
                    Classier.this.myView.setScale(d);
                }
            }
        });
        this.myView.addViewListener(new JGoViewListener(){

            public void viewChanged(JGoViewEvent jGoViewEvent) {
                switch (jGoViewEvent.getHint()) {
                    case 23: {
                        JGoObject jGoObject = jGoViewEvent.getJGoObject();
                        jGoObject = jGoObject.getTopLevelObject();
                        if (!(jGoObject instanceof ClassNode)) break;
                        ClassNode classNode = (ClassNode)jGoObject;
                        classNode.toggleInfo();
                        Classier.this.myView.getSelection().clearSelection();
                        break;
                    }
                }
            }
        });
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.myView, "Center");
        container.validate();
    }

    public void init() {
        this.initNodes();
        JOptionPane.showMessageDialog(this, "Double click a class to see its public and protected methods.\nDouble click again to hide the information.", "View Class Methods", 1);
    }

    public void start() {
        new Thread(this).start();
    }

    public void run() {
        this.myView.initializeDragDropHandling();
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            final JFrame jFrame = new JFrame();
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    Object object = windowEvent.getSource();
                    if (object == jFrame) {
                        System.exit(0);
                    }
                }
            });
            jFrame.setTitle("JGo Class Hierarchy Viewer");
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            jFrame.setBounds(0, 0, dimension.width, dimension.height);
            Classier classier = new Classier();
            Container container = jFrame.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)classier, "Center");
            container.validate();
            jFrame.setVisible(true);
            classier.init();
            classier.start();
        }
        catch (Throwable throwable) {
            System.err.println(throwable);
            throwable.printStackTrace();
            System.exit(1);
        }
    }

    public void initNodes() {
        Cursor cursor = this.myView.getTopLevelAncestor().getCursor();
        this.myView.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(3));
        this.myDoc.setSuspendUpdates(true);
        this.addClassNode("com.nwoods.jgo.DomDoc");
        this.addClassNode("com.nwoods.jgo.DomElement");
        this.addClassNode("com.nwoods.jgo.DomList");
        this.addClassNode("com.nwoods.jgo.DomNode");
        this.addClassNode("com.nwoods.jgo.DomText");
        this.addClassNode("com.nwoods.jgo.JGo3DNoteRect");
        this.addClassNode("com.nwoods.jgo.JGo3DRect");
        this.addClassNode("com.nwoods.jgo.JGoArea");
        this.addClassNode("com.nwoods.jgo.JGoBasicNode");
        this.addClassNode("com.nwoods.jgo.JGoBrush");
        this.addClassNode("com.nwoods.jgo.JGoButton");
        this.addClassNode("com.nwoods.jgo.JGoCollection");
        this.addClassNode("com.nwoods.jgo.JGoControl");
        this.addClassNode("com.nwoods.jgo.JGoCopyMap");
        this.addClassNode("com.nwoods.jgo.JGoDocument");
        this.addClassNode("com.nwoods.jgo.JGoDocumentChangedEdit");
        this.addClassNode("com.nwoods.jgo.JGoDocumentEvent");
        this.addClassNode("com.nwoods.jgo.JGoDrawable");
        this.addClassNode("com.nwoods.jgo.JGoEllipse");
        this.addClassNode("com.nwoods.jgo.JGoGlobal");
        this.addClassNode("com.nwoods.jgo.JGoHandle");
        this.addClassNode("com.nwoods.jgo.JGoIconicNode");
        this.addClassNode("com.nwoods.jgo.JGoImage");
        this.addClassNode("com.nwoods.jgo.JGoLabeledLink");
        this.addClassNode("com.nwoods.jgo.JGoLayer");
        this.addClassNode("com.nwoods.jgo.JGoLink");
        this.addClassNode("com.nwoods.jgo.JGoLinkLabel");
        this.addClassNode("com.nwoods.jgo.JGoListPosition");
        this.addClassNode("com.nwoods.jgo.JGoNode");
        this.addClassNode("com.nwoods.jgo.JGoObject");
        this.addClassNode("com.nwoods.jgo.JGoOverview");
        this.addClassNode("com.nwoods.jgo.JGoPalette");
        this.addClassNode("com.nwoods.jgo.JGoPen");
        this.addClassNode("com.nwoods.jgo.JGoPolygon");
        this.addClassNode("com.nwoods.jgo.JGoPort");
        this.addClassNode("com.nwoods.jgo.JGoPrintPreview");
        this.addClassNode("com.nwoods.jgo.JGoRectangle");
        this.addClassNode("com.nwoods.jgo.JGoRoundRect");
        this.addClassNode("com.nwoods.jgo.JGoScrollBar");
        this.addClassNode("com.nwoods.jgo.JGoSelection");
        this.addClassNode("com.nwoods.jgo.JGoStroke");
        this.addClassNode("com.nwoods.jgo.JGoSubGraph");
        this.addClassNode("com.nwoods.jgo.JGoSubGraphBase");
        this.addClassNode("com.nwoods.jgo.JGoSubGraphHandle");
        this.addClassNode("com.nwoods.jgo.JGoText");
        this.addClassNode("com.nwoods.jgo.JGoTextEdit");
        this.addClassNode("com.nwoods.jgo.JGoTextNode");
        this.addClassNode("com.nwoods.jgo.JGoUndoManager");
        this.addClassNode("com.nwoods.jgo.JGoView");
        this.addClassNode("com.nwoods.jgo.JGoViewEvent");
        this.addClassNode("com.nwoods.jgo.examples.Comment");
        this.addClassNode("com.nwoods.jgo.examples.Diamond");
        this.addClassNode("com.nwoods.jgo.examples.GeneralNode");
        this.addClassNode("com.nwoods.jgo.examples.GeneralNodeLabel");
        this.addClassNode("com.nwoods.jgo.examples.GeneralNodePort");
        this.addClassNode("com.nwoods.jgo.examples.GeneralNodePortLabel");
        this.addClassNode("com.nwoods.jgo.examples.ListArea");
        this.addClassNode("com.nwoods.jgo.examples.ListAreaRect");
        this.addClassNode("com.nwoods.jgo.examples.MultiPortNode");
        this.addClassNode("com.nwoods.jgo.examples.MultiPortNodeLabel");
        this.addClassNode("com.nwoods.jgo.examples.MultiPortNodePort");
        this.addClassNode("com.nwoods.jgo.examples.MultiTextNode");
        this.addClassNode("com.nwoods.jgo.examples.RecordNode");
        this.addClassNode("com.nwoods.jgo.examples.SimpleNode");
        this.addClassNode("com.nwoods.jgo.examples.SimpleNodeLabel");
        this.addClassNode("com.nwoods.jgo.examples.SimpleNodePort");
        this.addClassNode("com.nwoods.jgo.examples.SVGGoView");
        this.addClassNode("com.nwoods.jgo.layout.JGoAutoLayout");
        this.addClassNode("com.nwoods.jgo.layout.JGoForceDirectedAutoLayout");
        this.addClassNode("com.nwoods.jgo.layout.JGoLayeredDigraphAutoLayout");
        this.addClassNode("com.nwoods.jgo.layout.JGoNetwork");
        this.addClassNode("com.nwoods.jgo.layout.JGoNetworkLink");
        this.addClassNode("com.nwoods.jgo.layout.JGoNetworkNode");
        this.addClassNode("com.nwoods.jgo.layout.JGoRandomAutoLayout");
        this.addClassNode("com.nwoods.jgo.instruments.AbstractGraduatedScale");
        this.addClassNode("com.nwoods.jgo.instruments.AbstractIndicator");
        this.addClassNode("com.nwoods.jgo.instruments.GraduatedScaleElliptical");
        this.addClassNode("com.nwoods.jgo.instruments.GraduatedScaleLinear");
        this.addClassNode("com.nwoods.jgo.instruments.IndicatorBar");
        this.addClassNode("com.nwoods.jgo.instruments.IndicatorBarElliptical");
        this.addClassNode("com.nwoods.jgo.instruments.IndicatorKnob");
        this.addClassNode("com.nwoods.jgo.instruments.IndicatorNeedle");
        this.addClassNode("com.nwoods.jgo.instruments.IndicatorSlider");
        this.addClassNode("com.nwoods.jgo.instruments.IndicatorSliderElliptical");
        this.addClassNode("com.nwoods.jgo.instruments.Meter");
        this.addClassNode("com.nwoods.jgo.instruments.MultipleIndicatorMeter");
        this.layoutNodes();
        this.myDoc.setSuspendUpdates(false);
        this.myView.getTopLevelAncestor().setCursor(cursor);
    }

    public ClassNode addClassNode(String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Unable to find the Class for " + string, "Class not found", 1);
        }
        return this.addClassNode(clazz);
    }

    public ClassNode addClassNode(Class clazz) {
        if (clazz == null) {
            return null;
        }
        ClassNode classNode = this.findNode(clazz);
        if (classNode != null) {
            return classNode;
        }
        classNode = this.getNode(clazz);
        this.addSuperClass(clazz, classNode);
        this.addInterfaces(clazz, classNode);
        return classNode;
    }

    public void addSuperClass(Class clazz, ClassNode classNode) {
        ClassNode classNode2;
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null && (classNode2 = this.addClassNode(clazz2)) != null) {
            JGoLink jGoLink = new JGoLink(classNode2.getRightPort(), classNode.getLeftPort());
            jGoLink.setSelectable(false);
            jGoLink.setResizable(false);
            jGoLink.setPen(this.myExtendsPen);
            this.myDoc.addObjectAtHead(jGoLink);
        }
    }

    public void addInterfaces(Class clazz, ClassNode classNode) {
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            Class<?> clazz2 = classArray[i];
            ClassNode classNode2 = this.addClassNode(clazz2);
            if (classNode2 == null) continue;
            JGoLink jGoLink = new JGoLink(classNode2.getRightPort(), classNode.getLeftPort());
            jGoLink.setSelectable(false);
            jGoLink.setResizable(false);
            jGoLink.setPen(this.myImplementsPen);
            this.myDoc.addObjectAtHead(jGoLink);
        }
    }

    public void layoutNodes() {
        int n = 10;
        int n2 = 10;
        ClassNode classNode = this.addClassNode("java.lang.Object");
        int n3 = this.layoutTree(classNode, n, n2);
        n2 = n3 + classNode.getHeight() + this.myVertSeparation;
        JGoListPosition jGoListPosition = this.myDoc.getFirstObjectPos();
        while (jGoListPosition != null) {
            ClassNode classNode2;
            Class clazz;
            JGoObject jGoObject = this.myDoc.getObjectAtPos(jGoListPosition);
            jGoListPosition = this.myDoc.getNextObjectPosAtTop(jGoListPosition);
            if (!(jGoObject instanceof ClassNode) || !(clazz = (Class)(classNode2 = (ClassNode)jGoObject).getObject()).isInterface() || !classNode2.getLeftPort().hasNoLinks()) continue;
            n3 = this.layoutTree(classNode2, n, n2);
            n2 = n3 + classNode2.getHeight() + this.myVertSeparation;
        }
    }

    public int layoutTree(ClassNode classNode, int n, int n2) {
        int n3 = n2;
        int n4 = n2;
        JGoPort jGoPort = classNode.getRightPort();
        JGoListPosition jGoListPosition = jGoPort.getFirstLinkPos();
        while (jGoListPosition != null) {
            JGoLink jGoLink = jGoPort.getLinkAtPos(jGoListPosition);
            jGoListPosition = jGoPort.getNextLinkPos(jGoListPosition);
            JGoPort jGoPort2 = jGoLink.getOtherPort(jGoPort);
            ClassNode classNode2 = (ClassNode)jGoPort2.getParent();
            if (classNode2.getTop() > 0) continue;
            n4 = this.layoutTree(classNode2, n + classNode.getWidth() + this.myHorizSeparation, n2);
            n2 = n4 + classNode.getHeight() + this.myVertSeparation;
        }
        classNode.setTopLeft(n, (n3 + n4) / 2);
        return n4;
    }

    public ClassNode findNode(Object object) {
        Object v = this.myMap.get(object);
        if (v instanceof ClassNode) {
            return (ClassNode)v;
        }
        return null;
    }

    public ClassNode getNode(Object object) {
        ClassNode classNode = this.findNode(object);
        if (classNode == null) {
            classNode = new ClassNode(object.toString());
            classNode.setObject(object);
            this.myDoc.addObjectAtTail(classNode);
            this.myMap.put(object, classNode);
        }
        return classNode;
    }
}

