/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoRectangle;
import com.nwoods.jgo.JGoView;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

public class JGo3DNoteRect
extends JGoRectangle {
    public static final int ChangedShadowSize = 401;
    public static final int ChangedFlapSize = 402;
    private int dK = 4;
    private int dJ = 8;

    public JGo3DNoteRect() {
    }

    public JGo3DNoteRect(Rectangle rectangle) {
        super(rectangle);
    }

    public JGo3DNoteRect(Point point, Dimension dimension) {
        super(point, dimension);
    }

    public JGoObject copyObject(JGoCopyEnvironment jGoCopyEnvironment) {
        JGo3DNoteRect jGo3DNoteRect = (JGo3DNoteRect)super.copyObject(jGoCopyEnvironment);
        if (jGo3DNoteRect != null) {
            jGo3DNoteRect.dK = this.dK;
            jGo3DNoteRect.dJ = this.dJ;
        }
        return jGo3DNoteRect;
    }

    public void SVGWriteObject(DomDoc domDoc, DomElement domElement) {
        if (domDoc.JGoXMLOutputEnabled()) {
            DomElement domElement2 = domDoc.createJGoClassElement("com.nwoods.jgo.JGo3DNoteRect", domElement);
            domElement2.setAttribute("flapsize", Integer.toString(this.dJ));
            domElement2.setAttribute("shadow", Integer.toString(this.dK));
        }
        super.SVGWriteObject(domDoc, domElement);
    }

    public DomNode SVGReadObject(DomDoc domDoc, JGoDocument jGoDocument, DomElement domElement, DomElement domElement2) {
        if (domElement2 != null) {
            this.setFlapSize(Integer.parseInt(domElement2.getAttribute("flapsize")));
            this.setShadowSize(Integer.parseInt(domElement2.getAttribute("shadow")));
            super.SVGReadObject(domDoc, jGoDocument, domElement, domElement2.getNextSiblingJGoClassElement());
        }
        return domElement.getNextSibling();
    }

    public void paint(Graphics2D graphics2D, JGoView jGoView) {
        Rectangle rectangle = this.getBoundingRect();
        int n = this.getShadowSize();
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width - n;
        int n5 = rectangle.height - n;
        this.drawRect(graphics2D, n2, n3, n4, n5);
        int[] nArray = jGoView.do(6);
        int[] nArray2 = jGoView.if(6);
        nArray[0] = n2 + n4;
        nArray2[0] = n3;
        nArray[1] = rectangle.x + rectangle.width;
        nArray2[1] = rectangle.y + n;
        nArray[2] = rectangle.x + rectangle.width;
        nArray2[2] = rectangle.y + rectangle.height;
        nArray[3] = rectangle.x + n;
        nArray2[3] = rectangle.y + rectangle.height;
        nArray[4] = n2;
        nArray2[4] = n3 + n5;
        nArray[5] = n2 + n4;
        nArray2[5] = n3 + n5;
        JGo3DNoteRect.drawPolygon(graphics2D, null, JGoBrush.lightGray, nArray, nArray2, 6);
        int n6 = this.getFlapSize();
        nArray[0] = n2 + n4 - n6;
        nArray2[0] = n3 + n5;
        nArray[1] = n2 + n4 - n6 * 7 / 8;
        nArray2[1] = n3 + n5 - n6 * 7 / 8;
        nArray[2] = n2 + n4;
        nArray2[2] = n3 + n5 - n6;
        JGo3DNoteRect.drawPolygon(graphics2D, null, JGoBrush.gray, nArray, nArray2, 3);
    }

    public int getShadowSize() {
        return this.dK;
    }

    public void setShadowSize(int n) {
        int n2 = this.dK;
        if (n2 != n) {
            this.dK = Math.max(n, 0);
            this.update(401, n2, null);
        }
    }

    public int getFlapSize() {
        return this.dJ;
    }

    public void setFlapSize(int n) {
        int n2 = this.dJ;
        if (n2 != n) {
            this.dJ = Math.max(n, 0);
            this.update(402, n2, null);
        }
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit jGoDocumentChangedEdit) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 401: {
                jGoDocumentChangedEdit.setNewValueInt(this.getShadowSize());
                return;
            }
            case 402: {
                jGoDocumentChangedEdit.setNewValueInt(this.getFlapSize());
                return;
            }
        }
        super.copyNewValueForRedo(jGoDocumentChangedEdit);
    }

    public void changeValue(JGoDocumentChangedEdit jGoDocumentChangedEdit, boolean bl) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 401: {
                this.setShadowSize(jGoDocumentChangedEdit.getValueInt(bl));
                return;
            }
            case 402: {
                this.setFlapSize(jGoDocumentChangedEdit.getValueInt(bl));
                return;
            }
        }
        super.changeValue(jGoDocumentChangedEdit, bl);
    }
}

