/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoDrawable;
import com.nwoods.jgo.JGoEllipse;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoNode;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoText;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JGoBasicNode
extends JGoNode {
    private static Dimension db = new Dimension(7, 7);
    private static Dimension da = new Dimension(7, 7);
    public static final int ChangedLabelSpot = 2101;
    public static final int ChangedDrawable = 2102;
    public static final int ChangedLabel = 2103;
    public static final int ChangedPort = 2104;
    public static final int ChangedInsets = 2105;
    public static final int ChangedAutoResize = 2106;
    private static final int dd = 65536;
    private JGoDrawable dc = null;
    private JGoText dh = null;
    private JGoPort dg = null;
    private int df = 2;
    private Insets de = new Insets(5, 10, 5, 10);

    public JGoBasicNode() {
        this.q();
    }

    public JGoBasicNode(String string) {
        this.q();
        this.do(string);
    }

    private void q() {
        this.for(this.g() & 0xFFFFFFEF | 0x10000);
    }

    private void do(String string) {
        this.setInitializing(true);
        this.dg = this.createPort();
        this.dc = this.createDrawable(this.dg);
        this.dh = this.createLabel(string);
        this.addObjectAtHead(this.dc);
        this.addObjectAtTail(this.dg);
        this.addObjectAtTail(this.dh);
        if (this.dg != null) {
            this.dg.setPortObject(this.dc);
        }
        this.setInitializing(false);
        this.layoutChildren(null);
    }

    public JGoPort createPort() {
        JGoPort jGoPort = new JGoPort();
        if (this.getLabelSpot() == 0) {
            jGoPort.setStyle(0);
        } else {
            jGoPort.setStyle(2);
        }
        jGoPort.setFromSpot(-1);
        jGoPort.setToSpot(-1);
        jGoPort.setSize(db);
        return jGoPort;
    }

    public JGoDrawable createDrawable(JGoPort jGoPort) {
        JGoEllipse jGoEllipse = new JGoEllipse();
        Dimension dimension = da;
        jGoEllipse.setSize(jGoPort.getWidth() + 2 * dimension.width, jGoPort.getHeight() + 2 * dimension.height);
        jGoEllipse.setSelectable(false);
        jGoEllipse.setResizable(false);
        jGoEllipse.setBrush(JGoBrush.white);
        return jGoEllipse;
    }

    public JGoText createLabel(String string) {
        if (string != null) {
            JGoText jGoText = new JGoText(string);
            jGoText.setSelectable(false);
            jGoText.setDraggable(false);
            jGoText.setEditable(false);
            jGoText.setEditOnSingleClick(true);
            jGoText.setTransparent(true);
            return jGoText;
        }
        return null;
    }

    protected void copyChildren(JGoArea jGoArea, JGoCopyEnvironment jGoCopyEnvironment) {
        JGoBasicNode jGoBasicNode = (JGoBasicNode)jGoArea;
        jGoBasicNode.df = this.df;
        jGoBasicNode.de = new Insets(this.de.top, this.de.left, this.de.bottom, this.de.right);
        super.copyChildren(jGoArea, jGoCopyEnvironment);
        jGoBasicNode.dc = (JGoDrawable)jGoCopyEnvironment.get(this.dc);
        jGoBasicNode.dg = (JGoPort)jGoCopyEnvironment.get(this.dg);
        jGoBasicNode.dh = (JGoText)jGoCopyEnvironment.get(this.dh);
    }

    public JGoObject removeObjectAtPos(JGoListPosition jGoListPosition) {
        JGoObject jGoObject = super.removeObjectAtPos(jGoListPosition);
        if (jGoObject == this.dc) {
            this.dc = null;
        } else if (jGoObject == this.dh) {
            this.dh = null;
        } else if (jGoObject == this.dg) {
            this.dg = null;
        }
        return jGoObject;
    }

    public Point getLocation(Point point) {
        if (this.getDrawable() != null) {
            return this.getDrawable().getSpotLocation(0, point);
        }
        return this.getSpotLocation(0, point);
    }

    public void setLocation(int n, int n2) {
        if (this.getDrawable() != null) {
            Rectangle rectangle = this.getDrawable().getBoundingRect();
            int n3 = rectangle.x + rectangle.width / 2;
            int n4 = rectangle.y + rectangle.height / 2;
            if (n != n3 || n2 != n4) {
                int n5 = this.getLeft();
                int n6 = this.getTop();
                this.setTopLeft(n - (n3 - n5), n2 - (n4 - n6));
            }
        } else {
            Rectangle rectangle = this.getBoundingRect();
            int n7 = rectangle.x + rectangle.width / 2;
            int n8 = rectangle.y + rectangle.height / 2;
            if (n != n7 || n2 != n8) {
                this.setTopLeft(n - rectangle.width / 2, n2 - rectangle.height / 2);
            }
        }
    }

    public void layoutChildren(JGoObject jGoObject) {
        if (this.isInitializing()) {
            return;
        }
        JGoDrawable jGoDrawable = this.getDrawable();
        if (jGoDrawable == null) {
            return;
        }
        JGoText jGoText = this.getLabel();
        if (jGoText != null) {
            int n = this.getLabelSpot();
            if (n == 0) {
                int n2 = jGoDrawable.getLeft() + jGoDrawable.getWidth() / 2;
                int n3 = jGoDrawable.getTop() + jGoDrawable.getHeight() / 2;
                Insets insets = this.getInsets();
                if (this.isAutoResize()) {
                    int n4 = jGoText.getWidth() + insets.left + insets.right;
                    int n5 = jGoText.getHeight() + insets.top + insets.bottom;
                    jGoDrawable.setBoundingRect(n2 - jGoText.getWidth() / 2 - insets.left, n3 - jGoText.getHeight() / 2 - insets.top, n4, n5);
                } else {
                    int n6 = Math.max(jGoDrawable.getWidth() - (insets.left + insets.right), 0);
                    int n7 = Math.max(jGoDrawable.getHeight() - (insets.top + insets.bottom), 0);
                    jGoText.setWidth(n6);
                    jGoText.setWrappingWidth(n6);
                    jGoText.B();
                    int n8 = Math.min(jGoText.getHeight(), n7);
                    int n9 = jGoDrawable.getLeft() + insets.left;
                    int n10 = jGoDrawable.getTop() + insets.top + (n7 - n8) / 2;
                    jGoText.setBoundingRect(n9, n10, n6, n8);
                }
                jGoText.setAlignment(0);
                jGoText.setSpotLocation(0, n2, n3);
                if (this.getPort() != null) {
                    this.getPort().setBoundingRect(jGoDrawable.getBoundingRect());
                }
            } else {
                jGoText.setAlignment(JGoBasicNode.spotOpposite(n));
                jGoText.setSpotLocation(JGoBasicNode.spotOpposite(n), jGoDrawable, n);
            }
        }
        if (this.getPort() != null) {
            this.getPort().setSpotLocation(0, jGoDrawable, 0);
        }
    }

    public int getLabelSpot() {
        return this.df;
    }

    public void setLabelSpot(int n) {
        this.for(n, false);
    }

    private void for(int n, boolean bl) {
        int n2 = this.df;
        if (n2 != n) {
            this.df = n;
            this.update(2101, n2, null);
            if (!bl) {
                this.labelSpotChanged(n2);
            }
        }
    }

    public void labelSpotChanged(int n) {
        JGoPort jGoPort = this.getPort();
        if (jGoPort != null) {
            if (this.getLabelSpot() == 0) {
                jGoPort.setStyle(0);
                this.setResizable(false);
            } else if (n == 0) {
                jGoPort.setStyle(2);
                JGoDrawable jGoDrawable = this.getDrawable();
                int n2 = jGoDrawable.getLeft() + jGoDrawable.getWidth() / 2;
                int n3 = jGoDrawable.getTop() + jGoDrawable.getHeight() / 2;
                Rectangle rectangle = new Rectangle(n2 - JGoBasicNode.db.width / 2, n3 - JGoBasicNode.db.height / 2, JGoBasicNode.db.width, JGoBasicNode.db.height);
                jGoDrawable.setBoundingRect(n2 - rectangle.width / 2 - JGoBasicNode.da.width, n3 - rectangle.height / 2 - JGoBasicNode.da.height, rectangle.width + 2 * JGoBasicNode.da.width, rectangle.height + 2 * JGoBasicNode.da.height);
                jGoPort.setBoundingRect(rectangle);
            }
        }
        this.layoutChildren(this.getLabel());
    }

    public Insets getInsets() {
        return this.de;
    }

    public void setInsets(Insets insets) {
        this.a(insets, false);
    }

    private void a(Insets insets, boolean bl) {
        Insets insets2 = this.de;
        if (!insets2.equals(insets)) {
            Insets insets3 = new Insets(insets2.top, insets2.left, insets2.bottom, insets2.right);
            this.de.top = insets.top;
            this.de.left = insets.left;
            this.de.bottom = insets.bottom;
            this.de.right = insets.right;
            this.update(2105, 0, insets3);
            if (!bl) {
                this.layoutChildren(null);
            }
        }
    }

    public void setAutoResize(boolean bl) {
        this.do(bl, false);
    }

    private void do(boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = bl3 = (this.g() & 0x10000) != 0;
        if (bl3 != bl) {
            if (bl) {
                this.for(this.g() | 0x10000);
            } else {
                this.for(this.g() & 0xFFFEFFFF);
            }
            this.update(2106, bl3 ? 1 : 0, null);
            if (!bl2) {
                this.onAutoResizeChanged(bl3);
            }
        }
    }

    public boolean isAutoResize() {
        return (this.g() & 0x10000) != 0;
    }

    public void onAutoResizeChanged(boolean bl) {
        JGoText jGoText = this.getLabel();
        if (jGoText != null) {
            jGoText.setMultiline(bl);
            jGoText.setWrapping(bl);
            jGoText.setClipping(bl);
        }
    }

    public JGoPen getPen() {
        return this.getDrawable().getPen();
    }

    public void setPen(JGoPen jGoPen) {
        this.getDrawable().setPen(jGoPen);
    }

    public JGoBrush getBrush() {
        return this.getDrawable().getBrush();
    }

    public void setBrush(JGoBrush jGoBrush) {
        this.getDrawable().setBrush(jGoBrush);
    }

    public String getText() {
        if (this.getLabel() != null) {
            return this.getLabel().getText();
        }
        return "";
    }

    public void setText(String string) {
        if (string == null) {
            this.removeObject(this.dh);
        } else if (this.getLabel() == null) {
            this.setLabel(this.createLabel(string));
        } else {
            this.getLabel().setText(string);
        }
    }

    public JGoDrawable getDrawable() {
        return this.dc;
    }

    public void setDrawable(JGoDrawable jGoDrawable) {
        JGoDrawable jGoDrawable2 = this.dc;
        if (jGoDrawable2 != jGoDrawable) {
            JGoBasicNode.a(jGoDrawable2, jGoDrawable);
            if (jGoDrawable2 != null) {
                this.removeObject(jGoDrawable2);
            }
            this.dc = jGoDrawable;
            if (jGoDrawable != null) {
                if (jGoDrawable2 == null) {
                    jGoDrawable.setSelectable(false);
                    jGoDrawable.setResizable(false);
                }
                this.addObjectAtHead(jGoDrawable);
            }
            this.update(2102, 0, jGoDrawable2);
            if (this.getPort() != null && this.getPort().getPortObject() == jGoDrawable2) {
                this.getPort().setPortObject(jGoDrawable);
            }
        }
    }

    public JGoText getLabel() {
        return this.dh;
    }

    public void setLabel(JGoText jGoText) {
        JGoText jGoText2 = this.dh;
        if (jGoText2 != jGoText) {
            if (jGoText2 != null) {
                this.removeObject(jGoText2);
            }
            this.dh = jGoText;
            if (jGoText != null) {
                this.addObjectAtTail(jGoText);
            }
            this.update(2103, 0, jGoText2);
        }
    }

    public JGoPort getPort() {
        return this.dg;
    }

    public void setPort(JGoPort jGoPort) {
        JGoPort jGoPort2 = this.dg;
        if (jGoPort2 != jGoPort) {
            if (jGoPort2 != null) {
                this.removeObject(jGoPort2);
            }
            this.dg = jGoPort;
            if (jGoPort != null) {
                this.addObjectAtTail(jGoPort);
            }
            this.update(2104, 0, jGoPort2);
            if (jGoPort != null && jGoPort.getPortObject() == null) {
                jGoPort.setPortObject(this.getDrawable());
            }
        }
    }

    public void SVGUpdateReference(String string, Object object) {
        super.SVGUpdateReference(string, object);
        if (string.equals("drawable")) {
            this.dc = (JGoDrawable)object;
        } else if (string.equals("label")) {
            this.dh = (JGoText)object;
        } else if (string.equals("port")) {
            this.dg = (JGoPort)object;
        }
    }

    public void SVGWriteObject(DomDoc domDoc, DomElement domElement) {
        if (domDoc.JGoXMLOutputEnabled()) {
            DomElement domElement2 = domDoc.createJGoClassElement("com.nwoods.jgo.JGoBasicNode", domElement);
            domElement2.setAttribute("labelspot", Integer.toString(this.df));
            domElement2.setAttribute("insets_top", Integer.toString(this.de.top));
            domElement2.setAttribute("insets_right", Integer.toString(this.de.right));
            domElement2.setAttribute("insets_bottom", Integer.toString(this.de.bottom));
            domElement2.setAttribute("insets_left", Integer.toString(this.de.left));
            if (this.dc != null) {
                domDoc.registerReferencingNode(domElement2, "drawable", this.dc);
            }
            if (this.dh != null) {
                domDoc.registerReferencingNode(domElement2, "label", this.dh);
            }
            if (this.dg != null) {
                domDoc.registerReferencingNode(domElement2, "port", this.dg);
            }
        }
        super.SVGWriteObject(domDoc, domElement);
    }

    public DomNode SVGReadObject(DomDoc domDoc, JGoDocument jGoDocument, DomElement domElement, DomElement domElement2) {
        if (domElement2 != null) {
            String string;
            String string2;
            String string3;
            this.df = Integer.parseInt(domElement2.getAttribute("labelspot"));
            String string4 = domElement2.getAttribute("insets_top");
            if (string4.length() > 0) {
                this.de.top = Integer.parseInt(string4);
            }
            if ((string3 = domElement2.getAttribute("insets_right")).length() > 0) {
                this.de.right = Integer.parseInt(string3);
            }
            if ((string2 = domElement2.getAttribute("insets_bottom")).length() > 0) {
                this.de.bottom = Integer.parseInt(string2);
            }
            if ((string = domElement2.getAttribute("insets_left")).length() > 0) {
                this.de.left = Integer.parseInt(string);
            }
            String string5 = domElement2.getAttribute("drawable");
            domDoc.registerReferencingObject(this, "drawable", string5);
            String string6 = domElement2.getAttribute("label");
            domDoc.registerReferencingObject(this, "label", string6);
            String string7 = domElement2.getAttribute("port");
            domDoc.registerReferencingObject(this, "port", string7);
            super.SVGReadObject(domDoc, jGoDocument, domElement, domElement2.getNextSiblingJGoClassElement());
        }
        return domElement.getNextSibling();
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit jGoDocumentChangedEdit) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 2101: {
                jGoDocumentChangedEdit.setNewValueInt(this.getLabelSpot());
                return;
            }
            case 2102: {
                jGoDocumentChangedEdit.setNewValue(this.getDrawable());
                return;
            }
            case 2103: {
                jGoDocumentChangedEdit.setNewValue(this.getLabel());
                return;
            }
            case 2104: {
                jGoDocumentChangedEdit.setNewValue(this.getPort());
                return;
            }
            case 2105: {
                Insets insets = this.getInsets();
                jGoDocumentChangedEdit.setNewValue(new Insets(insets.top, insets.left, insets.bottom, insets.right));
                return;
            }
            case 2106: {
                jGoDocumentChangedEdit.setNewValueBoolean(this.isAutoResize());
                return;
            }
        }
        super.copyNewValueForRedo(jGoDocumentChangedEdit);
    }

    public void changeValue(JGoDocumentChangedEdit jGoDocumentChangedEdit, boolean bl) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 2101: {
                this.for(jGoDocumentChangedEdit.getValueInt(bl), true);
                return;
            }
            case 2102: {
                this.setDrawable((JGoDrawable)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
            case 2103: {
                this.setLabel((JGoText)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
            case 2104: {
                this.setPort((JGoPort)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
            case 2105: {
                this.a((Insets)jGoDocumentChangedEdit.getValue(bl), true);
                return;
            }
            case 2106: {
                this.do(jGoDocumentChangedEdit.getValueBoolean(bl), true);
                return;
            }
        }
        super.changeValue(jGoDocumentChangedEdit, bl);
    }
}

