/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoRectangle;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;

public abstract class JGoDrawable
extends JGoObject {
    private JGoPen b9 = JGoPen.black;
    private JGoBrush ca = null;

    public JGoDrawable() {
    }

    public JGoDrawable(Rectangle rectangle) {
        super(rectangle);
    }

    public JGoDrawable(Point point, Dimension dimension) {
        super(point, dimension);
    }

    public JGoObject copyObject(JGoCopyEnvironment jGoCopyEnvironment) {
        JGoDrawable jGoDrawable = (JGoDrawable)super.copyObject(jGoCopyEnvironment);
        if (jGoDrawable != null) {
            jGoDrawable.b9 = this.b9;
            jGoDrawable.ca = this.ca;
        }
        return jGoDrawable;
    }

    public void setPen(JGoPen jGoPen) {
        JGoPen jGoPen2 = this.b9;
        if (jGoPen2 != jGoPen) {
            this.update();
            this.b9 = jGoPen;
            this.update(11, 0, jGoPen2);
        }
    }

    public JGoPen getPen() {
        return this.b9;
    }

    public void setBrush(JGoBrush jGoBrush) {
        JGoBrush jGoBrush2 = this.ca;
        if (jGoBrush2 != jGoBrush) {
            this.ca = jGoBrush;
            this.update(12, 0, jGoBrush2);
        }
    }

    public JGoBrush getBrush() {
        return this.ca;
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit jGoDocumentChangedEdit) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 11: {
                jGoDocumentChangedEdit.setNewValue(this.getPen());
                return;
            }
            case 12: {
                jGoDocumentChangedEdit.setNewValue(this.getBrush());
                return;
            }
        }
        super.copyNewValueForRedo(jGoDocumentChangedEdit);
    }

    public void changeValue(JGoDocumentChangedEdit jGoDocumentChangedEdit, boolean bl) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 11: {
                this.setPen((JGoPen)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
            case 12: {
                this.setBrush((JGoBrush)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
        }
        super.changeValue(jGoDocumentChangedEdit, bl);
    }

    public void expandRectByPenWidth(Rectangle rectangle) {
        if (this.getPen() != null) {
            int n = this.getPen().getWidth();
            rectangle.x -= n;
            rectangle.y -= n;
            rectangle.width += n * 2;
            rectangle.height += n * 2;
        }
    }

    public boolean getNearestIntersectionPoint(int n, int n2, int n3, int n4, Point point) {
        Rectangle rectangle = this.getBoundingRect();
        int n5 = 1;
        if (this.getPen() != null) {
            n5 = this.getPen().getWidth();
        }
        return JGoRectangle.getNearestIntersectionPoint(rectangle.x - n5, rectangle.y - n5, rectangle.width + 2 * n5, rectangle.height + 2 * n5, n, n2, n3, n4, point);
    }

    public void SVGWriteObject(DomDoc domDoc, DomElement domElement) {
        if (domDoc.JGoXMLOutputEnabled()) {
            DomElement domElement2;
            DomElement domElement3 = domDoc.createJGoClassElement("com.nwoods.jgo.JGoDrawable", domElement);
            if (this.getBrush() != null) {
                if (!domDoc.isRegisteredReference(this.getBrush())) {
                    domElement3.setAttribute("embeddedpenbrush", "true");
                    domElement2 = domDoc.createElement("g");
                    domElement3.appendChild(domElement2);
                    this.getBrush().SVGWriteObject(domDoc, domElement2);
                }
                domDoc.registerReferencingNode(domElement3, "drawablebrush", this.getBrush());
            }
            if (this.getPen() != null) {
                if (!domDoc.isRegisteredReference(this.getPen())) {
                    domElement3.setAttribute("embeddedpenbrush", "true");
                    domElement2 = domDoc.createElement("g");
                    domElement3.appendChild(domElement2);
                    this.getPen().SVGWriteObject(domDoc, domElement2);
                }
                domDoc.registerReferencingNode(domElement3, "drawablepen", this.getPen());
            }
        }
        super.SVGWriteObject(domDoc, domElement);
    }

    public DomNode SVGReadObject(DomDoc domDoc, JGoDocument jGoDocument, DomElement domElement, DomElement domElement2) {
        if (domElement2 != null) {
            if (domElement2.getAttribute("embeddedpenbrush").equals("true")) {
                domDoc.SVGTraverseChildren(jGoDocument, domElement2, null, false);
            }
            String string = domElement2.getAttribute("drawablepen");
            domDoc.registerReferencingObject(this, "drawablepen", string);
            String string2 = domElement2.getAttribute("drawablebrush");
            if (string2.length() > 0) {
                domDoc.registerReferencingObject(this, "drawablebrush", string2);
            } else {
                this.setBrush(null);
            }
            super.SVGReadObject(domDoc, jGoDocument, domElement, domElement2.getNextSiblingJGoClassElement());
        }
        return domElement.getNextSibling();
    }

    public void SVGWriteAttributes(DomElement domElement) {
        JGoBrush jGoBrush;
        JGoPen jGoPen = this.getPen();
        if (jGoPen != null) {
            jGoPen.SVGWriteAttributes(domElement);
        }
        if ((jGoBrush = this.getBrush()) != null) {
            jGoBrush.SVGWriteAttributes(domElement);
        } else {
            String string = domElement.getAttribute("style");
            string = string + "fill:none;";
            domElement.setAttribute("style", string);
        }
    }

    public void SVGReadAttributes(DomElement domElement) {
        this.setPen(new JGoPen());
        this.getPen().SVGReadAttributes(domElement);
        this.setBrush(new JGoBrush());
        this.getBrush().SVGReadAttributes(domElement);
    }

    public void SVGUpdateReference(String string, Object object) {
        super.SVGUpdateReference(string, object);
        if (string.equals("drawablepen")) {
            this.setPen((JGoPen)object);
        } else if (string.equals("drawablebrush")) {
            this.setBrush((JGoBrush)object);
        }
    }

    public static void drawLine(Graphics2D graphics2D, JGoPen jGoPen, int n, int n2, int n3, int n4) {
        if (jGoPen != null && jGoPen.getStyle() != 0) {
            Stroke stroke = jGoPen.getStroke();
            if (stroke == null) {
                return;
            }
            graphics2D.setStroke(stroke);
            graphics2D.setColor(jGoPen.getColor());
            graphics2D.drawLine(n, n2, n3, n4);
        }
    }

    public void drawLine(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        JGoDrawable.drawLine(graphics2D, this.getPen(), n, n2, n3, n4);
    }

    public static void drawEllipse(Graphics2D graphics2D, JGoPen jGoPen, JGoBrush jGoBrush, int n, int n2, int n3, int n4) {
        Object object;
        if (jGoBrush != null && (object = jGoBrush.getPaint()) != null) {
            graphics2D.setPaint((Paint)object);
            graphics2D.fillOval(n, n2, n3, n4);
        }
        if (jGoPen != null && (object = jGoPen.getStroke()) != null) {
            graphics2D.setStroke((Stroke)object);
            graphics2D.setColor(jGoPen.getColor());
            graphics2D.drawOval(n, n2, n3, n4);
        }
    }

    public void drawEllipse(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        JGoDrawable.drawEllipse(graphics2D, this.getPen(), this.getBrush(), n, n2, n3, n4);
    }

    public void drawEllipse(Graphics2D graphics2D, Rectangle rectangle) {
        JGoDrawable.drawEllipse(graphics2D, this.getPen(), this.getBrush(), rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static void drawRect(Graphics2D graphics2D, JGoPen jGoPen, JGoBrush jGoBrush, int n, int n2, int n3, int n4) {
        Object object;
        if (jGoBrush != null && (object = jGoBrush.getPaint()) != null) {
            graphics2D.setPaint((Paint)object);
            graphics2D.fillRect(n, n2, n3, n4);
        }
        if (jGoPen != null && (object = jGoPen.getStroke()) != null) {
            graphics2D.setStroke((Stroke)object);
            graphics2D.setColor(jGoPen.getColor());
            graphics2D.drawRect(n, n2, n3, n4);
        }
    }

    public void drawRect(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        JGoDrawable.drawRect(graphics2D, this.getPen(), this.getBrush(), n, n2, n3, n4);
    }

    public void drawRect(Graphics2D graphics2D, Rectangle rectangle) {
        JGoDrawable.drawRect(graphics2D, this.getPen(), this.getBrush(), rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static void drawRoundRect(Graphics2D graphics2D, JGoPen jGoPen, JGoBrush jGoBrush, int n, int n2, int n3, int n4, int n5, int n6) {
        Object object;
        if (jGoBrush != null && (object = jGoBrush.getPaint()) != null) {
            graphics2D.setPaint((Paint)object);
            graphics2D.fillRoundRect(n, n2, n3, n4, n5, n6);
        }
        if (jGoPen != null && jGoPen.getStyle() != 0 && (object = jGoPen.getStroke()) != null) {
            graphics2D.setStroke((Stroke)object);
            graphics2D.setColor(jGoPen.getColor());
            graphics2D.drawRoundRect(n, n2, n3, n4, n5, n6);
        }
    }

    public void drawRoundRect(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        JGoDrawable.drawRoundRect(graphics2D, this.getPen(), this.getBrush(), n, n2, n3, n4, n5, n6);
    }

    public static void draw3DRect(Graphics2D graphics2D, JGoPen jGoPen, JGoBrush jGoBrush, int n, int n2, int n3, int n4, boolean bl) {
        Object object;
        if (jGoBrush != null && (object = jGoBrush.getPaint()) != null) {
            graphics2D.setPaint((Paint)object);
            graphics2D.fill3DRect(n, n2, n3, n4, bl);
        }
        if (jGoPen != null && jGoPen.getStyle() == 65535 && (object = jGoPen.getStroke()) != null) {
            graphics2D.setStroke((Stroke)object);
            graphics2D.setColor(jGoPen.getColor());
            graphics2D.draw3DRect(n, n2, n3, n4, bl);
        }
    }

    public void draw3DRect(Graphics2D graphics2D, int n, int n2, int n3, int n4, boolean bl) {
        JGoDrawable.draw3DRect(graphics2D, this.getPen(), this.getBrush(), n, n2, n3, n4, bl);
    }

    public static void drawPolygon(Graphics2D graphics2D, JGoPen jGoPen, JGoBrush jGoBrush, int[] nArray, int[] nArray2, int n) {
        Object object;
        if (jGoBrush != null && (object = jGoBrush.getPaint()) != null) {
            graphics2D.setPaint((Paint)object);
            graphics2D.fillPolygon(nArray, nArray2, n);
        }
        if (jGoPen != null && (object = jGoPen.getStroke()) != null) {
            graphics2D.setStroke((Stroke)object);
            graphics2D.setColor(jGoPen.getColor());
            graphics2D.drawPolygon(nArray, nArray2, n);
        }
    }

    public void drawPolygon(Graphics2D graphics2D, int[] nArray, int[] nArray2, int n) {
        JGoDrawable.drawPolygon(graphics2D, this.getPen(), this.getBrush(), nArray, nArray2, n);
    }

    public static void drawPath(Graphics2D graphics2D, JGoPen jGoPen, JGoBrush jGoBrush, GeneralPath generalPath) {
        Object object;
        if (jGoBrush != null && (object = jGoBrush.getPaint()) != null) {
            graphics2D.setPaint((Paint)object);
            graphics2D.fill(generalPath);
        }
        if (jGoPen != null && (object = jGoPen.getStroke()) != null) {
            graphics2D.setStroke((Stroke)object);
            graphics2D.setColor(jGoPen.getColor());
            graphics2D.draw(generalPath);
        }
    }

    public static void SVGAddPathArgs(DomElement domElement, GeneralPath generalPath) {
        String string = "";
        Point point = null;
        Point point2 = null;
        Point point3 = null;
        PathIterator pathIterator = generalPath.getPathIterator(null);
        while (!pathIterator.isDone()) {
            double[] dArray = new double[6];
            switch (pathIterator.currentSegment(dArray)) {
                case 0: {
                    point = new Point((int)dArray[0], (int)dArray[1]);
                    string = string + " M";
                    string = string + " " + Integer.toString(point.x);
                    string = string + " " + Integer.toString(point.y);
                    break;
                }
                case 1: {
                    point = new Point((int)dArray[0], (int)dArray[1]);
                    string = string + " L ";
                    string = string + " " + Integer.toString(point.x);
                    string = string + " " + Integer.toString(point.y);
                    break;
                }
                case 2: {
                    point = new Point((int)dArray[0], (int)dArray[1]);
                    point2 = new Point((int)dArray[2], (int)dArray[3]);
                    string = string + " Q ";
                    string = string + " " + Integer.toString(point.x);
                    string = string + " " + Integer.toString(point.y);
                    string = string + " " + Integer.toString(point2.x);
                    string = string + " " + Integer.toString(point2.y);
                    break;
                }
                case 3: {
                    point = new Point((int)dArray[0], (int)dArray[1]);
                    point2 = new Point((int)dArray[2], (int)dArray[3]);
                    point3 = new Point((int)dArray[4], (int)dArray[5]);
                    string = string + " C ";
                    string = string + " " + Integer.toString(point.x);
                    string = string + " " + Integer.toString(point.y);
                    string = string + " " + Integer.toString(point2.x);
                    string = string + " " + Integer.toString(point2.y);
                    string = string + " " + Integer.toString(point3.x);
                    string = string + " " + Integer.toString(point3.y);
                }
            }
            domElement.setAttribute("d", string);
            pathIterator.next();
        }
    }
}

