/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDrawable;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoStroke;
import com.nwoods.jgo.JGoView;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

public class JGoEllipse
extends JGoDrawable {
    public JGoEllipse() {
    }

    public JGoEllipse(Rectangle rectangle) {
        super(rectangle);
    }

    public JGoEllipse(Point point, Dimension dimension) {
        super(point, dimension);
    }

    public JGoObject copyObject(JGoCopyEnvironment jGoCopyEnvironment) {
        JGoEllipse jGoEllipse = (JGoEllipse)super.copyObject(jGoCopyEnvironment);
        if (jGoEllipse != null) {
            // empty if block
        }
        return jGoEllipse;
    }

    public void SVGWriteObject(DomDoc domDoc, DomElement domElement) {
        DomElement domElement2;
        if (domDoc.JGoXMLOutputEnabled()) {
            domElement2 = domDoc.createJGoClassElement("com.nwoods.jgo.JGoEllipse", domElement);
        }
        if (domDoc.SVGOutputEnabled()) {
            domElement2 = domDoc.createElement("ellipse");
            this.SVGWriteAttributes(domElement2);
            domElement.appendChild(domElement2);
        }
        super.SVGWriteObject(domDoc, domElement);
    }

    public DomNode SVGReadObject(DomDoc domDoc, JGoDocument jGoDocument, DomElement domElement, DomElement domElement2) {
        if (domElement2 != null) {
            super.SVGReadObject(domDoc, jGoDocument, domElement, domElement2.getNextSiblingJGoClassElement());
        } else if (domElement.getTagName().equalsIgnoreCase("ellipse")) {
            this.SVGReadAttributes(domElement);
        } else if (domElement.getTagName().equalsIgnoreCase("circle")) {
            this.SVGReadAttributes(domElement);
        }
        return domElement.getNextSibling();
    }

    public void SVGWriteAttributes(DomElement domElement) {
        super.SVGWriteAttributes(domElement);
        int n = this.getTopLeft().x + this.getWidth() / 2;
        int n2 = this.getTopLeft().y + this.getHeight() / 2;
        int n3 = this.getWidth() / 2;
        int n4 = this.getHeight() / 2;
        domElement.setAttribute("rx", Integer.toString(n3));
        domElement.setAttribute("ry", Integer.toString(n4));
        domElement.setAttribute("cx", Integer.toString(n));
        domElement.setAttribute("cy", Integer.toString(n2));
    }

    public void SVGReadAttributes(DomElement domElement) {
        super.SVGReadAttributes(domElement);
        String string = domElement.getAttribute("cx");
        String string2 = domElement.getAttribute("cy");
        String string3 = domElement.getAttribute("rx");
        String string4 = domElement.getAttribute("ry");
        String string5 = domElement.getAttribute("r");
        if (string5.length() > 0) {
            string3 = string5;
            string4 = string5;
        }
        int n = new Double(string).intValue() - new Double(string3).intValue();
        int n2 = new Double(string2).intValue() - new Double(string4).intValue();
        int n3 = new Double(string3).intValue() * 2;
        int n4 = new Double(string4).intValue() * 2;
        this.setTopLeft(new Point(n, n2));
        this.setWidth(n3);
        this.setHeight(n4);
    }

    public void paint(Graphics2D graphics2D, JGoView jGoView) {
        this.drawEllipse(graphics2D, this.getBoundingRect());
    }

    public boolean isPointInObj(Point point) {
        if (!super.isPointInObj(point)) {
            return false;
        }
        double d = (double)this.getWidth() / 2.0;
        double d2 = (double)point.x - ((double)this.getLeft() + d);
        double d3 = (double)this.getHeight() / 2.0;
        double d4 = (double)point.y - ((double)this.getTop() + d3);
        return d2 * d2 / (d * d) + d4 * d4 / (d3 * d3) <= 1.0;
    }

    public static boolean getNearestIntersectionPoint(int n, int n2, int n3, int n4, int n5, int n6, Point point) {
        double d = (double)n3 / 2.0;
        double d2 = (double)n4 / 2.0;
        double d3 = (double)n + d;
        double d4 = (double)n2 + d2;
        double d5 = (double)n5 - d3;
        double d6 = (double)n6 - d4;
        double d7 = d * d;
        double d8 = d2 * d2;
        if (-0.01 < d5 && d5 < 0.01) {
            d5 = 0.01;
        }
        if (-0.01 < d6 && d6 < 0.01) {
            d6 = 0.01;
        }
        double d9 = d6 * d6 / (d5 * d5);
        double d10 = Math.sqrt(d7 * d8 / (d8 + d7 * d9));
        double d11 = Math.abs(d10 * d6 / d5);
        point.x = (int)Math.rint(d5 > 0.0 ? d3 + d10 : d3 - d10);
        point.y = (int)Math.rint(d6 > 0.0 ? d4 + d11 : d4 - d11);
        return true;
    }

    public static boolean getNearestIntersectionPoint(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Point point) {
        if (n3 == 0) {
            return JGoStroke.getNearestIntersectionOnLine(n, n2, n, n2 + n4, n5, n6, n7, n8, point);
        }
        if (n4 == 0) {
            return JGoStroke.getNearestIntersectionOnLine(n, n2, n + n3, n2, n5, n6, n7, n8, point);
        }
        double d = n5;
        double d2 = n6;
        double d3 = n7;
        double d4 = n8;
        double d5 = n3 / 2;
        double d6 = n4 / 2;
        double d7 = (double)n + d5;
        double d8 = (double)n2 + d6;
        if (d != d3) {
            double d9;
            double d10;
            double d11 = d > d3 ? (d2 - d4) / (d - d3) : (d4 - d2) / (d3 - d);
            if (d5 * d5 * (d11 * d11) + d6 * d6 - (d10 = d2 - d8 - d11 * (d - d7)) * d10 < 0.0) {
                point.x = 0;
                point.y = 0;
                return false;
            }
            double d12 = Math.sqrt(d5 * d5 * (d11 * d11) + d6 * d6 - d10 * d10);
            double d13 = (-(d5 * d5 * d11 * d10) + d5 * d6 * d12) / (d6 * d6 + d5 * d5 * (d11 * d11)) + d7;
            double d14 = (-(d5 * d5 * d11 * d10) - d5 * d6 * d12) / (d6 * d6 + d5 * d5 * (d11 * d11)) + d7;
            double d15 = d11 * (d13 - d7) + d10 + d8;
            double d16 = d11 * (d14 - d7) + d10 + d8;
            double d17 = Math.abs((d - d13) * (d - d13)) + Math.abs((d2 - d15) * (d2 - d15));
            if (d17 < (d9 = Math.abs((d - d14) * (d - d14)) + Math.abs((d2 - d16) * (d2 - d16)))) {
                point.x = Math.round((float)d13);
                point.y = Math.round((float)d15);
            } else {
                point.x = Math.round((float)d14);
                point.y = Math.round((float)d16);
            }
        } else {
            double d18;
            double d19 = Math.sqrt(d6 * d6 - d6 * d6 / (d5 * d5) * ((d - d7) * (d - d7)));
            double d20 = d8 + d19;
            double d21 = d8 - d19;
            double d22 = Math.abs(d20 - d2);
            if (d22 < (d18 = Math.abs(d21 - d2))) {
                point.x = n5;
                point.y = Math.round((float)d20);
            } else {
                point.x = n5;
                point.y = Math.round((float)d21);
            }
        }
        return true;
    }

    public boolean getNearestIntersectionPoint(int n, int n2, int n3, int n4, Point point) {
        Rectangle rectangle = this.getBoundingRect();
        int n5 = 1;
        if (this.getPen() != null) {
            n5 = this.getPen().getWidth();
        }
        return JGoEllipse.getNearestIntersectionPoint(rectangle.x - n5, rectangle.y - n5, rectangle.width + 2 * n5, rectangle.height + 2 * n5, n, n2, n3, n4, point);
    }
}

