/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoOverviewRectangle;
import com.nwoods.jgo.JGoView;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.event.MouseEvent;

public class JGoOverview
extends JGoView {
    private JGoView bw = null;
    private JGoOverviewRectangle bx = null;

    public JGoOverview() {
        this.setHidingDisabledScrollbars(true);
        this.setInternalMouseActions(2);
        this.setScale(0.125);
    }

    public void removeNotify() {
        this.e();
        this.bw = null;
        super.removeNotify();
    }

    private void e() {
        if (this.bw != null && this.bx != null) {
            this.bw.getDocument().removeDocumentListener(this);
            this.bw.removeViewListener(this.bx);
            this.bw.getCanvas().removeComponentListener(this.bx);
        }
    }

    public void setObserved(JGoView jGoView) {
        if (jGoView instanceof JGoOverview) {
            return;
        }
        JGoView jGoView2 = this.bw;
        if (jGoView2 != jGoView) {
            this.e();
            this.bw = jGoView;
            if (this.bw != null) {
                if (this.bx == null) {
                    this.bx = new JGoOverviewRectangle(this.bw.getViewPosition(), this.bw.getExtentSize());
                    this.addObjectAtTail(this.bx);
                } else {
                    this.bx.setBoundingRect(this.bw.getViewRect());
                }
                this.bw.getDocument().addDocumentListener(this);
                this.bw.addViewListener(this.bx);
                this.bw.getCanvas().addComponentListener(this.bx);
                this.firePropertyChange("observed", jGoView2, jGoView);
                this.updateView();
            }
        }
    }

    public JGoView getObserved() {
        return this.bw;
    }

    public boolean isDropFlavorAcceptable(DropTargetDragEvent dropTargetDragEvent) {
        return false;
    }

    public int computeAcceptableDrop(DropTargetDragEvent dropTargetDragEvent) {
        return 0;
    }

    public JGoOverviewRectangle getOverviewRect() {
        return this.bx;
    }

    public JGoObject pickDocObject(Point point, boolean bl) {
        if (this.getOverviewRect() != null && this.getOverviewRect().isPointInObj(point)) {
            return this.getOverviewRect();
        }
        return null;
    }

    public void selectInBox(Rectangle rectangle) {
    }

    public void doBackgroundClick(int n, Point point, Point point2) {
        if (this.getOverviewRect() != null) {
            Rectangle rectangle = this.getOverviewRect().getBoundingRect();
            this.getOverviewRect().setTopLeft(point.x - rectangle.width / 2, point.y - rectangle.height / 2);
        }
    }

    public JGoDocument getDocument() {
        if (this.getObserved() != null) {
            return this.getObserved().getDocument();
        }
        return super.getDocument();
    }

    public Dimension getDocumentSize() {
        if (this.getDocument() != null) {
            return this.getDocument().getDocumentSize();
        }
        return new Dimension();
    }

    public boolean isIncludingNegativeCoords() {
        if (this.getObserved() != null) {
            return this.getObserved().isIncludingNegativeCoords();
        }
        return false;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.getObserved() == null) {
            return null;
        }
        Point point = this.a(mouseEvent);
        this.convertViewToDoc(point);
        for (JGoObject jGoObject = this.getObserved().pickDocObject(point, false); jGoObject != null; jGoObject = jGoObject.getParent()) {
            String string = jGoObject.getToolTipText();
            if (string == null) continue;
            return string;
        }
        return null;
    }
}

