/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoXMLSaveRestore;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.io.Serializable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JGoPen
implements Serializable,
JGoXMLSaveRestore {
    public static final int NONE = 0;
    public static final int SOLID = 65535;
    public static final int DASHED = 1;
    public static final int DOTTED = 2;
    public static final int DASHDOT = 3;
    public static final int DASHDOTDOT = 4;
    public static final int CUSTOM = 65534;
    public static final JGoPen black = new JGoPen(65535, 1, JGoBrush.ColorBlack);
    public static final JGoPen darkGray = new JGoPen(65535, 1, JGoBrush.ColorDarkGray);
    public static final JGoPen gray = new JGoPen(65535, 1, JGoBrush.ColorGray);
    public static final JGoPen lightGray = new JGoPen(65535, 1, JGoBrush.ColorLightGray);
    public static final JGoPen white = new JGoPen(65535, 1, JGoBrush.ColorWhite);
    public static final JGoPen red = new JGoPen(65535, 1, JGoBrush.ColorRed);
    public static final JGoPen magenta = new JGoPen(65535, 1, JGoBrush.ColorMagenta);
    public static final JGoPen yellow = new JGoPen(65535, 1, JGoBrush.ColorYellow);
    public static final JGoPen green = new JGoPen(65535, 1, JGoBrush.ColorGreen);
    public static final JGoPen cyan = new JGoPen(65535, 1, JGoBrush.ColorCyan);
    public static final JGoPen blue = new JGoPen(65535, 1, JGoBrush.ColorBlue);
    public static final JGoPen orange = new JGoPen(65535, 1, JGoBrush.ColorOrange);
    public static final JGoPen pink = new JGoPen(65535, 1, JGoBrush.ColorPink);
    public static final JGoPen Null = new JGoPen(0, 1, JGoBrush.ColorBlack);
    private int new;
    private int for;
    private Color int;
    private transient Stroke try = null;

    public JGoPen() {
        this.new = 65535;
        this.for = 1;
        this.int = JGoBrush.ColorBlack;
        this.try = null;
    }

    public JGoPen(int n, int n2, Color color) {
        this.new = n;
        this.for = n == 0 ? 0 : Math.max(n2, 1);
        this.int = color;
        this.try = null;
    }

    public JGoPen(Stroke stroke, Color color) {
        this.new = 65534;
        this.for = stroke != null && stroke instanceof BasicStroke ? (int)((BasicStroke)stroke).getLineWidth() : 1;
        this.int = color;
        this.try = stroke;
    }

    public static JGoPen makeStockPen(Color color) {
        if (color.equals(JGoBrush.ColorBlack)) {
            return black;
        }
        if (color.equals(JGoBrush.ColorDarkGray)) {
            return darkGray;
        }
        if (color.equals(JGoBrush.ColorGray)) {
            return gray;
        }
        if (color.equals(JGoBrush.ColorLightGray)) {
            return lightGray;
        }
        if (color.equals(JGoBrush.ColorWhite)) {
            return white;
        }
        if (color.equals(JGoBrush.ColorRed)) {
            return red;
        }
        if (color.equals(JGoBrush.ColorMagenta)) {
            return magenta;
        }
        if (color.equals(JGoBrush.ColorYellow)) {
            return yellow;
        }
        if (color.equals(JGoBrush.ColorGreen)) {
            return green;
        }
        if (color.equals(JGoBrush.ColorCyan)) {
            return cyan;
        }
        if (color.equals(JGoBrush.ColorBlue)) {
            return blue;
        }
        if (color.equals(JGoBrush.ColorOrange)) {
            return orange;
        }
        if (color.equals(JGoBrush.ColorPink)) {
            return pink;
        }
        return new JGoPen(65535, 1, color);
    }

    public static JGoPen make(int n, int n2, Color color) {
        if (n == 0) {
            return Null;
        }
        if (n == 65535 && n2 == 1) {
            return JGoPen.makeStockPen(color);
        }
        return new JGoPen(n, n2, color);
    }

    public int getStyle() {
        return this.new;
    }

    public int getWidth() {
        return this.for;
    }

    public Color getColor() {
        return this.int;
    }

    public Stroke getStroke() {
        if (this.try == null) {
            switch (this.getStyle()) {
                default: {
                    this.try = null;
                    break;
                }
                case 65535: {
                    int n = this.getWidth();
                    this.try = new BasicStroke(n, 0, 0, 10.0f);
                    break;
                }
                case 1: {
                    float f = this.getWidth();
                    float[] fArray = new float[]{3.0f * f, f};
                    this.try = new BasicStroke(f, 0, 0, 10.0f, fArray, 0.0f);
                    break;
                }
                case 2: {
                    float f = this.getWidth();
                    float[] fArray = new float[]{f, f};
                    this.try = new BasicStroke(f, 0, 0, 10.0f, fArray, 0.0f);
                    break;
                }
                case 3: {
                    float f = this.getWidth();
                    float[] fArray = new float[]{3.0f * f, f, f, f};
                    this.try = new BasicStroke(f, 0, 0, 10.0f, fArray, 0.0f);
                    break;
                }
                case 4: {
                    float f = this.getWidth();
                    float[] fArray = new float[]{3.0f * f, f, f, f, f, f};
                    this.try = new BasicStroke(f, 0, 0, 10.0f, fArray, 0.0f);
                }
            }
        }
        return this.try;
    }

    public void SVGWriteObject(DomDoc domDoc, DomElement domElement) {
        if (domDoc.JGoXMLOutputEnabled()) {
            DomElement domElement2 = domDoc.createJGoClassElement("com.nwoods.jgo.JGoPen", domElement);
            this.do(domElement2);
            domDoc.registerObject(this, domElement2);
        }
    }

    public DomNode SVGReadObject(DomDoc domDoc, JGoDocument jGoDocument, DomElement domElement, DomElement domElement2) {
        if (domElement2 != null) {
            this.for(domElement2);
            String string = domElement2.getAttribute("id");
            if (string.length() > 0) {
                domDoc.registerTag(string, this);
            }
        }
        return domElement.getNextSibling();
    }

    public void SVGWriteAttributes(DomElement domElement) {
        String string = "";
        if (this.getStyle() == 0) {
            string = "stroke:none;";
        } else {
            int n = this.getWidth();
            string = "stroke-width:" + Integer.toString(n) + ";";
            if (this.getStyle() == 1) {
                string = string + "stroke-dasharray:" + Integer.toString(n * 3) + "," + Integer.toString(n) + ";";
            } else if (this.getStyle() == 2) {
                string = string + "stroke-dasharray:" + Integer.toString(n) + "," + Integer.toString(n) + ";";
            } else if (this.getStyle() == 3) {
                string = string + "stroke-dasharray:" + Integer.toString(n * 3) + "," + Integer.toString(n) + "," + Integer.toString(n) + "," + Integer.toString(n) + ";";
            } else if (this.getStyle() == 4) {
                string = string + "stroke-dasharray:" + Integer.toString(n * 3) + "," + Integer.toString(n) + "," + Integer.toString(n) + "," + Integer.toString(n) + "," + Integer.toString(n) + "," + Integer.toString(n) + ";";
            }
            Color color = this.getColor();
            if (color == Color.black) {
                string = string + "stroke:black;";
            } else {
                int n2 = color.getRed();
                int n3 = color.getGreen();
                int n4 = color.getBlue();
                string = string + "stroke:rgb(" + Integer.toString(n2) + "," + Integer.toString(n3) + "," + Integer.toString(n4) + ");";
            }
        }
        String string2 = domElement.getAttribute("style");
        string2 = string2 + string;
        domElement.setAttribute("style", string2);
    }

    public void SVGReadAttributes(DomElement domElement) {
        Object object;
        String string = domElement.getAttribute("style");
        String string2 = domElement.getSubAttribute(string, "stroke-width");
        String string3 = domElement.getSubAttribute(string, "stroke");
        String string4 = domElement.getSubAttribute(string, "stroke-dasharray");
        for (DomNode domNode = domElement.getParentNode(); domNode != null; domNode = domNode.getParentNode()) {
            if (!domNode.isElement()) continue;
            DomElement domElement2 = domNode.elementCast();
            object = domElement2.getAttribute("style");
            if (string2.length() == 0) {
                string2 = domElement2.getSubAttribute((String)object, "stroke-width");
            }
            if (string3.length() == 0) {
                string3 = domElement2.getSubAttribute((String)object, "stroke");
            }
            if (string4.length() != 0) continue;
            string4 = domElement2.getSubAttribute((String)object, "stroke-dasharray");
        }
        int n = 1;
        if (string2.length() > 0) {
            n = Integer.parseInt(string2);
        }
        int n2 = 65535;
        object = JGoBrush.ColorBlack;
        if (string3.length() > 0) {
            if (string3.equals("none")) {
                n2 = 0;
            } else if (string3.equalsIgnoreCase("black")) {
                object = JGoBrush.ColorBlack;
            } else if (string3.equalsIgnoreCase("darkGray")) {
                object = JGoBrush.ColorDarkGray;
            } else if (string3.equalsIgnoreCase("gray")) {
                object = JGoBrush.ColorGray;
            } else if (string3.equalsIgnoreCase("lightGray")) {
                object = JGoBrush.ColorLightGray;
            } else if (string3.equalsIgnoreCase("white")) {
                object = JGoBrush.ColorWhite;
            } else if (string3.equalsIgnoreCase("red")) {
                object = JGoBrush.ColorRed;
            } else if (string3.equalsIgnoreCase("magenta")) {
                object = JGoBrush.ColorMagenta;
            } else if (string3.equalsIgnoreCase("yellow")) {
                object = JGoBrush.ColorYellow;
            } else if (string3.equalsIgnoreCase("green")) {
                object = JGoBrush.ColorGreen;
            } else if (string3.equalsIgnoreCase("cyan")) {
                object = JGoBrush.ColorCyan;
            } else if (string3.equalsIgnoreCase("blue")) {
                object = JGoBrush.ColorBlue;
            } else if (string3.equalsIgnoreCase("orange")) {
                object = JGoBrush.ColorOrange;
            } else if (string3.equalsIgnoreCase("pink")) {
                object = JGoBrush.ColorPink;
            } else if (string3.startsWith("rgb")) {
                int n3 = string3.indexOf("(") + 1;
                int n4 = string3.indexOf(",", n3);
                String string5 = string3.substring(n3, n4);
                n3 = n4 + 1;
                n4 = string3.indexOf(",", n3);
                String string6 = string3.substring(n3, n4);
                n3 = n4 + 1;
                n4 = string3.indexOf(")", n3);
                String string7 = string3.substring(n3, n4);
                object = new Color(Integer.parseInt(string5), Integer.parseInt(string6), Integer.parseInt(string7));
            }
        }
        this.new = n2;
        this.for = n;
        this.int = object;
    }

    private void do(DomElement domElement) {
        domElement.setAttribute("penstyle", Integer.toString(this.new));
        domElement.setAttribute("penwidth", Integer.toString(this.for));
        String string = "black";
        if (this.int == JGoBrush.ColorBlack) {
            string = "black";
        } else if (this.int == JGoBrush.ColorLightGray) {
            string = "lightGray";
        } else if (this.int == JGoBrush.ColorDarkGray) {
            string = "darkGray";
        } else if (this.int == JGoBrush.ColorGray) {
            string = "gray";
        } else if (this.int == JGoBrush.ColorWhite) {
            string = "white";
        } else if (this.int == JGoBrush.ColorRed) {
            string = "red";
        } else if (this.int == JGoBrush.ColorMagenta) {
            string = "magenta";
        } else if (this.int == JGoBrush.ColorYellow) {
            string = "yellow";
        } else if (this.int == JGoBrush.ColorGreen) {
            string = "green";
        } else if (this.int == JGoBrush.ColorCyan) {
            string = "cyan";
        } else if (this.int == JGoBrush.ColorBlue) {
            string = "blue";
        } else if (this.int == JGoBrush.ColorOrange) {
            string = "orange";
        } else if (this.int == JGoBrush.ColorPink) {
            string = "pink";
        } else {
            int n = this.int.getRed();
            int n2 = this.int.getGreen();
            int n3 = this.int.getBlue();
            int n4 = this.int.getAlpha();
            string = "rgbalpha(" + Integer.toString(n) + "," + Integer.toString(n2) + "," + Integer.toString(n3) + "," + Integer.toString(n4) + ")";
        }
        domElement.setAttribute("pencolor", string);
    }

    private void for(DomElement domElement) {
        String string = domElement.getAttribute("penstyle");
        this.new = Integer.parseInt(string);
        String string2 = domElement.getAttribute("penwidth");
        this.for = Integer.parseInt(string2);
        String string3 = domElement.getAttribute("pencolor");
        if (string3.equals("black")) {
            this.int = JGoBrush.ColorBlack;
        } else if (string3.equals("darkGray")) {
            this.int = JGoBrush.ColorDarkGray;
        } else if (string3.equals("gray")) {
            this.int = JGoBrush.ColorGray;
        } else if (string3.equals("lightGray")) {
            this.int = JGoBrush.ColorLightGray;
        } else if (string3.equals("white")) {
            this.int = JGoBrush.ColorWhite;
        } else if (string3.equals("red")) {
            this.int = JGoBrush.ColorRed;
        } else if (string3.equals("magenta")) {
            this.int = JGoBrush.ColorMagenta;
        } else if (string3.equals("yellow")) {
            this.int = JGoBrush.ColorYellow;
        } else if (string3.equals("green")) {
            this.int = JGoBrush.ColorGreen;
        } else if (string3.equals("cyan")) {
            this.int = JGoBrush.ColorCyan;
        } else if (string3.equals("blue")) {
            this.int = JGoBrush.ColorBlue;
        } else if (string3.equals("orange")) {
            this.int = JGoBrush.ColorOrange;
        } else if (string3.equals("pink")) {
            this.int = JGoBrush.ColorPink;
        } else if (string3.startsWith("rgbalpha")) {
            int n = string3.indexOf("(") + 1;
            int n2 = string3.indexOf(",", n);
            String string4 = string3.substring(n, n2);
            n = n2 + 1;
            n2 = string3.indexOf(",", n);
            String string5 = string3.substring(n, n2);
            n = n2 + 1;
            n2 = string3.indexOf(",", n);
            String string6 = string3.substring(n, n2);
            n = n2 + 1;
            n2 = string3.indexOf(")", n);
            String string7 = string3.substring(n, n2);
            this.int = new Color(Integer.parseInt(string4), Integer.parseInt(string5), Integer.parseInt(string6), Integer.parseInt(string7));
        }
    }
}

