/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoStroke;
import com.nwoods.jgo.JGoView;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;

public class JGoPolygon
extends JGoStroke {
    public JGoObject copyObject(JGoCopyEnvironment jGoCopyEnvironment) {
        JGoPolygon jGoPolygon = (JGoPolygon)super.copyObject(jGoCopyEnvironment);
        if (jGoPolygon != null) {
            // empty if block
        }
        return jGoPolygon;
    }

    public void SVGWriteObject(DomDoc domDoc, DomElement domElement) {
        DomElement domElement2;
        if (domDoc.JGoXMLOutputEnabled()) {
            domElement2 = domDoc.createJGoClassElement("com.nwoods.jgo.JGoPolygon", domElement);
        }
        if (domDoc.SVGOutputEnabled()) {
            domElement2 = domDoc.createElement("path");
            String string = "";
            int n = this.myPoints.size();
            if (n > 0) {
                Point point = (Point)this.myPoints.get(0);
                string = string + "M";
                string = string + " " + Integer.toString(point.x);
                string = string + " " + Integer.toString(point.y);
                for (int i = 1; i < this.myPoints.size(); ++i) {
                    point = (Point)this.myPoints.get(i);
                    string = string + " L " + Integer.toString(point.x);
                    string = string + " " + Integer.toString(point.y);
                }
                string = string + " Z";
                this.SVGWriteAttributes(domElement2);
                domElement2.setAttribute("d", string);
                domElement.appendChild(domElement2);
            }
        }
        domDoc.setDisabledDrawing(true);
        super.SVGWriteObject(domDoc, domElement);
    }

    public DomNode SVGReadObject(DomDoc domDoc, JGoDocument jGoDocument, DomElement domElement, DomElement domElement2) {
        if (domElement2 != null) {
            super.SVGReadObject(domDoc, jGoDocument, domElement, domElement2.getNextSiblingJGoClassElement());
        }
        return domElement.getNextSibling();
    }

    public void paint(Graphics2D graphics2D, JGoView jGoView) {
        int n = this.getNumPoints();
        if (n <= 1) {
            return;
        }
        GeneralPath generalPath = this.do(jGoView);
        JGoPen jGoPen = this.getHighlight();
        if (jGoPen != null) {
            JGoPolygon.drawPath(graphics2D, jGoPen, null, generalPath);
        }
        JGoPolygon.drawPath(graphics2D, this.getPen(), this.getBrush(), generalPath);
    }

    public boolean isPointInObj(Point point) {
        int n;
        Rectangle rectangle = this.getBoundingRect();
        int n2 = n = this.getPen() != null ? this.getPen().getWidth() : 1;
        if (point.x < rectangle.x - n || point.x > rectangle.x + rectangle.width + n || point.y < rectangle.y - n || point.y > rectangle.y + rectangle.height + n) {
            return false;
        }
        int n3 = this.getNumPoints();
        if (n3 <= 1) {
            return false;
        }
        GeneralPath generalPath = this.do(null);
        return generalPath.contains(point.x, point.y);
    }

    void a(GeneralPath generalPath, JGoView jGoView) {
        super.a(generalPath, jGoView);
        generalPath.closePath();
    }
}

