/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.JGoView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.border.MatteBorder;

public class JGoPrintPreview
extends JDialog {
    protected int m_wPage;
    protected int m_hPage;
    protected int m_orientation;
    protected Printable m_target;
    protected JComboBox m_cbScale;
    protected PreviewContainer m_preview;
    protected PageFormat m_pageFormat;
    protected int m_pageCount;

    public JGoPrintPreview(Dialog dialog, Printable printable, String string, PageFormat pageFormat, int n) {
        super(dialog, string, true);
        this.a(printable, pageFormat, n);
    }

    public JGoPrintPreview(Frame frame, Printable printable, String string, PageFormat pageFormat, int n) {
        super(frame, string, true);
        this.a(printable, pageFormat, n);
    }

    private void a(Printable printable, PageFormat pageFormat, int n) {
        this.m_pageFormat = pageFormat;
        this.m_pageCount = n;
        this.setSize(600, 400);
        this.getContentPane().setLayout(new BorderLayout());
        this.m_target = printable;
        JToolBar jToolBar = new JToolBar();
        JButton jButton = new JButton("Print");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = new Thread(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        try {
                            PrinterJob printerJob = PrinterJob.getPrinterJob();
                            Book book = new Book();
                            book.append(1.access$000(this.this$1).m_target, 1.access$000(this.this$1).m_pageFormat, 1.access$000(this.this$1).m_pageCount);
                            printerJob.setPageable(book);
                            if (!printerJob.printDialog()) {
                                return;
                            }
                            1.access$000(this.this$1).setCursor(Cursor.getPredefinedCursor(3));
                            printerJob.print();
                            1.access$000(this.this$1).setCursor(Cursor.getPredefinedCursor(0));
                            1.access$000(this.this$1).dispose();
                        }
                        catch (PrinterException printerException) {
                            printerException.printStackTrace();
                            System.err.println("Printing error: " + printerException.toString());
                        }
                    }
                };
                thread.start();
            }

            static /* synthetic */ JGoPrintPreview access$000(1 var0) {
                return var0.JGoPrintPreview.this;
            }
        };
        jButton.addActionListener(actionListener);
        jButton.setAlignmentY(0.5f);
        jButton.setMargin(new Insets(4, 6, 4, 6));
        jToolBar.add(jButton);
        jButton = new JButton("Close");
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    JGoPrintPreview.this.dispose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        jButton.addActionListener(actionListener);
        jButton.setAlignmentY(0.5f);
        jButton.setMargin(new Insets(4, 6, 4, 6));
        jToolBar.add(jButton);
        String[] stringArray = new String[]{"10 %", "25 %", "50 %", "100 %"};
        this.m_cbScale = new JComboBox<String>(stringArray);
        this.m_cbScale.setSelectedIndex(1);
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = new Thread(this){
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        String string = 4.access$100(this.this$1).m_cbScale.getSelectedItem().toString();
                        if (string.endsWith("%")) {
                            string = string.substring(0, string.length() - 1);
                        }
                        string = string.trim();
                        int n = 0;
                        try {
                            n = Integer.parseInt(string);
                        }
                        catch (NumberFormatException numberFormatException) {
                            return;
                        }
                        int n2 = 4.access$100(this.this$1).m_wPage * n / 100;
                        int n3 = 4.access$100(this.this$1).m_hPage * n / 100;
                        Component[] componentArray = 4.access$100(this.this$1).m_preview.getComponents();
                        for (int i = 0; i < componentArray.length; ++i) {
                            if (!(componentArray[i] instanceof PagePreview)) continue;
                            PagePreview pagePreview = (PagePreview)componentArray[i];
                            pagePreview.setScaledSize(n2, n3, (double)n / 100.0);
                        }
                        4.access$100(this.this$1).m_preview.doLayout();
                        4.access$100(this.this$1).m_preview.getParent().getParent().validate();
                    }
                };
                thread.start();
            }

            static /* synthetic */ JGoPrintPreview access$100(4 var0) {
                return var0.JGoPrintPreview.this;
            }
        };
        this.m_cbScale.addActionListener(actionListener);
        this.m_cbScale.setMaximumSize(this.m_cbScale.getPreferredSize());
        this.m_cbScale.setEditable(true);
        jToolBar.addSeparator();
        jToolBar.add(this.m_cbScale);
        this.getContentPane().add((Component)jToolBar, "North");
        this.m_preview = new PreviewContainer();
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (this.m_pageFormat.getHeight() == 0.0 || this.m_pageFormat.getWidth() == 0.0) {
            System.err.println("Unable to determine default page size");
            return;
        }
        this.m_wPage = (int)this.m_pageFormat.getWidth();
        this.m_hPage = (int)this.m_pageFormat.getHeight();
        int n2 = 25;
        int n3 = this.m_wPage * n2 / 100;
        int n4 = this.m_hPage * n2 / 100;
        double d = (double)n2 / 100.0;
        for (int i = 0; i < this.m_pageCount; ++i) {
            PagePreview pagePreview = new PagePreview(n3, n4, this.m_target, d, this.m_pageFormat, i);
            this.m_preview.add(pagePreview);
        }
        JScrollPane jScrollPane = new JScrollPane(this.m_preview);
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.setDefaultCloseOperation(2);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class PagePreview
    extends JPanel {
        private int int;
        private int a;
        private Printable for;
        private double if;
        private PageFormat do;
        private int new;

        public PagePreview(int n, int n2, Printable printable, double d, PageFormat pageFormat, int n3) {
            this.int = n;
            this.a = n2;
            this.for = printable;
            this.if = d;
            this.do = pageFormat;
            this.new = n3;
            this.setBackground(Color.white);
            this.setBorder(new MatteBorder(1, 1, 2, 2, Color.black));
        }

        public void setScaledSize(int n, int n2, double d) {
            this.int = n;
            this.a = n2;
            this.if = d;
            this.repaint();
        }

        public Dimension getPreferredSize() {
            Insets insets = this.getInsets();
            return new Dimension(this.int + insets.left + insets.right, this.a + insets.top + insets.bottom);
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void paintComponent(Graphics graphics) {
            Graphics graphics2 = graphics.create();
            if (graphics2 instanceof Graphics2D) {
                Graphics2D graphics2D = (Graphics2D)graphics2;
                try {
                    graphics2D.setColor(Color.white);
                    graphics2D.fillRect(0, 0, this.int, this.a);
                    JGoView jGoView = null;
                    if (this.for instanceof JGoView) {
                        jGoView = (JGoView)this.for;
                    }
                    if (jGoView != null) {
                        jGoView.applyRenderingHints(graphics2D);
                    }
                    graphics2D.scale(this.if, this.if);
                    this.for.print(graphics2D, this.do, this.new);
                }
                catch (PrinterException printerException) {
                    printerException.printStackTrace();
                }
            }
            graphics2.dispose();
            this.paintBorder(graphics);
        }
    }

    class PreviewContainer
    extends JPanel {
        protected int H_GAP = 16;
        protected int V_GAP = 10;

        PreviewContainer() {
        }

        public Dimension getPreferredSize() {
            int n = this.getComponentCount();
            if (n == 0) {
                return new Dimension(this.H_GAP, this.V_GAP);
            }
            Component component = this.getComponent(0);
            Dimension dimension = component.getPreferredSize();
            int n2 = dimension.width;
            int n3 = dimension.height;
            Dimension dimension2 = this.getParent().getSize();
            int n4 = Math.max((dimension2.width - this.H_GAP) / (n2 + this.H_GAP), 1);
            int n5 = n / n4;
            if (n5 * n4 < n) {
                ++n5;
            }
            int n6 = n4 * (n2 + this.H_GAP) + this.H_GAP;
            int n7 = n5 * (n3 + this.V_GAP) + this.V_GAP;
            Insets insets = this.getInsets();
            return new Dimension(n6 + insets.left + insets.right, n7 + insets.top + insets.bottom);
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void doLayout() {
            Insets insets = this.getInsets();
            int n = insets.left + this.H_GAP;
            int n2 = insets.top + this.V_GAP;
            int n3 = this.getComponentCount();
            if (n3 == 0) {
                return;
            }
            Component component = this.getComponent(0);
            Dimension dimension = component.getPreferredSize();
            int n4 = dimension.width;
            int n5 = dimension.height;
            Dimension dimension2 = this.getParent().getSize();
            int n6 = Math.max((dimension2.width - this.H_GAP) / (n4 + this.H_GAP), 1);
            int n7 = n3 / n6;
            if (n7 * n6 < n3) {
                ++n7;
            }
            int n8 = 0;
            for (int i = 0; i < n7; ++i) {
                for (int j = 0; j < n6; ++j) {
                    if (n8 >= n3) {
                        return;
                    }
                    component = this.getComponent(n8++);
                    component.setBounds(n, n2, n4, n5);
                    n += n4 + this.H_GAP;
                }
                n2 += n5 + this.V_GAP;
                n = insets.left + this.H_GAP;
            }
        }
    }
}

