/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDrawable;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoStroke;
import com.nwoods.jgo.JGoView;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

public class JGoRectangle
extends JGoDrawable {
    public JGoRectangle() {
    }

    public JGoRectangle(Rectangle rectangle) {
        super(rectangle);
    }

    public JGoRectangle(Point point, Dimension dimension) {
        super(point, dimension);
    }

    public JGoObject copyObject(JGoCopyEnvironment jGoCopyEnvironment) {
        JGoRectangle jGoRectangle = (JGoRectangle)super.copyObject(jGoCopyEnvironment);
        if (jGoRectangle != null) {
            // empty if block
        }
        return jGoRectangle;
    }

    public void SVGWriteObject(DomDoc domDoc, DomElement domElement) {
        DomElement domElement2;
        if (domDoc.JGoXMLOutputEnabled()) {
            domElement2 = domDoc.createJGoClassElement("com.nwoods.jgo.JGoRectangle", domElement);
        }
        if (domDoc.SVGOutputEnabled()) {
            domElement2 = domDoc.createElement("rect");
            this.SVGWriteAttributes(domElement2);
            domElement.appendChild(domElement2);
        }
        super.SVGWriteObject(domDoc, domElement);
    }

    public DomNode SVGReadObject(DomDoc domDoc, JGoDocument jGoDocument, DomElement domElement, DomElement domElement2) {
        if (domElement2 != null) {
            super.SVGReadObject(domDoc, jGoDocument, domElement, domElement2.getNextSiblingJGoClassElement());
        } else if (domElement.getTagName().equalsIgnoreCase("rect")) {
            this.SVGReadAttributes(domElement);
        }
        return domElement.getNextSibling();
    }

    public void SVGWriteAttributes(DomElement domElement) {
        super.SVGWriteAttributes(domElement);
        domElement.setAttribute("x", Integer.toString(this.getTopLeft().x));
        domElement.setAttribute("y", Integer.toString(this.getTopLeft().y));
        domElement.setAttribute("width", Integer.toString(this.getWidth()));
        domElement.setAttribute("height", Integer.toString(this.getHeight()));
    }

    public void SVGReadAttributes(DomElement domElement) {
        super.SVGReadAttributes(domElement);
        String string = domElement.getAttribute("x");
        String string2 = domElement.getAttribute("y");
        if (string.length() > 0 && string2.length() > 0) {
            this.setTopLeft(new Point(Integer.parseInt(string), Integer.parseInt(string2)));
        }
        String string3 = domElement.getAttribute("width");
        String string4 = domElement.getAttribute("height");
        if (string3.length() > 0 && string4.length() > 0) {
            this.setWidth(Integer.parseInt(string3));
            this.setHeight(Integer.parseInt(string4));
        }
    }

    public void paint(Graphics2D graphics2D, JGoView jGoView) {
        Rectangle rectangle = this.getBoundingRect();
        this.drawRect(graphics2D, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static boolean getNearestIntersectionPoint(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Point point) {
        double d;
        int n9 = n + n3;
        int n10 = n2 + n4;
        double d2 = 1.0E21;
        int n11 = n7;
        int n12 = n8;
        if (JGoStroke.getNearestIntersectionOnLine(n, n2, n9, n2, n5, n6, n7, n8, point) && (d = (double)((point.x - n5) * (point.x - n5) + (point.y - n6) * (point.y - n6))) < d2) {
            d2 = d;
            n11 = point.x;
            n12 = point.y;
        }
        if (JGoStroke.getNearestIntersectionOnLine(n9, n2, n9, n10, n5, n6, n7, n8, point) && (d = (double)((point.x - n5) * (point.x - n5) + (point.y - n6) * (point.y - n6))) < d2) {
            d2 = d;
            n11 = point.x;
            n12 = point.y;
        }
        if (JGoStroke.getNearestIntersectionOnLine(n9, n10, n, n10, n5, n6, n7, n8, point) && (d = (double)((point.x - n5) * (point.x - n5) + (point.y - n6) * (point.y - n6))) < d2) {
            d2 = d;
            n11 = point.x;
            n12 = point.y;
        }
        if (JGoStroke.getNearestIntersectionOnLine(n, n10, n, n2, n5, n6, n7, n8, point) && (d = (double)((point.x - n5) * (point.x - n5) + (point.y - n6) * (point.y - n6))) < d2) {
            d2 = d;
            n11 = point.x;
            n12 = point.y;
        }
        point.x = n11;
        point.y = n12;
        return d2 < 1.0E21;
    }
}

