/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoRectangle;
import com.nwoods.jgo.JGoSubGraph;
import com.nwoods.jgo.JGoView;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

public class JGoSubGraphHandle
extends JGoRectangle {
    public JGoSubGraphHandle() {
        this.setSize(10, 10);
        this.setDragsNode(true);
        this.setSelectable(false);
        this.setResizable(false);
        this.setBrush(JGoBrush.yellow);
    }

    public void paint(Graphics2D graphics2D, JGoView jGoView) {
        super.paint(graphics2D, jGoView);
        this.paintHandle(graphics2D, jGoView);
    }

    public void paintHandle(Graphics2D graphics2D, JGoView jGoView) {
        JGoSubGraph jGoSubGraph = (JGoSubGraph)this.getParent();
        if (jGoSubGraph == null) {
            return;
        }
        Rectangle rectangle = this.getBoundingRect();
        if (jGoSubGraph.isCollapsible()) {
            int n = rectangle.y + rectangle.height / 2;
            JGoSubGraphHandle.drawLine(graphics2D, JGoPen.black, rectangle.x + rectangle.width / 4, n, rectangle.x + rectangle.width * 3 / 4, n);
            if (!jGoSubGraph.isExpanded()) {
                int n2 = rectangle.x + rectangle.width / 2;
                JGoSubGraphHandle.drawLine(graphics2D, JGoPen.black, n2, rectangle.y + rectangle.height / 4, n2, rectangle.y + rectangle.height * 3 / 4);
            }
        } else {
            JGoSubGraphHandle.drawEllipse(graphics2D, JGoPen.black, null, rectangle.x + rectangle.width / 4, rectangle.y + rectangle.height / 4, rectangle.width / 2, rectangle.height / 2);
        }
    }

    public boolean doMouseClick(int n, Point point, Point point2, JGoView jGoView) {
        JGoSubGraph jGoSubGraph = (JGoSubGraph)this.getParent();
        if (jGoSubGraph == null || !jGoSubGraph.isCollapsible()) {
            return false;
        }
        if (jGoView != null) {
            jGoView.getDocument().startTransaction();
        }
        String string = null;
        if (jGoSubGraph.isExpanded()) {
            jGoSubGraph.collapse();
            string = "Collapsed JGoSubGraph";
        } else if ((n & 2) != 0) {
            jGoSubGraph.expandAll();
            string = "Expanded All JGoSubGraphs";
        } else {
            jGoSubGraph.expand();
            string = "Expand JGoSubGraph";
        }
        if (jGoView != null) {
            jGoView.getDocument().endTransaction(string);
            jGoView.getSelection().restoreSelectionHandles(jGoSubGraph);
        }
        return true;
    }

    public void SVGWriteObject(DomDoc domDoc, DomElement domElement) {
        if (domDoc.JGoXMLOutputEnabled()) {
            DomElement domElement2 = domDoc.createJGoClassElement("com.nwoods.jgo.JGoSubGraphHandle", domElement);
        }
        super.SVGWriteObject(domDoc, domElement);
    }

    public DomNode SVGReadObject(DomDoc domDoc, JGoDocument jGoDocument, DomElement domElement, DomElement domElement2) {
        if (domElement2 != null) {
            super.SVGReadObject(domDoc, jGoDocument, domElement, domElement2.getNextSiblingElement());
        }
        return domElement.getNextSibling();
    }
}

