/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.layout;

import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoSelection;
import com.nwoods.jgo.layout.JGoAutoLayout;
import com.nwoods.jgo.layout.JGoForceDirectedAutoLayoutLinkData;
import com.nwoods.jgo.layout.JGoForceDirectedAutoLayoutNodeData;
import com.nwoods.jgo.layout.JGoNetwork;
import com.nwoods.jgo.layout.JGoNetworkLink;
import com.nwoods.jgo.layout.JGoNetworkNode;
import java.awt.Point;
import java.util.Random;
import javax.swing.JOptionPane;

public class JGoForceDirectedAutoLayout
extends JGoAutoLayout {
    private static int q = 1000;
    private int p;
    private int r;
    private Random s = null;

    public JGoForceDirectedAutoLayout() {
        this.p = JGoForceDirectedAutoLayout.getDefaultMaxIterations();
    }

    public JGoForceDirectedAutoLayout(JGoDocument jGoDocument) {
        super(jGoDocument);
        this.p = JGoForceDirectedAutoLayout.getDefaultMaxIterations();
    }

    public JGoForceDirectedAutoLayout(JGoSelection jGoSelection) {
        super(jGoSelection);
        this.p = JGoForceDirectedAutoLayout.getDefaultMaxIterations();
    }

    public JGoForceDirectedAutoLayout(JGoDocument jGoDocument, int n) {
        super(jGoDocument);
        this.p = n;
    }

    public JGoForceDirectedAutoLayout(JGoDocument jGoDocument, JGoNetwork jGoNetwork, int n) {
        super(jGoDocument, jGoNetwork);
        this.p = n;
    }

    public JGoForceDirectedAutoLayout(JGoForceDirectedAutoLayout jGoForceDirectedAutoLayout) {
        this.setDocument(jGoForceDirectedAutoLayout.getDocument());
        this.setNetwork(null);
        this.setMaxIterations(jGoForceDirectedAutoLayout.getMaxIterations());
        this.setRandomNumberGenerator(jGoForceDirectedAutoLayout.getRandomNumberGenerator());
    }

    public void performLayout() {
        JOptionPane.showMessageDialog(null, "Built with the JGoLayout Evaluation Kit by Northwoods Software\nThis software is licensed for evaluation purposes only.\n\nDO NOT DISTRIBUTE THIS SOFTWARE.\n\nPlease purchase a full license at www.nwoods.com", "Credits", 1);
        if (this.getNetwork() == null) {
            return;
        }
        this.progressUpdate(0.0);
        this.getNetwork().deleteSelfLinks();
        JGoNetworkNode[] jGoNetworkNodeArray = this.getNetwork().getNodeArray();
        for (int i = 0; i < jGoNetworkNodeArray.length; ++i) {
            JGoNetworkNode jGoNetworkNode = jGoNetworkNodeArray[i];
            jGoNetworkNode.do = new JGoForceDirectedAutoLayoutNodeData();
            this.nodeData((JGoNetworkNode)jGoNetworkNode).charge = this.getElectricalCharge(jGoNetworkNode);
            this.nodeData((JGoNetworkNode)jGoNetworkNode).mass = this.getGravitationalMass(jGoNetworkNode);
            this.nodeData((JGoNetworkNode)jGoNetworkNode).changeX = 0;
            this.nodeData((JGoNetworkNode)jGoNetworkNode).changeY = 0;
        }
        JGoNetworkLink[] jGoNetworkLinkArray = this.getNetwork().getLinkArray();
        for (int i = 0; i < jGoNetworkLinkArray.length; ++i) {
            JGoNetworkLink jGoNetworkLink = jGoNetworkLinkArray[i];
            jGoNetworkLink.a = new JGoForceDirectedAutoLayoutLinkData();
            this.linkData((JGoNetworkLink)jGoNetworkLink).stiffness = this.getSpringStiffness(jGoNetworkLink);
            this.linkData((JGoNetworkLink)jGoNetworkLink).length = this.getSpringLength(jGoNetworkLink);
        }
        this.r = 0;
        while (this.r < this.p) {
            ++this.r;
            if (!this.updatePositions()) break;
            this.layoutNodesAndLinks(false);
        }
        this.layoutNodesAndLinks(true);
        this.progressUpdate(1.0);
    }

    protected double getNodeDistance(JGoNetworkNode jGoNetworkNode, JGoNetworkNode jGoNetworkNode2) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        Point point = jGoNetworkNode.getCenter();
        if (jGoNetworkNode.getJGoObject() != null) {
            int n9 = jGoNetworkNode.getJGoObject().getWidth() / 2;
            n8 = point.x - n9;
            n7 = 2 * n9;
            n6 = jGoNetworkNode.getJGoObject().getHeight() / 2;
            n5 = point.y - n6;
            n4 = 2 * n6;
        } else {
            n8 = point.x;
            n7 = 0;
            n5 = point.y;
            n4 = 0;
        }
        Point point2 = jGoNetworkNode2.getCenter();
        if (jGoNetworkNode2.getJGoObject() != null) {
            int n10 = jGoNetworkNode2.getJGoObject().getWidth() / 2;
            n6 = point2.x - n10;
            n3 = 2 * n10;
            int n11 = jGoNetworkNode2.getJGoObject().getHeight() / 2;
            n2 = point2.y - n11;
            n = 2 * n11;
        } else {
            n6 = point2.x;
            n3 = 0;
            n2 = point2.y;
            n = 0;
        }
        if (n8 + n7 < n6) {
            if (n5 > n2 + n) {
                return Math.sqrt(Math.pow(n8 + n7 - n6, 2.0) + Math.pow(n5 - (n2 + n), 2.0));
            }
            if (n5 + n4 < n2) {
                return Math.sqrt(Math.pow(n8 + n7 - n6, 2.0) + Math.pow(n5 + n4 - n2, 2.0));
            }
            return Math.abs(n8 + n7 - n6);
        }
        if (n8 > n6 + n3) {
            if (n5 > n2 + n) {
                return Math.sqrt(Math.pow(n8 - (n6 + n3), 2.0) + Math.pow(n5 - (n2 + n), 2.0));
            }
            if (n5 + n4 < n2) {
                return Math.sqrt(Math.pow(n8 - (n6 + n3), 2.0) + Math.pow(n5 + n4 - n2, 2.0));
            }
            return Math.abs(n8 - (n6 + n3));
        }
        if (n5 > n2 + n) {
            return Math.abs(n5 - (n2 + n));
        }
        if (n5 + n4 < n2) {
            return Math.abs(n5 + n4 - n2);
        }
        return 0.1;
    }

    protected double getSpringStiffness(JGoNetworkLink jGoNetworkLink) {
        return 0.05;
    }

    protected double getSpringLength(JGoNetworkLink jGoNetworkLink) {
        return 50.0;
    }

    protected double getElectricalCharge(JGoNetworkNode jGoNetworkNode) {
        return 150.0;
    }

    protected double getElectricalFieldX(Point point) {
        return 0.0;
    }

    protected double getElectricalFieldY(Point point) {
        return 0.0;
    }

    protected double getGravitationalMass(JGoNetworkNode jGoNetworkNode) {
        return 0.0;
    }

    protected double getGravitationalFieldX(Point point) {
        return 0.0;
    }

    protected double getGravitationalFieldY(Point point) {
        return 0.0;
    }

    protected boolean isFixed(JGoNetworkNode jGoNetworkNode) {
        return false;
    }

    protected boolean updatePositions() {
        int n;
        Point point;
        JGoNetworkNode jGoNetworkNode;
        Object object;
        JGoNetworkNode[] jGoNetworkNodeArray = this.getNetwork().getNodeArray();
        for (int i = 0; i < jGoNetworkNodeArray.length; ++i) {
            JGoNetworkNode jGoNetworkNode2 = jGoNetworkNodeArray[i];
            this.nodeData((JGoNetworkNode)jGoNetworkNode2).forceX = 0.0;
            this.nodeData((JGoNetworkNode)jGoNetworkNode2).forceY = 0.0;
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        boolean bl = false;
        for (int i = 0; i < jGoNetworkNodeArray.length; ++i) {
            JGoNetworkNode jGoNetworkNode3 = jGoNetworkNodeArray[i];
            object = jGoNetworkNode3.getCenter();
            d2 = this.nodeData((JGoNetworkNode)jGoNetworkNode3).charge * this.getElectricalFieldX((Point)object);
            d3 = this.nodeData((JGoNetworkNode)jGoNetworkNode3).charge * this.getElectricalFieldY((Point)object);
            this.nodeData((JGoNetworkNode)jGoNetworkNode3).forceX += d2;
            this.nodeData((JGoNetworkNode)jGoNetworkNode3).forceY += d3;
            d2 = this.nodeData((JGoNetworkNode)jGoNetworkNode3).mass * this.getGravitationalFieldX((Point)object);
            d3 = this.nodeData((JGoNetworkNode)jGoNetworkNode3).mass * this.getGravitationalFieldY((Point)object);
            this.nodeData((JGoNetworkNode)jGoNetworkNode3).forceX += d2;
            this.nodeData((JGoNetworkNode)jGoNetworkNode3).forceY += d3;
            for (int j = i + 1; j < jGoNetworkNodeArray.length; ++j) {
                jGoNetworkNode = jGoNetworkNodeArray[j];
                point = jGoNetworkNode.getCenter();
                double d4 = this.getNodeDistance(jGoNetworkNode3, jGoNetworkNode);
                if (d4 < 1.0) {
                    if (this.s == null) {
                        this.s = new Random();
                    }
                    d2 = this.s.nextInt(20);
                    d3 = this.s.nextInt(20);
                } else {
                    d = -1.0 * (this.nodeData((JGoNetworkNode)jGoNetworkNode3).charge * this.nodeData((JGoNetworkNode)jGoNetworkNode).charge) / (d4 * d4);
                    d2 = d * ((double)(point.x - ((Point)object).x) / d4);
                    d3 = d * ((double)(point.y - ((Point)object).y) / d4);
                }
                this.nodeData((JGoNetworkNode)jGoNetworkNode3).forceX += d2;
                this.nodeData((JGoNetworkNode)jGoNetworkNode3).forceY += d3;
                this.nodeData((JGoNetworkNode)jGoNetworkNode).forceX -= d2;
                this.nodeData((JGoNetworkNode)jGoNetworkNode).forceY -= d3;
            }
        }
        JGoNetworkLink[] jGoNetworkLinkArray = this.getNetwork().getLinkArray();
        for (n = 0; n < jGoNetworkLinkArray.length; ++n) {
            object = jGoNetworkLinkArray[n];
            JGoNetworkNode jGoNetworkNode4 = ((JGoNetworkLink)object).getFromNode();
            jGoNetworkNode = ((JGoNetworkLink)object).getToNode();
            point = jGoNetworkNode4.getCenter();
            Point point2 = jGoNetworkNode.getCenter();
            double d5 = this.getNodeDistance(jGoNetworkNode4, jGoNetworkNode);
            if (d5 < 1.0) {
                if (this.s == null) {
                    this.s = new Random();
                }
                d2 = this.s.nextInt(20);
                d3 = this.s.nextInt(20);
            } else {
                d = this.linkData((JGoNetworkLink)object).stiffness * (d5 - this.linkData((JGoNetworkLink)object).length);
                d2 = d * ((double)(point2.x - point.x) / d5);
                d3 = d * ((double)(point2.y - point.y) / d5);
            }
            this.nodeData((JGoNetworkNode)jGoNetworkNode4).forceX += d2;
            this.nodeData((JGoNetworkNode)jGoNetworkNode4).forceY += d3;
            this.nodeData((JGoNetworkNode)jGoNetworkNode).forceX -= d2;
            this.nodeData((JGoNetworkNode)jGoNetworkNode).forceY -= d3;
        }
        for (n = 0; n < jGoNetworkNodeArray.length; ++n) {
            int n2;
            int n3;
            object = jGoNetworkNodeArray[n];
            Point point3 = ((JGoNetworkNode)object).getCenter();
            if (this.isFixed((JGoNetworkNode)object)) continue;
            double d6 = 1.0;
            do {
                n3 = (int)Math.round(this.nodeData((JGoNetworkNode)object).forceX * d6);
                n2 = (int)Math.round(this.nodeData((JGoNetworkNode)object).forceY * d6);
            } while (n3 == 0 && n2 == 0 && (d6 *= 1.25) < 256.0);
            n3 = Math.min(Math.max(n3, -50), 50);
            n2 = Math.min(Math.max(n2, -50), 50);
            ((JGoNetworkNode)object).setCenter(point3.x + n3, point3.y + n2);
            this.nodeData((JGoNetworkNode)object).changeX += n3;
            this.nodeData((JGoNetworkNode)object).changeY += n2;
            if (this.r % 10 != 0) continue;
            if (Math.abs(this.nodeData((JGoNetworkNode)object).changeX) > 1 || Math.abs(this.nodeData((JGoNetworkNode)object).changeY) > 1) {
                bl = true;
            }
            this.nodeData((JGoNetworkNode)object).changeX = 0;
            this.nodeData((JGoNetworkNode)object).changeY = 0;
        }
        if (this.r % 10 != 0) {
            bl = true;
        }
        return bl;
    }

    protected void layoutNodesAndLinks(boolean bl) {
        if (this.r % 10 == 0 || bl) {
            this.getNetwork().commitNodesAndLinks();
            this.progressUpdate((double)this.r / (double)this.p);
        }
    }

    public int getMaxIterations() {
        return this.p;
    }

    public void setMaxIterations(int n) {
        this.p = Math.max(n, 0);
    }

    public Random getRandomNumberGenerator() {
        return this.s;
    }

    public void setRandomNumberGenerator(Random random) {
        this.s = random;
    }

    public final JGoForceDirectedAutoLayoutNodeData nodeData(JGoNetworkNode jGoNetworkNode) {
        return (JGoForceDirectedAutoLayoutNodeData)jGoNetworkNode.do;
    }

    public final JGoForceDirectedAutoLayoutLinkData linkData(JGoNetworkLink jGoNetworkLink) {
        return (JGoForceDirectedAutoLayoutLinkData)jGoNetworkLink.a;
    }

    public static int getDefaultMaxIterations() {
        return q;
    }

    public static void setDefaultMaxIterations(int n) {
        q = n;
    }
}

