/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoIdentifiablePart;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoObjectCollection;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoPolygon;
import com.nwoods.jgo.JGoText;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;

public class Balloon
extends JGoArea
implements JGoIdentifiablePart {
    private Insets myInsets = new Insets(2, 4, 8, 8);
    public static final int ChangedPartID = 65836;
    public static final int ChangedAnchor = 65837;
    public static final int ChangedBaseWidth = 65838;
    private int myPartID = -1;
    private JGoText myLabel = null;
    private JGoPolygon myPoly = null;
    private JGoObject myAnchor = null;
    private int myBaseWidth = 30;

    public Balloon() {
    }

    public Balloon(String string) {
        this.initialize(string);
    }

    public void initialize(String string) {
        this.setResizable(false);
        this.myPoly = new JGoPolygon();
        this.myPoly.setSelectable(false);
        this.myPoly.setPen(JGoPen.lightGray);
        this.myPoly.setBrush(JGoBrush.makeStockBrush(new Color(255, 255, 204)));
        this.myLabel = new JGoText(string);
        this.myLabel.setMultiline(true);
        this.myLabel.setSelectable(false);
        this.myLabel.setResizable(false);
        this.myLabel.setDraggable(false);
        this.myLabel.setEditable(false);
        this.myLabel.setEditOnSingleClick(true);
        this.myLabel.setTransparent(true);
        this.addObjectAtHead(this.myPoly);
        this.addObjectAtTail(this.myLabel);
    }

    protected void copyChildren(JGoArea jGoArea, JGoCopyEnvironment jGoCopyEnvironment) {
        Balloon balloon = (Balloon)jGoArea;
        jGoCopyEnvironment.delay(this);
        balloon.myPartID = this.myPartID;
        super.copyChildren(jGoArea, jGoCopyEnvironment);
        balloon.myPoly = (JGoPolygon)jGoCopyEnvironment.get(this.myPoly);
        balloon.myLabel = (JGoText)jGoCopyEnvironment.get(this.myLabel);
    }

    public void copyObjectDelayed(JGoCopyEnvironment jGoCopyEnvironment, JGoObject jGoObject) {
        Balloon balloon = (Balloon)jGoObject;
        balloon.myAnchor = (JGoObject)jGoCopyEnvironment.get(this.myAnchor);
        balloon.updatePolygon();
    }

    public JGoObject removeObjectAtPos(JGoListPosition jGoListPosition) {
        JGoObject jGoObject = super.removeObjectAtPos(jGoListPosition);
        if (jGoObject == this.myPoly) {
            this.myPoly = null;
        } else if (jGoObject == this.myLabel) {
            this.myLabel = null;
        }
        return jGoObject;
    }

    protected void moveChildren(Rectangle rectangle) {
        super.moveChildren(rectangle);
        this.updatePolygon();
    }

    public void layoutChildren(JGoObject jGoObject) {
        if (this.isInitializing()) {
            return;
        }
        JGoText jGoText = this.getLabel();
        if (jGoText == null) {
            return;
        }
        JGoPolygon jGoPolygon = this.getPolygon();
        if (jGoPolygon != null) {
            int n;
            this.setInitializing(true);
            Insets insets = this.getInsets();
            Rectangle rectangle = new Rectangle(jGoText.getLeft() - insets.left, jGoText.getTop() - insets.top, jGoText.getWidth() + insets.left + insets.right, jGoText.getHeight() + insets.top + insets.bottom);
            Dimension dimension = new Dimension(4, 4);
            int n2 = dimension.width;
            if (n2 > rectangle.width / 2) {
                n2 = rectangle.width / 2;
            }
            if ((n = dimension.height) > rectangle.height / 2) {
                n = rectangle.height / 2;
            }
            int n3 = rectangle.x;
            int n4 = rectangle.y;
            int n5 = n3 + n2;
            int n6 = n4 + n;
            int n7 = n3 + rectangle.width / 2;
            int n8 = n4 + rectangle.height / 2;
            int n9 = n3 + rectangle.width - n2;
            int n10 = n4 + rectangle.height - n;
            int n11 = n3 + rectangle.width;
            int n12 = n4 + rectangle.height;
            jGoPolygon.foredate(110);
            jGoPolygon.setSuspendUpdates(true);
            jGoPolygon.removeAllPoints();
            int n13 = Math.min(rectangle.width - n2, this.getBaseWidth());
            int n14 = Math.min(rectangle.height - n, this.getBaseWidth());
            int n15 = jGoText.getLeft();
            int n16 = jGoText.getTop();
            int n17 = n15 + jGoText.getWidth();
            int n18 = n16 + jGoText.getHeight();
            Point point = jGoText.getSpotLocation(0);
            Point point2 = this.computeAnchorPoint();
            Point point3 = new Point(0, 0);
            jGoText.getNearestIntersectionPoint(point2.x, point2.y, point.x, point.y, point3);
            if (point3.y <= n16 && point3.x < n7) {
                jGoPolygon.addPoint(n3, n4);
                jGoPolygon.addPoint(point2);
                jGoPolygon.addPoint(n3 + n13, n4);
            } else {
                jGoPolygon.addPoint(n5, n4);
            }
            if (point3.y <= n16 && point3.x >= n7) {
                jGoPolygon.addPoint(n11 - n13, n4);
                jGoPolygon.addPoint(point2);
                jGoPolygon.addPoint(n11, n4);
            } else {
                jGoPolygon.addPoint(n9, n4);
            }
            if (point3.x >= n17 & point3.y < n8) {
                jGoPolygon.addPoint(n11, n4);
                jGoPolygon.addPoint(point2);
                jGoPolygon.addPoint(n11, n4 + n14);
            } else {
                jGoPolygon.addPoint(n11, n6);
            }
            if (point3.x >= n17 & point3.y >= n8) {
                jGoPolygon.addPoint(n11, n12 - n14);
                jGoPolygon.addPoint(point2);
                jGoPolygon.addPoint(n11, n12);
            } else {
                jGoPolygon.addPoint(n11, n10);
            }
            if (point3.y >= n18 && point3.x >= n7) {
                jGoPolygon.addPoint(n11, n12);
                jGoPolygon.addPoint(point2);
                jGoPolygon.addPoint(n11 - n13, n12);
            } else {
                jGoPolygon.addPoint(n9, n12);
            }
            if (point3.y >= n18 && point3.x < n7) {
                jGoPolygon.addPoint(n3 + n13, n12);
                jGoPolygon.addPoint(point2);
                jGoPolygon.addPoint(n3, n12);
            } else {
                jGoPolygon.addPoint(n5, n12);
            }
            if (point3.x <= n15 && point3.y >= n8) {
                jGoPolygon.addPoint(n3, n12);
                jGoPolygon.addPoint(point2);
                jGoPolygon.addPoint(n3, n12 - n14);
            } else {
                jGoPolygon.addPoint(n3, n10);
            }
            if (point3.x <= n15 && point3.y < n8) {
                jGoPolygon.addPoint(n3, n4 + n14);
                jGoPolygon.addPoint(point2);
                jGoPolygon.addPoint(n3, n4);
            } else {
                jGoPolygon.addPoint(n3, n6);
            }
            jGoPolygon.setSuspendUpdates(false);
            jGoPolygon.update(110, 0, null);
            this.setInitializing(false);
        }
    }

    public Point computeAnchorPoint() {
        Point point = this.getLabel() != null ? this.getLabel().getSpotLocation(0) : this.getSpotLocation(0);
        if (this.getAnchor() != null) {
            Point point2 = this.getAnchor().getSpotLocation(0);
            Point point3 = new Point(0, 0);
            if (this.getAnchor().getNearestIntersectionPoint(point.x, point.y, point2.x, point2.y, point3)) {
                return point3;
            }
            return point2;
        }
        Point point4 = this.getLabel() != null ? new Point(this.getLabel().getLeft() - 30, this.getLabel().getTop() - 30) : new Point(point.x - 30, point.y - 30);
        return point4;
    }

    public Rectangle computeBoundingRect() {
        JGoText jGoText = this.getLabel();
        if (jGoText == null) {
            return super.computeBoundingRect();
        }
        Insets insets = this.getInsets();
        Rectangle rectangle = new Rectangle(jGoText.getLeft() - insets.left, jGoText.getTop() - insets.top, jGoText.getWidth() + insets.left + insets.right, jGoText.getHeight() + insets.top + insets.bottom);
        return rectangle;
    }

    public void expandRectByPenWidth(Rectangle rectangle) {
        JGoPolygon jGoPolygon = this.getPolygon();
        if (jGoPolygon != null) {
            rectangle.add(jGoPolygon.getBoundingRect());
            ((JGoObject)jGoPolygon).expandRectByPenWidth(rectangle);
        }
    }

    public void updatePolygon() {
        this.layoutChildren(null);
    }

    protected void ownerChange(JGoObjectCollection jGoObjectCollection, JGoObjectCollection jGoObjectCollection2, JGoObject jGoObject) {
        if (jGoObjectCollection2 == null && this.getAnchor() != null) {
            this.setAnchor(null);
        }
    }

    protected void partnerUpdate(JGoObject jGoObject, int n, int n2, Object object) {
        super.partnerUpdate(jGoObject, n, n2, object);
        if (jGoObject == this.getAnchor() && n == 1) {
            this.updatePolygon();
        }
    }

    public Insets getInsets() {
        return this.myInsets;
    }

    public int getBaseWidth() {
        return this.myBaseWidth;
    }

    public void setBaseWidth(int n) {
        int n2 = this.myBaseWidth;
        if (n2 != n) {
            this.myBaseWidth = n;
            this.update(65838, n2, null);
            this.updatePolygon();
        }
    }

    public JGoObject getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(JGoObject jGoObject) {
        JGoObject jGoObject2 = this.myAnchor;
        if (jGoObject2 != jGoObject) {
            if (jGoObject2 != null && jGoObject2.getPartner() == this) {
                jGoObject2.setPartner(null);
                jGoObject2.setUpdatePartner(false);
            }
            this.myAnchor = jGoObject;
            if (jGoObject != null) {
                jGoObject.setPartner(this);
                jGoObject.setUpdatePartner(true);
            }
            this.update(65837, 0, jGoObject2);
            this.updatePolygon();
        }
    }

    public int getPartID() {
        return this.myPartID;
    }

    public void setPartID(int n) {
        int n2 = this.myPartID;
        if (n2 != n) {
            this.myPartID = n;
            this.update(65836, n2, null);
        }
    }

    public JGoText getLabel() {
        return this.myLabel;
    }

    public JGoPolygon getPolygon() {
        return this.myPoly;
    }

    public String getText() {
        return this.getLabel().getText();
    }

    public void setText(String string) {
        this.getLabel().setText(string);
    }

    public boolean isEditable() {
        return this.getLabel().isEditable();
    }

    public void setEditable(boolean bl) {
        this.getLabel().setEditable(bl);
    }

    public void SVGUpdateReference(String string, Object object) {
        super.SVGUpdateReference(string, object);
        if (string.equals("polyobj")) {
            this.myPoly = (JGoPolygon)object;
        } else if (string.equals("label")) {
            this.myLabel = (JGoText)object;
        } else if (string.equals("anchor")) {
            this.myAnchor = (JGoObject)object;
        }
    }

    public void SVGWriteObject(DomDoc domDoc, DomElement domElement) {
        if (domDoc.JGoXMLOutputEnabled()) {
            DomElement domElement2 = domDoc.createJGoClassElement("com.nwoods.jgo.examples.Balloon", domElement);
            domElement2.setAttribute("partid", Integer.toString(this.myPartID));
            if (this.myPoly != null) {
                domDoc.registerReferencingNode(domElement2, "polyobj", this.myPoly);
            }
            if (this.myLabel != null) {
                domDoc.registerReferencingNode(domElement2, "label", this.myLabel);
            }
            if (this.myAnchor != null) {
                domDoc.registerReferencingNode(domElement2, "anchor", this.myAnchor);
            }
        }
        super.SVGWriteObject(domDoc, domElement);
    }

    public DomNode SVGReadObject(DomDoc domDoc, JGoDocument jGoDocument, DomElement domElement, DomElement domElement2) {
        if (domElement2 != null) {
            String string = domElement2.getAttribute("partid");
            if (string.length() > 0) {
                this.myPartID = Integer.parseInt(string);
            }
            String string2 = domElement2.getAttribute("polyobj");
            domDoc.registerReferencingObject(this, "polyobj", string2);
            String string3 = domElement2.getAttribute("label");
            domDoc.registerReferencingObject(this, "label", string3);
            String string4 = domElement2.getAttribute("anchor");
            domDoc.registerReferencingObject(this, "anchor", string4);
            super.SVGReadObject(domDoc, jGoDocument, domElement, domElement2.getNextSiblingJGoClassElement());
        }
        return domElement.getNextSibling();
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit jGoDocumentChangedEdit) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 65836: {
                jGoDocumentChangedEdit.setNewValueInt(this.getPartID());
                return;
            }
            case 65837: {
                jGoDocumentChangedEdit.setNewValue(this.getAnchor());
                return;
            }
            case 65838: {
                jGoDocumentChangedEdit.setNewValueInt(this.getBaseWidth());
                return;
            }
        }
        super.copyNewValueForRedo(jGoDocumentChangedEdit);
    }

    public void changeValue(JGoDocumentChangedEdit jGoDocumentChangedEdit, boolean bl) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 65836: {
                this.setPartID(jGoDocumentChangedEdit.getValueInt(bl));
                return;
            }
            case 65837: {
                this.setAnchor((JGoObject)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
            case 65838: {
                this.setBaseWidth(jGoDocumentChangedEdit.getValueInt(bl));
                return;
            }
        }
        super.changeValue(jGoDocumentChangedEdit, bl);
    }
}

