/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoNode;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoText;
import com.nwoods.jgo.examples.MultiPortNodeLabel;
import java.awt.Point;

public class MultiPortNode
extends JGoNode {
    protected JGoText myLabel = null;
    protected JGoObject myIcon = null;

    public void initialize(Point point, JGoObject jGoObject, String string) {
        this.setInitializing(true);
        this.setDraggable(true);
        this.setResizable(false);
        this.myIcon = jGoObject;
        jGoObject.setTopLeft(point);
        jGoObject.setSelectable(false);
        this.addObjectAtHead(jGoObject);
        if (string != null) {
            this.myLabel = new MultiPortNodeLabel(string, jGoObject, this);
        }
        this.setInitializing(false);
        this.layoutChildren(null);
        this.setTopLeft(point);
    }

    protected void copyChildren(JGoArea jGoArea, JGoCopyEnvironment jGoCopyEnvironment) {
        MultiPortNode multiPortNode = (MultiPortNode)jGoArea;
        super.copyChildren(jGoArea, jGoCopyEnvironment);
        multiPortNode.myIcon = (JGoObject)jGoCopyEnvironment.get(this.myIcon);
        multiPortNode.myLabel = (JGoText)jGoCopyEnvironment.get(this.myLabel);
    }

    public JGoObject removeObjectAtPos(JGoListPosition jGoListPosition) {
        JGoObject jGoObject = super.removeObjectAtPos(jGoListPosition);
        if (jGoObject == this.myLabel) {
            this.myLabel = null;
        } else if (jGoObject == this.myIcon) {
            this.myIcon = null;
        }
        return jGoObject;
    }

    public void SVGWriteObject(DomDoc domDoc, DomElement domElement) {
        if (domDoc.JGoXMLOutputEnabled()) {
            DomElement domElement2 = domDoc.createJGoClassElement("com.nwoods.jgo.examples.MultiPortNode", domElement);
            if (this.myIcon != null) {
                domDoc.registerReferencingNode(domElement2, "multiporticon", this.myIcon);
            }
            if (this.myLabel != null) {
                domDoc.registerReferencingNode(domElement2, "multiportlabel", this.myLabel);
            }
        }
        super.SVGWriteObject(domDoc, domElement);
    }

    public DomNode SVGReadObject(DomDoc domDoc, JGoDocument jGoDocument, DomElement domElement, DomElement domElement2) {
        if (domElement2 != null) {
            String string = domElement2.getAttribute("multiporticon");
            domDoc.registerReferencingObject(this, "multiporticon", string);
            String string2 = domElement2.getAttribute("multiportlabel");
            domDoc.registerReferencingObject(this, "multiportlabel", string2);
            super.SVGReadObject(domDoc, jGoDocument, domElement, domElement2.getNextSiblingElement());
        }
        return domElement.getNextSibling();
    }

    public void SVGUpdateReference(String string, Object object) {
        super.SVGUpdateReference(string, object);
        if (string.equals("multiporticon")) {
            this.myIcon = (JGoObject)object;
        }
        if (string.equals("multiportlabel")) {
            this.myLabel = (JGoText)object;
        }
    }

    public JGoText getLabel() {
        return this.myLabel;
    }

    public JGoObject getIcon() {
        return this.myIcon;
    }
}

