/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.demo1;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoRoundRect;
import com.nwoods.jgo.JGoView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

public class Demo1RoundRect
extends JGoRoundRect {
    public Demo1RoundRect(Point point, Dimension dimension, Dimension dimension2) {
        super(point, dimension, dimension2);
        this.updateFill();
    }

    public Demo1RoundRect() {
        this.updateFill();
    }

    public void geometryChange(Rectangle rectangle) {
        super.geometryChange(rectangle);
        this.updateFill();
    }

    public Rectangle handleResize(Graphics2D graphics2D, JGoView jGoView, Rectangle rectangle, Point point, int n, int n2, int n3, int n4) {
        Rectangle rectangle2 = super.handleResize(graphics2D, jGoView, rectangle, point, n, n2, n3, n4);
        if (n2 == 2) {
            this.setBoundingRect(rectangle2);
        }
        return null;
    }

    public void updateFill() {
        Rectangle rectangle = this.getBoundingRect();
        if (this.getBrush() != null && this.getBrush().getStyle() == 65535) {
            this.setBrush(new JGoBrush(this.getBrush().getPaint()));
            return;
        }
        this.setBrush(new JGoBrush(new GradientPaint(rectangle.x, rectangle.y, Color.magenta, rectangle.x + rectangle.width, rectangle.y + rectangle.height, Color.blue)));
    }

    public String getToolTipText() {
        if (this.getBrush() == null) {
            return "this doesn't have any brush filling in the inside";
        }
        if (this.getBrush().getPaint() instanceof GradientPaint) {
            return "this is filled with a color gradient";
        }
        return "this is filled with a solid color";
    }

    public void SVGWriteObject(DomDoc domDoc, DomElement domElement) {
        DomElement domElement2 = domDoc.createJGoClassElement("com.nwoods.jgo.examples.demo1.Demo1RoundRect", domElement);
        super.SVGWriteObject(domDoc, domElement);
    }

    public DomNode SVGReadObject(DomDoc domDoc, JGoDocument jGoDocument, DomElement domElement, DomElement domElement2) {
        if (domElement2 != null) {
            super.SVGReadObject(domDoc, jGoDocument, domElement, domElement2.getNextSiblingJGoClassElement());
            this.updateFill();
        }
        return domElement.getNextSibling();
    }

    public void SVGUpdateReference(String string, Object object) {
        if (!string.equals("drawablebrush")) {
            super.SVGUpdateReference(string, object);
        }
    }
}

