/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.demo1;

import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoBasicNode;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoLabeledLink;
import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoLinkLabel;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoRectangle;
import com.nwoods.jgo.JGoStroke;
import com.nwoods.jgo.JGoSubGraphBase;
import com.nwoods.jgo.JGoText;
import com.nwoods.jgo.JGoView;
import com.nwoods.jgo.examples.ListArea;
import com.nwoods.jgo.examples.RecordNode;
import com.nwoods.jgo.examples.demo1.AppAction;
import com.nwoods.jgo.examples.demo1.Demo1;
import com.nwoods.jgo.examples.demo1.LimitedNode;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.border.TitledBorder;

public class Demo1View
extends JGoView
implements MouseWheelListener {
    public static final int MouseStateDrawingStroke = 101;
    private JPopupMenu myPopupMenu = new JPopupMenu();
    private Point myMouseUpDocPoint = new Point(0, 0);
    protected JGoRectangle myGhost = new JGoRectangle(new Point(0, 0), new Dimension());

    Demo1View() {
        this.setIncludingNegativeCoords(true);
        this.setHidingDisabledScrollbars(true);
        this.addMouseWheelListener(this);
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n = mouseWheelEvent.getWheelRotation();
        if (mouseWheelEvent.isControlDown()) {
            Point point = this.getViewPosition();
            Point point2 = this.viewToDocCoords(mouseWheelEvent.getPoint());
            this.setScale(this.getScale() * (1.0 + (double)n / 20.0));
            Point point3 = this.viewToDocCoords(mouseWheelEvent.getPoint());
            this.setViewPosition(point.x + point2.x - point3.x, point.y + point2.y - point3.y);
            return;
        }
        JScrollBar jScrollBar = mouseWheelEvent.isShiftDown() ? this.getHorizontalScrollBar() : this.getVerticalScrollBar();
        if (jScrollBar == null) {
            return;
        }
        int n2 = n > 0 ? 1 : -1;
        int n3 = n2 == 1 ? jScrollBar.getMinimum() : jScrollBar.getMaximum();
        int n4 = mouseWheelEvent.getScrollType() == 1 ? jScrollBar.getBlockIncrement(n2) : jScrollBar.getUnitIncrement(n2);
        int n5 = jScrollBar.getValue();
        int n6 = n5 + n2 * n4;
        n6 = n2 == 1 ? Math.max(n6, n3) : Math.min(n6, n3);
        jScrollBar.setValue(n6);
    }

    public void doCancelMouse() {
        this.myMouseUpDocPoint.x = -9999;
        this.myMouseUpDocPoint.y = -9999;
        if (this.getState() == 101) {
            this.cancelDrawingStroke();
        } else {
            super.doCancelMouse();
        }
    }

    public void onKeyEvent(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 27) {
            this.doCancelMouse();
        } else if (n == 10 && this.getState() == 101) {
            JGoStroke jGoStroke = (JGoStroke)this.getCurrentObject();
            if (jGoStroke != null && jGoStroke.getNumPoints() > 2) {
                this.finishDrawingStroke();
            } else {
                this.doCancelMouse();
            }
        } else {
            super.onKeyEvent(keyEvent);
        }
    }

    public boolean doMouseDown(int n, Point point, Point point2) {
        RecordNode recordNode;
        int n2;
        JGoObject jGoObject;
        if (this.getState() == 101) {
            this.addPointToDrawingStroke(n, point, point2);
            return true;
        }
        JGoObject jGoObject2 = this.pickDocObject(point, true);
        if (jGoObject2 != null && !(jGoObject = jGoObject2).isDraggable() && jGoObject.getParent() != null && jGoObject.getParent() instanceof ListArea && jGoObject.getParent().getParent() != null && jGoObject.getParent().getParent() instanceof RecordNode && (n2 = (recordNode = (RecordNode)jGoObject.getParent().getParent()).findItem(jGoObject)) >= 0) {
            JGoPort jGoPort = recordNode.getLeftPort(n2);
            if (jGoPort == null) {
                jGoPort = recordNode.getRightPort(n2);
            }
            if (jGoPort != null && this.startNewLink(jGoPort, point)) {
                return true;
            }
        }
        return super.doMouseDown(n, point, point2);
    }

    public boolean doMouseMove(int n, Point point, Point point2) {
        if (this.getState() == 101) {
            this.followPointerForDrawingStroke(n, point, point2);
            return true;
        }
        return super.doMouseMove(n, point, point2);
    }

    public boolean doMouseUp(int n, Point point, Point point2) {
        JGoObject jGoObject;
        this.myMouseUpDocPoint.x = point.x;
        this.myMouseUpDocPoint.y = point.y;
        if (this.getState() == 101) {
            return false;
        }
        if ((n & 4) != 0 && (jGoObject = this.pickDocObject(point, true)) != null) {
            Serializable serializable;
            if ((n & 2) != 0) {
                serializable = this.pickDocObject(point, false);
                if (serializable != null) {
                    jGoObject = serializable;
                }
            } else {
                this.selectObject(jGoObject);
            }
            if (jGoObject instanceof JGoLink && (n & 2) == 0) {
                serializable = (JGoLink)jGoObject;
                JPopupMenu jPopupMenu = this.myPopupMenu;
                jPopupMenu.removeAll();
                AppAction appAction = new AppAction("Insert Point", (Container)this.getFrame()){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Demo1View.this.insertPointIntoLink();
                    }
                };
                jPopupMenu.add(appAction);
                if (((JGoStroke)serializable).getNumPoints() > (((JGoLink)serializable).isOrthogonal() ? 6 : 2)) {
                    AppAction appAction2 = new AppAction("Remove Segment", (Container)this.getFrame()){

                        public void actionPerformed(ActionEvent actionEvent) {
                            Demo1View.this.removeSegmentFromLink();
                        }
                    };
                    jPopupMenu.add(appAction2);
                }
                jPopupMenu.show(this, point2.x, point2.y);
            } else {
                this.doCancelMouse();
                serializable = (Demo1)this.getFrame();
                ((Demo1)serializable).callDialog(jGoObject);
            }
            return true;
        }
        return super.doMouseUp(n, point, point2);
    }

    public boolean startNewLink(JGoPort jGoPort, Point point) {
        if (jGoPort.isSelectable()) {
            return false;
        }
        return super.startNewLink(jGoPort, point);
    }

    public void startDrawingStroke() {
        this.setState(101);
        this.getDocument().startTransaction();
        this.setCurrentObject(null);
        this.setCursor(Cursor.getPredefinedCursor(1));
    }

    void cancelDrawingStroke() {
        if (!this.hasFocus()) {
            return;
        }
        if (this.getCurrentObject() != null) {
            this.removeObject(this.getCurrentObject());
            this.setCurrentObject(null);
        }
        this.setCursor(this.getDefaultCursor());
        this.getDocument().endTransaction(false);
        this.setState(0);
    }

    void addPointToDrawingStroke(int n, Point point, Point point2) {
        JGoStroke jGoStroke = (JGoStroke)this.getCurrentObject();
        if (jGoStroke == null) {
            jGoStroke = new JGoStroke();
            jGoStroke.addPoint(point);
            this.addObjectAtTail(jGoStroke);
            this.setCurrentObject(jGoStroke);
        }
        jGoStroke.addPoint(point);
    }

    void followPointerForDrawingStroke(int n, Point point, Point point2) {
        JGoStroke jGoStroke = (JGoStroke)this.getCurrentObject();
        if (jGoStroke != null) {
            int n2 = jGoStroke.getNumPoints();
            jGoStroke.setPoint(n2 - 1, point);
        }
    }

    void finishDrawingStroke() {
        JGoStroke jGoStroke = (JGoStroke)this.getCurrentObject();
        if (jGoStroke != null) {
            this.removeObject(jGoStroke);
            jGoStroke.removePoint(jGoStroke.getNumPoints() - 1);
            this.getDocument().getDefaultLayer().addObjectAtTail(jGoStroke);
            this.selectObject(jGoStroke);
            this.setCurrentObject(null);
            this.setCursor(this.getDefaultCursor());
            this.getDocument().endTransaction("created stroke");
            this.setState(0);
        }
    }

    void insertPointIntoLink() {
        if (this.getSelection().getPrimarySelection() instanceof JGoLink) {
            JGoLink jGoLink = (JGoLink)this.getSelection().getPrimarySelection();
            int n = jGoLink.getSegmentNearPoint(this.myMouseUpDocPoint);
            if (jGoLink.getNumPoints() > 3) {
                if (n < 1) {
                    n = 1;
                } else if (n >= jGoLink.getNumPoints() - 2) {
                    n = jGoLink.getNumPoints() - 3;
                }
            }
            Point point = jGoLink.getPoint(n);
            Point point2 = jGoLink.getPoint(n + 1);
            Point point3 = new Point((point.x + point2.x) / 2, (point.y + point2.y) / 2);
            this.getDocument().startTransaction();
            jGoLink.insertPoint(n + 1, point3);
            if (jGoLink.isOrthogonal()) {
                jGoLink.insertPoint(n + 1, point3);
            }
            this.getSelection().toggleSelection(jGoLink);
            this.selectObject(jGoLink);
            this.getDocument().endTransaction("inserted point into link stroke");
        }
    }

    void removeSegmentFromLink() {
        if (this.getSelection().getPrimarySelection() instanceof JGoLink) {
            JGoLink jGoLink = (JGoLink)this.getSelection().getPrimarySelection();
            int n = jGoLink.getSegmentNearPoint(this.myMouseUpDocPoint);
            this.getDocument().startTransaction();
            if (jGoLink.isOrthogonal()) {
                n = Math.max(n, 2);
                n = Math.min(n, jGoLink.getNumPoints() - 5);
                Point point = jGoLink.getPoint(n);
                Point point2 = jGoLink.getPoint(n + 1);
                jGoLink.removePoint(n);
                jGoLink.removePoint(n);
                Point point3 = new Point(jGoLink.getPoint((int)n).x, jGoLink.getPoint((int)n).y);
                if (point.x == point2.x) {
                    point3.y = point.y;
                } else {
                    point3.x = point.x;
                }
                jGoLink.setPoint(n, point3);
            } else {
                n = Math.max(n, 1);
                n = Math.min(n, jGoLink.getNumPoints() - 2);
                jGoLink.removePoint(n);
            }
            this.getSelection().toggleSelection(jGoLink);
            this.selectObject(jGoLink);
            this.getDocument().endTransaction("removed segment from link stroke");
        }
    }

    public boolean doMouseDblClick(int n, Point point, Point point2) {
        boolean bl = super.doMouseDblClick(n, point, point2);
        if (!bl && this.pickDocObject(point, false) == null) {
            this.getDocument().startTransaction();
            LimitedNode limitedNode = new LimitedNode("limited");
            limitedNode.setLocation(point);
            this.getDocument().addObjectAtTail(limitedNode);
            this.getDocument().endTransaction("added LimitedNode in background");
        }
        return bl;
    }

    public void doBackgroundClick(int n, Point point, Point point2) {
        if ((n & 4) != 0) {
            Demo1 demo1 = (Demo1)this.getFrame();
            demo1.gridAction();
        } else {
            super.doBackgroundClick(n, point, point2);
        }
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        super.dragOver(dropTargetDragEvent);
        if (dropTargetDragEvent.getDropAction() != 0) {
            if (this.myGhost.getView() != this) {
                this.myGhost.setSize(50, 50);
                this.addObjectAtTail(this.myGhost);
            }
            this.myGhost.setTopLeft(this.viewToDocCoords(dropTargetDragEvent.getLocation()));
        }
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        if (this.myGhost.getView() == this) {
            this.removeObject(this.myGhost);
        }
        super.dragExit(dropTargetEvent);
    }

    public boolean isDropFlavorAcceptable(DropTargetDragEvent dropTargetDragEvent) {
        return super.isDropFlavorAcceptable(dropTargetDragEvent) || dropTargetDragEvent.isDataFlavorSupported(DataFlavor.stringFlavor);
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        JGoCopyEnvironment jGoCopyEnvironment = this.getDocument().createDefaultCopyEnvironment();
        this.getDocument().startTransaction();
        if (this.doDrop(dropTargetDropEvent, jGoCopyEnvironment)) {
            Iterator iterator = jGoCopyEnvironment.values().iterator();
            while (iterator.hasNext()) {
                JGoObject jGoObject;
                Object v = iterator.next();
                if (!(v instanceof JGoObject) || !(jGoObject = (JGoObject)v).isTopLevel()) continue;
                jGoObject.setTopLeft(jGoObject.getLeft() + 1, jGoObject.getTop() + 1);
            }
            this.fireUpdate(35, 0, null);
            this.getDocument().endTransaction("Drop");
            return;
        }
        try {
            if (dropTargetDropEvent.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                Transferable transferable = dropTargetDropEvent.getTransferable();
                Object object = transferable.getTransferData(DataFlavor.stringFlavor);
                dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                String string = (String)object;
                Vector vector = AppAction.allActions();
                for (int i = 0; i < vector.size(); ++i) {
                    AppAction appAction = (AppAction)vector.elementAt(i);
                    if (!appAction.toString().equals(string)) continue;
                    Point point = this.viewToDocCoords(dropTargetDropEvent.getLocation());
                    Demo1 demo1 = (Demo1)this.getFrame();
                    demo1.setDefaultLocation(point);
                    appAction.actionPerformed(null);
                    break;
                }
                this.completeDrop(dropTargetDropEvent, true);
                this.fireUpdate(35, 0, null);
                this.getDocument().endTransaction("Dropped Action");
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        dropTargetDropEvent.rejectDrop();
        this.getDocument().endTransaction(false);
    }

    public void updateBorder() {
        TitledBorder titledBorder = (TitledBorder)this.getBorder();
        String string = "Demo1 View: ";
        int n = (int)(this.getScale() * 100.0);
        string = string + String.valueOf(n);
        string = string + "%";
        titledBorder.setTitle(string);
        Insets insets = this.getInsets();
        this.paintImmediately(0, 0, this.getWidth(), insets.top);
    }

    public boolean makeLabeledLinkForPort(JGoPort jGoPort) {
        if (jGoPort.getParent() instanceof JGoBasicNode) {
            return true;
        }
        JGoArea jGoArea = jGoPort.getParent();
        return jGoArea != null && (jGoArea.getFlags() & 0x10000) != 0;
    }

    public void newLink(JGoPort jGoPort, JGoPort jGoPort2) {
        JGoLink jGoLink = null;
        if (this.makeLabeledLinkForPort(jGoPort) && this.makeLabeledLinkForPort(jGoPort2)) {
            JGoLinkLabel jGoLinkLabel;
            JGoLabeledLink jGoLabeledLink = new JGoLabeledLink(jGoPort, jGoPort2);
            jGoLink = jGoLabeledLink;
            if (!(jGoPort.getParent() instanceof JGoBasicNode)) {
                jGoLinkLabel = new JGoLinkLabel("from");
                jGoLinkLabel.setAlignment(1);
                jGoLinkLabel.setSelectable(true);
                jGoLinkLabel.setEditOnSingleClick(true);
                jGoLabeledLink.setFromLabel(jGoLinkLabel);
            }
            jGoLinkLabel = new JGoLinkLabel("middle");
            jGoLinkLabel.setAlignment(2);
            jGoLinkLabel.setSelectable(true);
            jGoLinkLabel.setEditable(true);
            jGoLinkLabel.setEditOnSingleClick(true);
            jGoLabeledLink.setMidLabel(jGoLinkLabel);
            if (!(jGoPort2.getParent() instanceof JGoBasicNode)) {
                jGoLinkLabel = new JGoLinkLabel("to");
                jGoLinkLabel.setAlignment(3);
                jGoLinkLabel.setEditOnSingleClick(true);
                jGoLabeledLink.setToLabel(jGoLinkLabel);
            }
        } else {
            jGoLink = new JGoLink(jGoPort, jGoPort2);
        }
        JGoSubGraphBase.reparentToCommonSubGraph(jGoLink, jGoPort, jGoPort2, true, jGoPort.getDocument().getLinksLayer());
        this.fireUpdate(31, 0, jGoLink);
        jGoPort.getDocument().endTransaction("new link");
    }

    public Rectangle2D.Double getPrintPageRect(Graphics2D graphics2D, PageFormat pageFormat) {
        return new Rectangle2D.Double(pageFormat.getImageableX(), pageFormat.getImageableY(), pageFormat.getImageableWidth(), pageFormat.getImageableHeight() - 20.0);
    }

    public double getPrintScale(Graphics2D graphics2D, PageFormat pageFormat) {
        return this.getScale();
    }

    public void printDecoration(Graphics2D graphics2D, PageFormat pageFormat, int n, int n2) {
        super.printDecoration(graphics2D, pageFormat, n, n2);
        String string = Integer.toString(n);
        string = string + ", ";
        string = string + Integer.toString(n2);
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(Color.black);
        Font font = graphics2D.getFont();
        graphics2D.setFont(new Font(JGoText.getDefaultFontFaceName(), 0, 10));
        graphics2D.drawString(string, (int)(pageFormat.getImageableX() + pageFormat.getImageableWidth() / 2.0), (int)(pageFormat.getImageableY() + pageFormat.getImageableHeight() - 10.0));
        graphics2D.setPaint(paint);
        graphics2D.setFont(font);
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (!this.isMouseEnabled()) {
            return null;
        }
        Point point = mouseEvent.getPoint();
        Point point2 = this.viewToDocCoords(point);
        JGoObject jGoObject = this.pickDocObject(point2, false);
        if (jGoObject != null) {
            Object object = jGoObject.getLayer().getIdentifier();
            if (object != null) {
                object = object.toString();
            }
            if (object != null) {
                return (String)object;
            }
        }
        return super.getToolTipText(mouseEvent);
    }
}

