/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.demo1;

import com.nwoods.jgo.JGoImage;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class ImagePropsDialog
extends JDialog {
    JPanel panel1 = new JPanel();
    JButton OKButton = new JButton();
    JButton CancelButton = new JButton();
    JLabel label1 = new JLabel();
    JTextField heightField = new JTextField();
    JTextField xField = new JTextField();
    JLabel label2 = new JLabel();
    JTextField yField = new JTextField();
    JLabel label3 = new JLabel();
    JCheckBox visibleBox = new JCheckBox();
    JCheckBox selectableBox = new JCheckBox();
    JCheckBox resizableBox = new JCheckBox();
    JCheckBox draggableBox = new JCheckBox();
    JLabel label4 = new JLabel();
    JTextField widthField = new JTextField();
    JLabel classNameLabel = new JLabel();
    JLabel fromLabel = new JLabel();
    JTextField location = new JTextField();
    ButtonGroup group1 = new ButtonGroup();
    JRadioButton fromFile = new JRadioButton();
    JRadioButton fromURL = new JRadioButton();
    JLabel label5 = new JLabel();
    JCheckBox transparent = new JCheckBox();
    JButton transButton = new JButton();
    public JGoImage myObject;
    private String myFile = null;
    private URL myURL = null;
    private Image myImage = null;
    private Color myColor = null;
    boolean fComponentsAdjusted = false;

    public ImagePropsDialog(Frame frame, String string, boolean bl, JGoImage jGoImage) {
        super(frame, string, bl);
        try {
            this.myObject = jGoImage;
            this.jbInit();
            this.pack();
            this.UpdateDialog();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ImagePropsDialog() {
        this((Frame)null, "", false, (JGoImage)null);
    }

    void jbInit() throws Exception {
        this.panel1.setLayout(null);
        this.panel1.setMinimumSize(new Dimension(294, 331));
        this.panel1.setPreferredSize(new Dimension(294, 331));
        this.OKButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImagePropsDialog.this.OKButton_actionPerformed(actionEvent);
            }
        });
        this.CancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImagePropsDialog.this.CancelButton_actionPerformed(actionEvent);
            }
        });
        this.transButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImagePropsDialog.this.transButton_actionPerformed(actionEvent);
            }
        });
        this.setResizable(false);
        this.getContentPane().add(this.panel1);
        this.OKButton.setText("OK");
        this.panel1.add(this.OKButton);
        this.OKButton.setFont(new Font("Dialog", 0, 12));
        this.OKButton.setBounds(new Rectangle(56, 302, 79, 22));
        this.CancelButton.setText("Cancel");
        this.panel1.add(this.CancelButton);
        this.CancelButton.setFont(new Font("Dialog", 0, 12));
        this.CancelButton.setBounds(new Rectangle(164, 302, 79, 22));
        this.label1.setText("Height:");
        this.label1.setHorizontalAlignment(4);
        this.panel1.add(this.label1);
        this.label1.setBounds(new Rectangle(132, 60, 48, 24));
        this.panel1.add(this.heightField);
        this.heightField.setBounds(new Rectangle(192, 60, 36, 24));
        this.panel1.add(this.xField);
        this.xField.setBounds(new Rectangle(84, 36, 36, 24));
        this.label2.setText("x:");
        this.label2.setHorizontalAlignment(4);
        this.panel1.add(this.label2);
        this.label2.setBounds(new Rectangle(24, 36, 48, 24));
        this.panel1.add(this.yField);
        this.yField.setBounds(new Rectangle(84, 60, 36, 24));
        this.label3.setText("y:");
        this.label3.setHorizontalAlignment(4);
        this.panel1.add(this.label3);
        this.label3.setBounds(new Rectangle(24, 60, 48, 24));
        this.visibleBox.setText("Visible");
        this.panel1.add(this.visibleBox);
        this.visibleBox.setBounds(new Rectangle(24, 96, 96, 24));
        this.selectableBox.setText("Selectable");
        this.panel1.add(this.selectableBox);
        this.selectableBox.setBounds(new Rectangle(24, 120, 96, 24));
        this.resizableBox.setText("Resizable");
        this.panel1.add(this.resizableBox);
        this.resizableBox.setBounds(new Rectangle(24, 144, 96, 24));
        this.draggableBox.setText("Draggable");
        this.panel1.add(this.draggableBox);
        this.draggableBox.setBounds(new Rectangle(24, 168, 96, 24));
        this.label4.setText("Width:");
        this.label4.setHorizontalAlignment(4);
        this.panel1.add(this.label4);
        this.label4.setBounds(new Rectangle(132, 36, 48, 24));
        this.panel1.add(this.widthField);
        this.widthField.setBounds(new Rectangle(192, 36, 36, 24));
        this.classNameLabel.setText("class name");
        this.panel1.add(this.classNameLabel);
        this.classNameLabel.setBounds(new Rectangle(23, 5, 264, 24));
        this.fromLabel.setText("Image Location:");
        this.panel1.add(this.fromLabel);
        this.fromLabel.setBounds(new Rectangle(156, 120, 100, 24));
        this.group1.add(this.fromFile);
        this.group1.add(this.fromURL);
        this.fromFile.setText("From File");
        this.panel1.add(this.fromFile);
        this.fromFile.setBounds(new Rectangle(156, 144, 100, 24));
        this.fromURL.setText("From URL");
        this.panel1.add(this.fromURL);
        this.fromURL.setBounds(new Rectangle(156, 168, 100, 24));
        this.label5.setText("URL or Pathname:");
        this.panel1.add(this.label5);
        this.label5.setBounds(new Rectangle(24, 192, 150, 24));
        this.panel1.add(this.location);
        this.location.setBounds(new Rectangle(24, 216, 246, 24));
        this.transparent.setText("Transparent Background Filled?");
        this.panel1.add(this.transparent);
        this.transparent.setBounds(new Rectangle(50, 246, 200, 24));
        this.transButton.setText("Transparent Fill Color...");
        this.panel1.add(this.transButton);
        this.transButton.setBounds(new Rectangle(64, 270, 166, 24));
    }

    void UpdateDialog() {
        if (this.myObject == null) {
            return;
        }
        this.myFile = this.myObject.getFilename();
        this.myURL = this.myObject.getURL();
        this.myImage = this.myObject.getImage();
        this.myColor = this.myObject.getTransparentColor();
        if (this.myColor != null) {
            this.transparent.setSelected(true);
        }
        this.classNameLabel.setText(this.myObject.getClass().getName());
        Rectangle rectangle = this.myObject.getBoundingRect();
        this.xField.setText(String.valueOf(rectangle.x));
        this.yField.setText(String.valueOf(rectangle.y));
        this.heightField.setText(String.valueOf(rectangle.height));
        this.widthField.setText(String.valueOf(rectangle.width));
        this.visibleBox.setSelected(this.myObject.isVisible());
        this.selectableBox.setSelected(this.myObject.isSelectable());
        this.resizableBox.setSelected(this.myObject.isResizable());
        this.draggableBox.setSelected(this.myObject.isDraggable());
        if (this.myFile != null) {
            this.location.setText(this.myFile);
            this.fromFile.setSelected(true);
        } else if (this.myURL != null) {
            this.location.setText(this.myURL.toString());
            this.fromURL.setSelected(true);
        }
    }

    void UpdateControl() {
        if (this.myObject == null) {
            return;
        }
        Rectangle rectangle = new Rectangle(Integer.parseInt(this.xField.getText()), Integer.parseInt(this.yField.getText()), Integer.parseInt(this.widthField.getText()), Integer.parseInt(this.heightField.getText()));
        this.myObject.setBoundingRect(rectangle);
        this.myObject.setVisible(this.visibleBox.isSelected());
        this.myObject.setSelectable(this.selectableBox.isSelected());
        this.myObject.setResizable(this.resizableBox.isSelected());
        this.myObject.setDraggable(this.draggableBox.isSelected());
        if (this.fromFile.isSelected()) {
            if (!this.myObject.loadImage(this.location.getText(), true)) {
                this.setPrevious();
            }
        } else {
            try {
                if (!this.myObject.loadImage(new URL(this.location.getText()), true)) {
                    this.setPrevious();
                }
            }
            catch (MalformedURLException malformedURLException) {
                this.setPrevious();
            }
        }
        if (!this.transparent.isSelected()) {
            this.myColor = null;
        }
        this.myObject.setTransparentColor(this.myColor);
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        Insets insets = this.getInsets();
        this.setSize(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height);
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Point point = componentArray[i].getLocation();
            point.translate(insets.left, insets.top);
            componentArray[i].setLocation(point);
        }
        this.fComponentsAdjusted = true;
    }

    private void setPrevious() {
        if (this.myURL != null) {
            this.myObject.loadImage(this.myURL, true);
        } else if (this.myFile != null) {
            this.myObject.loadImage(this.myFile, true);
        } else {
            this.myObject.loadImage(this.myImage, true);
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            Rectangle rectangle = this.getParent().getBounds();
            Rectangle rectangle2 = this.getBounds();
            this.setLocation(rectangle.x + (rectangle.width - rectangle2.width) / 2, rectangle.y + (rectangle.height - rectangle2.height) / 2);
        }
        super.setVisible(bl);
    }

    void OKButton_actionPerformed(ActionEvent actionEvent) {
        this.OnOK();
    }

    void OnOK() {
        try {
            this.UpdateControl();
            this.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void CancelButton_actionPerformed(ActionEvent actionEvent) {
        this.OnCancel();
    }

    void OnCancel() {
        try {
            this.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void transButton_actionPerformed(ActionEvent actionEvent) {
        Color color = JColorChooser.showDialog(this, "Transparent Color", this.myColor);
        if (color != null) {
            this.myColor = color;
        }
    }
}

