/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.demo1;

import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoEllipse;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Rectangle;

public class LinearGradientEllipse
extends JGoEllipse {
    public static final int ChangedStartColor = 66047;
    public static final int ChangedEndColor = 66048;
    private Color myStartColor = Color.white;
    private Color myEndColor = Color.gray;

    public void geometryChange(Rectangle rectangle) {
        super.geometryChange(rectangle);
        this.setBrush(null);
    }

    public JGoBrush getBrush() {
        JGoBrush jGoBrush = super.getBrush();
        if (jGoBrush == null) {
            Rectangle rectangle = this.getBoundingRect();
            jGoBrush = new JGoBrush(new GradientPaint(rectangle.x + rectangle.width / 2, rectangle.y, this.getStartColor(), rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height, this.getEndColor()));
            this.setBrush(jGoBrush);
        }
        return jGoBrush;
    }

    public Color getStartColor() {
        return this.myStartColor;
    }

    public void setStartColor(Color color) {
        Color color2 = this.myStartColor;
        if (color2 != color) {
            this.myStartColor = color;
            this.setBrush(null);
            this.update(66047, 0, color2);
        }
    }

    public Color getEndColor() {
        return this.myEndColor;
    }

    public void setEndColor(Color color) {
        Color color2 = this.myEndColor;
        if (color2 != color) {
            this.myEndColor = color;
            this.setBrush(null);
            this.update(66048, 0, color2);
        }
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit jGoDocumentChangedEdit) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 66047: {
                jGoDocumentChangedEdit.setNewValue(this.getStartColor());
                return;
            }
            case 66048: {
                jGoDocumentChangedEdit.setNewValue(this.getEndColor());
                return;
            }
        }
        super.copyNewValueForRedo(jGoDocumentChangedEdit);
    }

    public void changeValue(JGoDocumentChangedEdit jGoDocumentChangedEdit, boolean bl) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 1: {
                super.changeValue(jGoDocumentChangedEdit, bl);
                this.setBrush(null);
                break;
            }
            case 66047: {
                this.setStartColor((Color)jGoDocumentChangedEdit.getValue(bl));
                break;
            }
            case 66048: {
                this.setEndColor((Color)jGoDocumentChangedEdit.getValue(bl));
                break;
            }
            default: {
                super.changeValue(jGoDocumentChangedEdit, bl);
            }
        }
    }
}

