/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.demo1;

import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoHandle;
import com.nwoods.jgo.JGoImage;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoSelection;
import com.nwoods.jgo.JGoView;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;

public class RotImage
extends JGoImage {
    public static final int ChangedAngle = 65536;
    public static final int ChangedRotatable = 65537;
    public static final int ChangedFlipped = 65538;
    private double myAngle = 0.0;
    private boolean myFlipped = false;
    private boolean myRotatable = true;

    public RotImage() {
    }

    public RotImage(Point point, Dimension dimension) {
        super(point, dimension);
    }

    public RotImage(Rectangle rectangle) {
        super(rectangle);
    }

    public JGoObject copyObject(JGoCopyEnvironment jGoCopyEnvironment) {
        RotImage rotImage = (RotImage)super.copyObject(jGoCopyEnvironment);
        if (rotImage != null) {
            rotImage.myAngle = this.myAngle;
            rotImage.myFlipped = this.myFlipped;
        }
        return rotImage;
    }

    protected void gainedSelection(JGoSelection jGoSelection) {
        JGoHandle jGoHandle = jGoSelection.createBoundingHandle(this);
        jGoHandle.setBoundingRect(this.getBoundingRect());
        if (this.isRotatable()) {
            Rectangle rectangle = this.getBoundingRect();
            int n = rectangle.x + rectangle.width / 2;
            int n2 = rectangle.y + rectangle.height / 2;
            double d = this.getAngle();
            if (d == 0.0) {
                n += 50;
            } else if (d == 90.0) {
                n2 += 50;
            } else if (d == 180.0) {
                n -= 50;
            } else if (d == 270.0) {
                n2 -= 50;
            } else {
                double d2 = d * Math.PI / 180.0;
                n += (int)Math.rint(50.0 * Math.cos(d2));
                n2 += (int)Math.rint(50.0 * Math.sin(d2));
            }
            JGoHandle jGoHandle2 = jGoSelection.createResizeHandle(this, n - 2, n2 - 2, 101, true);
            if (jGoHandle2 != null) {
                jGoHandle2.setBrush(JGoBrush.yellow);
            }
        }
    }

    public Rectangle handleResize(Graphics2D graphics2D, JGoView jGoView, Rectangle rectangle, Point point, int n, int n2, int n3, int n4) {
        if (n == 101) {
            float f = (float)this.getLeft() + (float)this.getWidth() / 2.0f;
            float f2 = (float)this.getTop() + (float)this.getHeight() / 2.0f;
            double d = RotImage.GetAngle((float)point.x - f, (float)point.y - f2);
            double d2 = this.computeAngle(d);
            this.setAngle(d2);
            return null;
        }
        return super.handleResize(graphics2D, jGoView, rectangle, point, n, n2, n3, n4);
    }

    public double computeAngle(double d) {
        if (d >= 315.0 || d >= -45.0 && d <= 45.0) {
            return 0.0;
        }
        if (d > 45.0 && d < 135.0) {
            return 90.0;
        }
        if (d >= 135.0 && d <= 225.0) {
            return 180.0;
        }
        return 270.0;
    }

    static float GetAngle(float f, float f2) {
        float f3;
        if (f == 0.0f) {
            f3 = f2 > 0.0f ? 90.0f : 270.0f;
        } else if (f2 == 0.0f) {
            f3 = f > 0.0f ? 0.0f : 180.0f;
        } else {
            f3 = (float)(Math.atan(Math.abs(f2 / f)) * 180.0 / Math.PI);
            if (f < 0.0f) {
                f3 = f2 < 0.0f ? (f3 += 180.0f) : 180.0f - f3;
            } else if (f2 < 0.0f) {
                f3 = 360.0f - f3;
            }
        }
        return f3;
    }

    public double getAngle() {
        return this.myAngle;
    }

    public void setAngle(double d) {
        double d2 = this.myAngle;
        if (d2 != d && this.validAngle(d)) {
            this.myAngle = d;
            this.update(65536, 0, new Double(d2));
            if (!((d2 != 0.0 && d2 != 180.0 || d != 90.0 && d != 270.0) && (d2 != 90.0 && d2 != 270.0 || d != 0.0 && d != 180.0))) {
                Rectangle rectangle = this.getBoundingRect();
                this.setBoundingRect(rectangle.x + rectangle.width / 2 - rectangle.height / 2, rectangle.y + rectangle.height / 2 - rectangle.width / 2, rectangle.height, rectangle.width);
            }
        }
    }

    public boolean validAngle(double d) {
        return d == 0.0 || d == 90.0 || d == 180.0 || d == 270.0;
    }

    public boolean isFlipped() {
        return this.myFlipped;
    }

    public void setFlipped(boolean bl) {
        boolean bl2 = this.myFlipped;
        if (bl2 != bl) {
            this.myFlipped = bl;
            this.update(65538, bl2 ? 1 : 0, null);
        }
    }

    public boolean isRotatable() {
        return this.myRotatable;
    }

    public void setRotatable(boolean bl) {
        boolean bl2 = this.myRotatable;
        if (bl2 != bl) {
            this.myRotatable = bl;
            this.update(65537, bl2 ? 1 : 0, null);
        }
    }

    public void paint(Graphics2D graphics2D, JGoView jGoView) {
        if (this.getImage() == null) {
            if (this.getURL() != null) {
                this.loadImage(this.getURL(), false);
            } else if (this.getFilename() != null) {
                this.loadImage(this.getFilename(), false);
            }
        }
        if (this.getImage() != null) {
            Rectangle rectangle = this.getBoundingRect();
            Dimension dimension = this.getNaturalSize();
            AffineTransform affineTransform = new AffineTransform();
            double d = this.getAngle() * Math.PI / 180.0;
            affineTransform.translate(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
            affineTransform.rotate(d);
            if (this.isFlipped()) {
                affineTransform.scale(1.0, -1.0);
            }
            if (d == 0.0 || d == 180.0) {
                affineTransform.scale((double)rectangle.width / (double)dimension.width, (double)rectangle.height / (double)dimension.height);
            } else {
                affineTransform.scale((double)rectangle.height / (double)dimension.width, (double)rectangle.width / (double)dimension.height);
            }
            affineTransform.translate(-dimension.width / 2, -dimension.height / 2);
            graphics2D.drawImage(this.getImage(), affineTransform, this);
        }
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit jGoDocumentChangedEdit) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 65536: {
                jGoDocumentChangedEdit.setNewValue(new Double(this.getAngle()));
                return;
            }
            case 65537: {
                jGoDocumentChangedEdit.setNewValueBoolean(this.isRotatable());
                return;
            }
            case 65538: {
                jGoDocumentChangedEdit.setNewValueBoolean(this.isFlipped());
                return;
            }
        }
        super.copyNewValueForRedo(jGoDocumentChangedEdit);
    }

    public void changeValue(JGoDocumentChangedEdit jGoDocumentChangedEdit, boolean bl) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 65536: {
                this.setAngle((Double)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
            case 65537: {
                this.setRotatable(jGoDocumentChangedEdit.getValueBoolean(bl));
                return;
            }
            case 65538: {
                this.setFlipped(jGoDocumentChangedEdit.getValueBoolean(bl));
                return;
            }
        }
        super.changeValue(jGoDocumentChangedEdit, bl);
    }
}

