/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.demo1;

import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoHandle;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoSelection;
import com.nwoods.jgo.JGoText;
import com.nwoods.jgo.JGoView;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.io.Serializable;

public class RotText
extends JGoText {
    public static final int ChangedAngle = 65536;
    public static final int ChangedRotatable = 65537;
    private double myAngle = 0.0;
    private boolean myRotatable = true;
    private transient Rectangle myRealBounds = null;
    private transient Shape myShape = null;

    public RotText() {
        this.setResizable(true);
    }

    public JGoObject copyObject(JGoCopyEnvironment jGoCopyEnvironment) {
        RotText rotText = (RotText)super.copyObject(jGoCopyEnvironment);
        if (rotText != null) {
            rotText.myAngle = this.myAngle;
        }
        return rotText;
    }

    public void paint(Graphics2D graphics2D, JGoView jGoView) {
        double d = this.getAngle();
        if (d != 0.0) {
            d = d * Math.PI / 180.0;
            Rectangle rectangle = this.getBoundingRect();
            graphics2D.rotate(d, rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
            super.paint(graphics2D, jGoView);
            graphics2D.rotate(-d, rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
        } else {
            super.paint(graphics2D, jGoView);
        }
    }

    public void expandRectByPenWidth(Rectangle rectangle) {
        if (this.getAngle() != 0.0) {
            rectangle.setBounds(this.getRealBounds());
        }
        super.expandRectByPenWidth(rectangle);
    }

    public void setBoundingRect(int n, int n2, int n3, int n4) {
        super.setBoundingRect(n, n2, n3, n4);
        this.clearRealBounds();
    }

    public boolean isPointInObj(Point point) {
        if (this.getAngle() != 0.0) {
            this.getRealBounds();
            return this.myShape.contains(point);
        }
        return super.isPointInObj(point);
    }

    protected void gainedSelection(JGoSelection jGoSelection) {
        Serializable serializable;
        if (this.isSelectBackground()) {
            this.setTransparent(false);
        } else {
            serializable = jGoSelection.createBoundingHandle(this);
            serializable.setBoundingRect(this.getRealBounds());
        }
        if (this.isRotatable()) {
            serializable = this.getBoundingRect();
            int n = ((Rectangle)serializable).x + ((Rectangle)serializable).width / 2;
            int n2 = ((Rectangle)serializable).y + ((Rectangle)serializable).height / 2;
            double d = this.getAngle();
            if (d == 0.0) {
                n += 50;
            } else if (d == 90.0) {
                n2 += 50;
            } else if (d == 180.0) {
                n -= 50;
            } else if (d == 270.0) {
                n2 -= 50;
            } else {
                double d2 = d * Math.PI / 180.0;
                n += (int)Math.rint(50.0 * Math.cos(d2));
                n2 += (int)Math.rint(50.0 * Math.sin(d2));
            }
            JGoHandle jGoHandle = jGoSelection.createResizeHandle(this, n - 2, n2 - 2, 101, true);
            if (jGoHandle != null) {
                jGoHandle.setBrush(JGoBrush.yellow);
            }
        }
    }

    public Rectangle handleResize(Graphics2D graphics2D, JGoView jGoView, Rectangle rectangle, Point point, int n, int n2, int n3, int n4) {
        if (n == 101) {
            float f = (float)this.getLeft() + (float)this.getWidth() / 2.0f;
            float f2 = (float)this.getTop() + (float)this.getHeight() / 2.0f;
            double d = RotText.GetAngle((float)point.x - f, (float)point.y - f2);
            double d2 = this.computeAngle(d);
            this.setAngle(d2);
            return null;
        }
        return super.handleResize(graphics2D, jGoView, rectangle, point, n, n2, n3, n4);
    }

    public double computeAngle(double d) {
        return (int)d / 10 * 10;
    }

    static float GetAngle(float f, float f2) {
        float f3;
        if (f == 0.0f) {
            f3 = f2 > 0.0f ? 90.0f : 270.0f;
        } else if (f2 == 0.0f) {
            f3 = f > 0.0f ? 0.0f : 180.0f;
        } else {
            f3 = (float)(Math.atan(Math.abs(f2 / f)) * 180.0 / Math.PI);
            if (f < 0.0f) {
                f3 = f2 < 0.0f ? (f3 += 180.0f) : 180.0f - f3;
            } else if (f2 < 0.0f) {
                f3 = 360.0f - f3;
            }
        }
        return f3;
    }

    public double getAngle() {
        return this.myAngle;
    }

    public void setAngle(double d) {
        double d2 = this.myAngle;
        if (d2 != d) {
            this.myAngle = d;
            this.update(65536, 0, new Double(d2));
            this.clearRealBounds();
        }
    }

    public boolean isRotatable() {
        return this.myRotatable;
    }

    public void setRotatable(boolean bl) {
        boolean bl2 = this.myRotatable;
        if (bl2 != bl) {
            this.myRotatable = bl;
            this.update(65537, bl2 ? 1 : 0, null);
        }
    }

    public Rectangle getRealBounds() {
        if (this.myRealBounds == null) {
            this.updateRealBounds(this.getBoundingRect());
        }
        return this.myRealBounds;
    }

    private void clearRealBounds() {
        this.myRealBounds = null;
        this.myShape = null;
    }

    private void updateRealBounds(Rectangle rectangle) {
        double d = this.getAngle() * Math.PI / 180.0;
        int n = rectangle.x + rectangle.width / 2;
        int n2 = rectangle.y + rectangle.height / 2;
        AffineTransform affineTransform = AffineTransform.getRotateInstance(d, n, n2);
        Rectangle rectangle2 = new Rectangle(rectangle);
        this.myShape = affineTransform.createTransformedShape(rectangle2);
        this.myRealBounds = this.myShape.getBounds();
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit jGoDocumentChangedEdit) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 65536: {
                jGoDocumentChangedEdit.setNewValue(new Double(this.getAngle()));
                return;
            }
            case 65537: {
                jGoDocumentChangedEdit.setNewValueBoolean(this.isRotatable());
                return;
            }
        }
        super.copyNewValueForRedo(jGoDocumentChangedEdit);
    }

    public void changeValue(JGoDocumentChangedEdit jGoDocumentChangedEdit, boolean bl) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 65536: {
                this.setAngle(jGoDocumentChangedEdit.getValueDouble(bl));
                return;
            }
            case 65537: {
                this.setRotatable(jGoDocumentChangedEdit.getValueBoolean(bl));
                return;
            }
        }
        super.changeValue(jGoDocumentChangedEdit, bl);
    }
}

